/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ptolemy.actor.lib.Sink;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.RecordToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.SharedParameter;
import ptolemy.util.StringUtilities;

public class NonStrictTest
extends Sink {
    public Parameter correctValues = new Parameter(this, "correctValues");
    public Parameter tolerance;
    public SharedParameter trainingMode;
    public static final String TRAINING_MODE_ERROR_MESSAGE = "Training Mode set for test actor and isRunningNightlyBuild()\n  returned true, indicating that the\n  ptolemy.ptII.isRunningNightlyBuild property is set.\n  The trainingMode parameter should not be set in files\n  that are checked into the nightly build!  To run the tests in nightly build mode, use     make nightly";
    protected int _numberOfInputTokensSeen = 0;
    protected double _tolerance;
    protected int _iteration;
    protected List _trainingTokens;
    protected boolean _firedOnce = false;
    protected boolean _initialized = false;

    public NonStrictTest(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.correctValues.setExpression("{true}");
        this.correctValues.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.tolerance = new Parameter(this, "tolerance");
        this.tolerance.setExpression("1.0E-9");
        this.tolerance.setTypeEquals(BaseType.DOUBLE);
        this.trainingMode = new SharedParameter((NamedObj)this, "trainingMode", this.getClass(), "false");
        this.trainingMode.setTypeEquals(BaseType.BOOLEAN);
        this.input.setMultiport(false);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        NonStrictTest newObject = (NonStrictTest)super.clone(workspace);
        newObject.correctValues.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        return newObject;
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.tolerance) {
            this._tolerance = ((DoubleToken)this.tolerance.getToken()).doubleValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._firedOnce = true;
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._numberOfInputTokensSeen = 0;
        this._iteration = 0;
        this._trainingTokens = null;
        this._firedOnce = false;
        this._initialized = true;
        if (((BooleanToken)this.trainingMode.getToken()).booleanValue()) {
            if (NonStrictTest.isRunningNightlyBuild()) {
                throw new IllegalActionException((Nameable)this, TRAINING_MODE_ERROR_MESSAGE);
            }
            System.err.println("Warning: '" + this.getFullName() + "' is in training mode, set the trainingMode " + "parameter to false before checking in");
        }
    }

    public static boolean isRunningNightlyBuild() {
        return StringUtilities.getProperty("ptolemy.ptII.isRunningNightlyBuild").length() > 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this.input.getWidth() != 1) {
            throw new IllegalActionException((Nameable)this, "Width of input is " + this.input.getWidth() + " but NonStrictTest only supports a width of 1.");
        }
        boolean training = ((BooleanToken)this.trainingMode.getToken()).booleanValue();
        if (training) {
            if (this._trainingTokens == null) {
                this._trainingTokens = new ArrayList();
            }
            if (this.input.hasToken(0)) {
                this._trainingTokens.add(this.input.get(0));
            }
            return true;
        }
        if (this._numberOfInputTokensSeen >= ((ArrayToken)this.correctValues.getToken()).length()) {
            if (this.input.hasToken(0)) {
                this.input.get(0);
            }
            return true;
        }
        Token referenceToken = ((ArrayToken)this.correctValues.getToken()).getElement(this._numberOfInputTokensSeen);
        if (this.input.hasToken(0)) {
            Token token = this.input.get(0);
            ++this._numberOfInputTokensSeen;
            if (!(token.isCloseTo(referenceToken, this._tolerance).booleanValue() || referenceToken.isNil() || NonStrictTest._isCloseToIfNilArrayElement(token, referenceToken, this._tolerance) || NonStrictTest._isCloseToIfNilRecordElement(token, referenceToken, this._tolerance))) {
                throw new IllegalActionException((Nameable)this, "Test fails in iteration " + this._iteration + ".\n" + "Value was: " + token + ". Should have been: " + referenceToken);
            }
        }
        ++this._iteration;
        return true;
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        boolean training = ((BooleanToken)this.trainingMode.getToken()).booleanValue();
        if (!training && this._initialized) {
            String errorMessage;
            if (!this._firedOnce) {
                errorMessage = "The fire() method of this actor was never called. Usually, this is an error indicating that starvation is occurring.";
                String fireCompatProperty = "ptolemy.actor.lib.NonStrictTest.fire.compat";
                if (StringUtilities.getProperty(fireCompatProperty).length() > 0) {
                    System.err.println("Warning: '" + this.getFullName() + "' " + errorMessage + "\nThis error is being ignored because " + "the " + fireCompatProperty + "property was set.");
                } else {
                    throw new IllegalActionException((Nameable)this, errorMessage);
                }
            }
            if (this._numberOfInputTokensSeen < ((ArrayToken)this.correctValues.getToken()).length()) {
                errorMessage = "The test produced only " + this._numberOfInputTokensSeen + " tokens, yet the correctValues parameter was " + "expecting " + ((ArrayToken)this.correctValues.getToken()).length() + " tokens.";
                System.err.println("Warning: '" + this.getFullName() + "' " + errorMessage);
            }
        }
        this._initialized = false;
        if (training && this._trainingTokens != null && this._trainingTokens.size() > 0) {
            Object[] newValues = this._trainingTokens.toArray();
            int width = this.input.getWidth();
            Token[] newTokens = new Token[newValues.length];
            if (width == 1) {
                for (int i = 0; i < newValues.length; ++i) {
                    newTokens[i] = newValues[i] instanceof Token[] ? new ArrayToken((Token[])newValues[i]) : (Token)newValues[i];
                }
            } else {
                for (int i = 0; i < newValues.length; ++i) {
                    ArrayList entry = (ArrayList)newValues[i];
                    if (entry.size() < 1) {
                        System.err.println("Warning: '" + this.getFullName() + "': Unable to train. " + "Zero tokens received in iteration " + i);
                        return;
                    }
                    Object[] entries = entry.toArray();
                    Token[] newEntry = new Token[entries.length];
                    for (int j = 0; j < entries.length; ++j) {
                        newEntry[j] = (Token)entries[j];
                    }
                    newTokens[i] = new ArrayToken(newEntry);
                }
            }
            this.correctValues.setToken(new ArrayToken(newTokens));
            this.correctValues.setPersistent(true);
        }
        if (training && (this._trainingTokens == null || this._trainingTokens.size() == 0)) {
            System.err.println("Warning: '" + this.getFullName() + "' The test produced 0 tokens.");
            this.correctValues.setToken(ArrayToken.NIL);
        }
    }

    protected static boolean _isCloseToIfNilArrayElement(Token token1, Token token2, double epsilon) throws IllegalActionException {
        if (!(token1 instanceof ArrayToken) || !(token2 instanceof ArrayToken)) {
            return false;
        }
        ArrayToken array1 = (ArrayToken)token1;
        ArrayToken array2 = (ArrayToken)token2;
        if (array1.length() != array2.length()) {
            return false;
        }
        for (int i = 0; i < array1.length(); ++i) {
            BooleanToken result = array1.getElement(i).isCloseTo(array2.getElement(i), epsilon);
            if (result.booleanValue() || array1.getElement(i).isNil() && array2.getElement(i).isNil()) continue;
            return false;
        }
        return true;
    }

    protected static boolean _isCloseToIfNilRecordElement(Token token1, Token token2, double epsilon) throws IllegalActionException {
        Set argLabelSet;
        if (!(token1 instanceof RecordToken) || !(token2 instanceof RecordToken)) {
            return false;
        }
        RecordToken record1 = (RecordToken)token1;
        RecordToken record2 = (RecordToken)token2;
        Set myLabelSet = record1.labelSet();
        if (!((Object)myLabelSet).equals(argLabelSet = record2.labelSet())) {
            return false;
        }
        for (String label : myLabelSet) {
            Token innerToken1 = record1.get(label);
            Token innerToken2 = record2.get(label);
            boolean result = false;
            result = innerToken1 instanceof ArrayToken ? NonStrictTest._isCloseToIfNilArrayElement(innerToken1, innerToken2, epsilon) : (innerToken1 instanceof RecordToken ? NonStrictTest._isCloseToIfNilRecordElement(innerToken1, innerToken2, epsilon) : innerToken1.isCloseTo(innerToken2, epsilon).booleanValue());
            if (result || innerToken1.isNil() && innerToken2.isNil()) continue;
            return false;
        }
        return true;
    }
}

