/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.RecordToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.MonotonicFunction;
import ptolemy.data.type.RecordType;
import ptolemy.data.type.Type;
import ptolemy.graph.Inequality;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class RecordUpdater
extends TypedAtomicActor {
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);

    public RecordUpdater(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"0\" y=\"0\" width=\"6\" height=\"40\" style=\"fill:red\"/>\n</svg>\n");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        RecordUpdater newObject = (RecordUpdater)super.clone(workspace);
        TypedIOPort typedIOPort = newObject.output;
        RecordUpdater recordUpdater = newObject;
        recordUpdater.getClass();
        typedIOPort.setTypeAtLeast(recordUpdater.new FunctionTerm());
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        Director director = this.getDirector();
        if (director == null) {
            throw new IllegalActionException((Nameable)this, "No director!");
        }
        HashMap<String, Token> outputMap = new HashMap<String, Token>();
        RecordToken record = (RecordToken)this.input.get(0);
        Set recordLabels = record.labelSet();
        for (String name : recordLabels) {
            Token value = record.get(name);
            outputMap.put(name, value);
        }
        List inputPorts = this.inputPortList();
        for (TypedIOPort inputPort : inputPorts) {
            if (inputPort == this.input) continue;
            outputMap.put(inputPort.getName(), inputPort.get(0));
        }
        String[] labels = new String[outputMap.size()];
        Token[] values = new Token[outputMap.size()];
        int j = 0;
        for (Map.Entry entry : outputMap.entrySet()) {
            labels[j] = (String)entry.getKey();
            values[j] = (Token)entry.getValue();
            ++j;
        }
        RecordToken result = new RecordToken(labels, values);
        this.output.send(0, result);
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        for (IOPort port : this.inputPortList()) {
            if (port.hasToken(0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List typeConstraintList() {
        String[] labels = new String[]{};
        Type[] types = new Type[]{};
        RecordType declaredType = new RecordType(labels, types);
        this.input.setTypeAtMost(declaredType);
        LinkedList<Inequality> constraints = new LinkedList<Inequality>();
        Inequality inequality = new Inequality(new FunctionTerm(), this.output.getTypeTerm());
        constraints.add(inequality);
        return constraints;
    }

    private class FunctionTerm
    extends MonotonicFunction {
        private FunctionTerm() {
        }

        @Override
        public Object getValue() {
            Type inputType = RecordUpdater.this.input.getType();
            if (!(inputType instanceof RecordType)) {
                return BaseType.UNKNOWN;
            }
            RecordType recordType = (RecordType)inputType;
            HashMap<String, Type> outputMap = new HashMap<String, Type>();
            Set recordLabels = recordType.labelSet();
            for (String label : recordLabels) {
                Type type = recordType.get(label);
                outputMap.put(label, type);
            }
            List inputPorts = RecordUpdater.this.inputPortList();
            for (TypedIOPort port : inputPorts) {
                if (port == RecordUpdater.this.input) continue;
                outputMap.put(port.getName(), port.getType());
            }
            Object[] labelsObj = outputMap.keySet().toArray();
            String[] labels = new String[labelsObj.length];
            Type[] types = new Type[labelsObj.length];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = (String)labelsObj[i];
                types[i] = (Type)outputMap.get(labels[i]);
            }
            return new RecordType(labels, types);
        }

        @Override
        public InequalityTerm[] getVariables() {
            Iterator inputPorts = RecordUpdater.this.inputPortList().iterator();
            LinkedList<InequalityTerm> result = new LinkedList<InequalityTerm>();
            while (inputPorts.hasNext()) {
                TypedIOPort port = (TypedIOPort)inputPorts.next();
                InequalityTerm term = port.getTypeTerm();
                if (!term.isSettable()) continue;
                result.add(term);
            }
            InequalityTerm[] variables = new InequalityTerm[result.size()];
            Iterator results = result.iterator();
            int i = 0;
            while (results.hasNext()) {
                variables[i] = (InequalityTerm)results.next();
                ++i;
            }
            return variables;
        }
    }
}

