/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class DeScrambler
extends Transformer {
    public Parameter polynomial = new Parameter(this, "polynomial");
    public Parameter initialState;
    private int _shiftReg;
    private int _latestShiftReg;

    public DeScrambler(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.polynomial.setTypeEquals(BaseType.INT);
        this.polynomial.setExpression("0440001");
        this.initialState = new Parameter(this, "initialState");
        this.initialState.setTypeEquals(BaseType.INT);
        this.initialState.setExpression("1");
        this.input.setTypeEquals(BaseType.BOOLEAN);
        this.output.setTypeEquals(BaseType.BOOLEAN);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.polynomial) {
            int mask = ((IntToken)this.polynomial.getToken()).intValue();
            if (mask <= 0) {
                throw new IllegalActionException((Nameable)this, "Polynomial is required to be strictly positive.");
            }
            if ((mask & 1) == 0) {
                throw new IllegalActionException((Nameable)this, "The low-order bit of the the polynomial is not set.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._latestShiftReg = this._shiftReg;
        int mask = ((IntToken)this.polynomial.getToken()).intValue();
        BooleanToken inputToken = (BooleanToken)this.input.get(0);
        boolean inputTokenValue = inputToken.booleanValue();
        int reg = this._latestShiftReg << 1;
        int parity = 0;
        for (int masked = mask & (reg ^= inputTokenValue ? 1 : 0); masked > 0; masked >>= 1) {
            parity ^= masked & 1;
        }
        this._latestShiftReg = reg;
        if (parity == 1) {
            this.output.broadcast(BooleanToken.TRUE);
        } else {
            this.output.broadcast(BooleanToken.FALSE);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._latestShiftReg = this._shiftReg = ((IntToken)this.initialState.getToken()).intValue();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._shiftReg = this._latestShiftReg;
        return super.postfire();
    }
}

