/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import java.util.LinkedList;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class HuffmanBasic
extends Transformer {
    public Parameter pmf = new Parameter(this, "pmf");
    public Parameter alphabet;
    public TypedIOPort huffmanCodeBook;
    protected String[] _codeBook;
    protected boolean _parametersInvalid;
    protected double[] _pmf;

    public HuffmanBasic(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.pmf.setExpression("{0.5, 0.5}");
        this.pmf.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.alphabet = new Parameter(this, "alphabet");
        this.alphabet.setExpression("{0, 1}");
        this.alphabet.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.huffmanCodeBook = new TypedIOPort(this, "huffmanCodeBook", false, true);
        this.huffmanCodeBook.setTypeEquals(new ArrayType(BaseType.STRING));
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        HuffmanBasic newObject = (HuffmanBasic)super.clone(workspace);
        newObject.alphabet.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        return newObject;
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        this._parametersInvalid = true;
        if (attribute == this.pmf) {
            ArrayToken pmfValue = (ArrayToken)this.pmf.getToken();
            this._pmf = new double[pmfValue.length()];
            double sum = 0.0;
            for (int i = 0; i < this._pmf.length; ++i) {
                this._pmf[i] = ((DoubleToken)pmfValue.getElement(i)).doubleValue();
                if (this._pmf[i] <= 0.0) {
                    throw new IllegalActionException((Nameable)this, "Probabilities must be positive!");
                }
                sum += this._pmf[i];
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        ArrayToken alphabetArrayToken = (ArrayToken)this.alphabet.getToken();
        if (this._pmf.length != alphabetArrayToken.length()) {
            throw new IllegalActionException((Nameable)this, "uncoded alphabet and pmf are required to be arrayswith same length.");
        }
        Token[] alphabetTokens = new Token[this._pmf.length];
        for (int i = 0; i < this._pmf.length; ++i) {
            alphabetTokens[i] = alphabetArrayToken.getElement(i);
        }
        if (this._parametersInvalid) {
            this._parametersInvalid = false;
            this._codeBook = this.generateCodeBook(this._pmf);
            Token[] codeBookTokens = new StringToken[this._pmf.length];
            for (int i = 0; i < this._pmf.length; ++i) {
                codeBookTokens[i] = new StringToken(this._codeBook[i]);
            }
            this.huffmanCodeBook.send(0, new ArrayToken(BaseType.STRING, codeBookTokens));
        }
    }

    public String[] generateCodeBook(double[] pmf) {
        String[] codeBook = new String[pmf.length];
        LinkedList<Node> list = new LinkedList<Node>();
        for (int i = 0; i < this._pmf.length; ++i) {
            Node node = new Node(this._pmf[i], i);
            list.add(node);
        }
        while (list.size() > 1) {
            Node node1 = this._findMinNode(list);
            list.remove(node1);
            Node node2 = this._findMinNode(list);
            list.remove(node2);
            Node newNode = new Node(node2, node1);
            list.add(newNode);
        }
        Node root = (Node)list.get(0);
        root.huffmanCode = "";
        this._setCode(root, codeBook);
        return codeBook;
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._parametersInvalid = true;
    }

    private Node _findMinNode(LinkedList list) {
        double minProb = ((Node)list.get((int)0)).probability;
        int index = 0;
        for (int i = 1; i < list.size(); ++i) {
            if (!(((Node)list.get((int)i)).probability < minProb)) continue;
            index = i;
            minProb = ((Node)list.get((int)i)).probability;
        }
        return (Node)list.get(index);
    }

    private void _setCode(Node node, String[] codeBook) {
        Node right;
        String parentCode = node.huffmanCode;
        Node left = node.leftChild;
        if (left != null) {
            String leftCode;
            left.huffmanCode = leftCode = parentCode + "0";
            if (left.indexInArray >= 0) {
                codeBook[left.indexInArray] = leftCode;
            } else {
                this._setCode(left, codeBook);
            }
        }
        if ((right = node.rightChild) != null) {
            String rightCode;
            right.huffmanCode = rightCode = parentCode + "1";
            if (right.indexInArray >= 0) {
                codeBook[right.indexInArray] = rightCode;
            } else {
                this._setCode(right, codeBook);
            }
        }
    }

    public static class Node {
        public double probability;
        public int indexInArray;
        public Node leftChild;
        public Node rightChild;
        public String huffmanCode;

        public Node(double prob, int index) {
            this.probability = prob;
            this.indexInArray = index;
            this.leftChild = null;
            this.rightChild = null;
            this.huffmanCode = "";
        }

        public Node(Node left, Node right) {
            this.probability = left.probability + right.probability;
            this.indexInArray = -1;
            this.leftChild = left;
            this.rightChild = right;
            this.huffmanCode = "";
        }
    }
}

