/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.lib.comm.HuffmanBasic;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class HuffmanDecoder
extends HuffmanBasic {
    private String _code = "";

    public HuffmanDecoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(ArrayType.elementType(this.alphabet));
        this.input.setTypeEquals(BaseType.BOOLEAN);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        HuffmanDecoder newObject = (HuffmanDecoder)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.alphabet));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        ArrayToken alphabetArrayToken = (ArrayToken)this.alphabet.getToken();
        Token[] alphabetTokens = new Token[this._pmf.length];
        for (int i = 0; i < this._pmf.length; ++i) {
            alphabetTokens[i] = alphabetArrayToken.getElement(i);
        }
        if (!this.input.hasToken(0) && !this._code.equals("")) {
            throw new IllegalActionException((Nameable)this, "This is not a decodable code.");
        }
        BooleanToken inputToken = (BooleanToken)this.input.get(0);
        this._code = inputToken.booleanValue() ? this._code + "1" : this._code + "0";
        for (int i = 0; i < this._pmf.length; ++i) {
            if (!this._code.equals(this._codeBook[i])) continue;
            this.output.send(0, alphabetTokens[i]);
            this._code = "";
            break;
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._code = "";
    }
}

