/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.ComplexToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.math.Complex;

public class Slicer
extends Transformer {
    public Parameter table;
    public Parameter wordLength;
    private int _wordLength;
    private int _size;
    private Complex[] _table;
    private Parameter _outputRate;

    public Slicer(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.COMPLEX);
        new Parameter((NamedObj)this.input, "tokenConsumptionRate", new IntToken(1));
        this.output.setTypeEquals(BaseType.BOOLEAN);
        this._outputRate = new Parameter((NamedObj)this.output, "tokenProductionRate", new IntToken(1));
        this.table = new Parameter(this, "table");
        this.table.setTypeEquals(new ArrayType(BaseType.COMPLEX));
        this.table.setExpression("{-1.0, 1.0}");
        this.wordLength = new Parameter((NamedObj)this, "wordLength", new IntToken(1));
        this.wordLength.setTypeEquals(BaseType.INT);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        ComplexToken inputToken = (ComplexToken)this.input.get(0);
        int index = 0;
        double distance = this._computeEuclideanDistance(this._table[0], inputToken.complexValue());
        for (int i = 1; i < this._size; ++i) {
            double tempDistance = this._computeEuclideanDistance(this._table[i], inputToken.complexValue());
            if (!(tempDistance < distance)) continue;
            index = i;
            distance = tempDistance;
        }
        Token[] result = new BooleanToken[this._wordLength];
        for (int i = 0; i < this._wordLength; ++i) {
            result[i] = new BooleanToken((index & 1) == 1);
            index >>= 1;
        }
        this.output.broadcast(result, this._wordLength);
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this._wordLength = ((IntToken)this.wordLength.getToken()).intValue();
        this._outputRate.setToken(new IntToken(this._wordLength));
        ArrayToken tableToken = (ArrayToken)this.table.getToken();
        this._size = 1 << this._wordLength;
        if (tableToken.length() < this._size) {
            this._size = tableToken.length();
        }
        this._table = new Complex[this._size];
        for (int i = 0; i < this._size; ++i) {
            this._table[i] = ((ComplexToken)tableToken.getElement(i)).complexValue();
        }
    }

    private double _computeEuclideanDistance(Complex x, Complex y) {
        Complex z = x.subtract(y);
        return z.magnitude();
    }
}

