/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.SequenceActor;
import ptolemy.actor.lib.gui.Plotter;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.plot.Plot;

public class ArrayPlotter
extends Plotter
implements SequenceActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public Parameter iterationsPerUpdate;
    public Parameter xUnit;
    public Parameter xInit;
    protected double _xInit;
    protected double _xUnit;
    private int _iteration = 0;
    private int _offset;
    private ArrayToken[] _tokens;

    public ArrayPlotter(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.input.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.iterationsPerUpdate = new Parameter(this, "iterationsPerUpdate");
        this.iterationsPerUpdate.setExpression("1");
        this.xInit = new Parameter((NamedObj)this, "xInit", new DoubleToken(0.0));
        this.xInit.setTypeEquals(BaseType.DOUBLE);
        this.xUnit = new Parameter((NamedObj)this, "xUnit", new DoubleToken(1.0));
        this.xUnit.setTypeEquals(BaseType.DOUBLE);
        this.attributeChanged(this.xInit);
        this.attributeChanged(this.xUnit);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.xInit) {
            this._xInit = ((DoubleToken)this.xInit.getToken()).doubleValue();
        } else if (attribute == this.xUnit) {
            this._xUnit = ((DoubleToken)this.xUnit.getToken()).doubleValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._iteration = 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        int width = this.input.getWidth();
        this._offset = ((IntToken)this.startingDataset.getToken()).intValue();
        if (this._tokens == null || this._tokens.length != width) {
            this._tokens = new ArrayToken[width];
        }
        for (int i = width - 1; i >= 0; --i) {
            double xValue = this._xInit;
            if (!this.input.hasToken(i)) continue;
            this._tokens[i] = (ArrayToken)this.input.get(i);
            if (this._iteration != 0) continue;
            Token[] currentArray = this._tokens[i].arrayValue();
            ((Plot)this.plot).clear(i + this._offset);
            for (int j = 0; j < currentArray.length; ++j) {
                double currentValue = ((DoubleToken)currentArray[j]).doubleValue();
                ((Plot)this.plot).addPoint(i + this._offset, xValue, currentValue, true);
                xValue += this._xUnit;
            }
        }
        ++this._iteration;
        if (this._iteration == ((IntToken)this.iterationsPerUpdate.getToken()).intValue()) {
            this._iteration = 0;
        }
        return super.postfire();
    }

    @Override
    public void wrapup() throws IllegalActionException {
        if (this._tokens != null) {
            for (int i = this._tokens.length - 1; i >= 0; --i) {
                double xValue = this._xInit;
                if (this._tokens[i] == null) continue;
                Token[] currentArray = this._tokens[i].arrayValue();
                ((Plot)this.plot).clear(i + this._offset);
                for (int j = 0; j < currentArray.length; ++j) {
                    double currentValue = ((DoubleToken)currentArray[j]).doubleValue();
                    ((Plot)this.plot).addPoint(i + this._offset, xValue, currentValue, true);
                    xValue += this._xUnit;
                }
            }
        }
        super.wrapup();
    }
}

