/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.gui.Plotter;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.plot.Plot;

public class XYPlotter
extends Plotter {
    public TypedIOPort inputX = new TypedIOPort(this, "inputX", true, false);
    public TypedIOPort inputY;

    public XYPlotter(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.inputX.setMultiport(true);
        this.inputX.setTypeEquals(BaseType.DOUBLE);
        this.inputY = new TypedIOPort(this, "inputY", true, false);
        this.inputY.setMultiport(true);
        this.inputY.setTypeEquals(BaseType.DOUBLE);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightGrey\"/>\n<rect x=\"-12\" y=\"-12\" width=\"24\" height=\"24\" style=\"fill:white\"/>\n<rect x=\"2\" y=\"-18\" width=\"4\" height=\"4\" style=\"fill:grey\"/>\n<rect x=\"8\" y=\"-18\" width=\"4\" height=\"4\" style=\"fill:grey\"/>\n<rect x=\"14\" y=\"-18\" width=\"4\" height=\"4\" style=\"fill:grey\"/>\n<ellipse cx=\"-4\" cy=\"0\" rx=\"4\" ry=\"8\" style=\"stroke:red\"/>\n<ellipse cx=\"4\" cy=\"0\" rx=\"4\" ry=\"8\" style=\"stroke:red\"/>\n</svg>\n");
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        int widthY;
        int widthX = this.inputX.getWidth();
        if (widthX != (widthY = this.inputY.getWidth())) {
            throw new IllegalActionException((Nameable)this, " The number of input channels mismatch.");
        }
        int offset = ((IntToken)this.startingDataset.getToken()).intValue();
        for (int i = widthX - 1; i >= 0; --i) {
            boolean hasX = false;
            boolean hasY = false;
            double xValue = 0.0;
            double yValue = 0.0;
            if (this.inputX.hasToken(i)) {
                xValue = ((DoubleToken)this.inputX.get(i)).doubleValue();
                hasX = true;
            }
            if (this.inputY.hasToken(i)) {
                yValue = ((DoubleToken)this.inputY.get(i)).doubleValue();
                hasY = true;
            }
            if (!hasX || !hasY) continue;
            ((Plot)this.plot).addPoint(i + offset, xValue, yValue, true);
        }
        return super.postfire();
    }
}

