/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.image;

import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import ptolemy.actor.lib.Source;
import ptolemy.data.AWTImageToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class ImageReader
extends Source {
    public FileParameter fileOrURL;
    private String _fileRoot;
    private Image _image;
    private URL _url;

    public ImageReader(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals(BaseType.OBJECT);
        this.fileOrURL = new FileParameter(this, "fileOrURL");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.fileOrURL) {
            this._url = this.fileOrURL.asURL();
        }
        super.attributeChanged(attribute);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.output.broadcast(new AWTImageToken(this._image));
    }

    @Override
    public void initialize() throws IllegalActionException {
        this.attributeChanged(this.fileOrURL);
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this._url == null) {
            throw new IllegalActionException("sourceURL was null");
        }
        this._fileRoot = this._url.getFile();
        this._image = new ImageIcon(this._fileRoot).getImage();
        if (this._image.getWidth(null) == -1 && this._image.getHeight(null) == -1) {
            throw new IllegalActionException((Nameable)this, "Image size is -1 x -1.  Failed to open '" + this._fileRoot + "'");
        }
        return super.prefire();
    }
}

