/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.javasound;

import java.io.IOException;
import ptolemy.actor.lib.Sink;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.media.javasound.SoundWriter;

public class AudioWriter
extends Sink {
    public StringAttribute pathName;
    public Parameter sampleRate;
    public Parameter bitsPerSample;
    public Parameter channels;
    private SoundWriter _soundWriter;
    private int _channels;
    private int _putSampleSize;
    private double[][] _audioPutArray;
    private int _curElement;
    private Token[][] _inArray;
    private boolean _safeToInitialize = false;

    public AudioWriter(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.pathName = new StringAttribute(this, "pathName");
        this.pathName.setExpression("outfile.wav");
        this.sampleRate = new Parameter((NamedObj)this, "sampleRate", new IntToken(8000));
        this.sampleRate.setTypeEquals(BaseType.INT);
        this.bitsPerSample = new Parameter((NamedObj)this, "bitsPerSample", new IntToken(16));
        this.bitsPerSample.setTypeEquals(BaseType.INT);
        this.channels = new Parameter((NamedObj)this, "channels", new IntToken(1));
        this.channels.setTypeEquals(BaseType.INT);
        this.attributeChanged(this.channels);
        this._curElement = 0;
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.channels) {
            this._channels = ((IntToken)this.channels.getToken()).intValue();
            if (this._channels < 1) {
                throw new IllegalActionException((Nameable)this, "Attempt to set channels parameter to an illegal value of: " + this._channels + " . The value must be a " + "positive integer.");
            }
            if (this._inArray == null || this._channels != this._inArray.length) {
                this._inArray = new Token[this._channels][];
            }
            if (this._audioPutArray == null || this._channels != this._audioPutArray.length) {
                this._audioPutArray = new double[this._channels][];
            }
            for (int i = 0; i < this._channels; ++i) {
                this._audioPutArray[i] = new double[this._putSampleSize];
            }
        } else {
            super.attributeChanged(attribute);
            return;
        }
        if (this._safeToInitialize) {
            this._initializeWriter();
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._initializeWriter();
        this._safeToInitialize = true;
    }

    @Override
    public int iterate(int count) throws IllegalActionException {
        for (int j = 0; j < this._channels; ++j) {
            if (!this.input.hasToken(j, count)) {
                return 1;
            }
            this._inArray[j] = this.input.get(j, count);
        }
        for (int k = 0; k < count; ++k) {
            for (int m = 0; m < this._channels; ++m) {
                this._audioPutArray[m][this._curElement] = ((DoubleToken)this._inArray[m][k]).doubleValue();
            }
            ++this._curElement;
            if (this._curElement != this._putSampleSize) continue;
            try {
                this._soundWriter.putSamples(this._audioPutArray);
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)this, "Cannot write audio: \n" + ex.getMessage());
            }
            this._curElement = 0;
        }
        return 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        int returnVal = this.iterate(1);
        if (returnVal == 0) {
            return true;
        }
        if (returnVal == 1) {
            throw new IllegalActionException((Nameable)this, "Actor is not ready to fire.");
        }
        if (returnVal == 2) {
            return false;
        }
        return false;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this._channels = ((IntToken)this.channels.getToken()).intValue();
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        if (this._soundWriter != null) {
            try {
                this._soundWriter.closeFile();
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, "Error closing file:\n" + ex.getMessage());
            }
        }
        this._safeToInitialize = false;
    }

    private synchronized void _initializeWriter() throws IllegalActionException {
        if (this._soundWriter != null) {
            try {
                this._soundWriter.closeFile();
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, "Cannot write audio: \n" + ex.getMessage());
            }
        }
        this._putSampleSize = 64;
        for (int i = 0; i < this._channels; ++i) {
            this._audioPutArray[i] = new double[this._putSampleSize];
        }
        String pathNameString = this.pathName.getExpression();
        int sampleRateInt = ((IntToken)this.sampleRate.getToken()).intValue();
        int bitsPerSampleInt = ((IntToken)this.bitsPerSample.getToken()).intValue();
        int channelsInt = ((IntToken)this.channels.getToken()).intValue();
        int putSamplesSize = this._putSampleSize;
        this._soundWriter = new SoundWriter(pathNameString, sampleRateInt, bitsPerSampleInt, channelsInt, putSamplesSize);
        this._curElement = 0;
    }
}

