/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.Set;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public abstract class CryptographyActor
extends TypedAtomicActor {
    public StringParameter algorithm;
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public Parameter keySize;
    public TypedIOPort output;
    public StringParameter provider;
    protected String _algorithm;
    protected int _keySize;
    protected String _provider;

    public CryptographyActor(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(new ArrayType(BaseType.UNSIGNED_BYTE));
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(new ArrayType(BaseType.UNSIGNED_BYTE));
        this.algorithm = new StringParameter(this, "algorithm");
        Set<String> algorithms = Security.getAlgorithms("Cipher");
        Iterator<String> algorithmsIterator = algorithms.iterator();
        int i = 0;
        while (algorithmsIterator.hasNext()) {
            String algorithmName = algorithmsIterator.next();
            if (i == 0) {
                this.algorithm.setExpression(algorithmName);
            }
            this.algorithm.addChoice(algorithmName);
            ++i;
        }
        this.provider = new StringParameter(this, "provider");
        this.provider.setExpression("SystemDefault");
        this.provider.addChoice("SystemDefault");
        Provider[] providers = Security.getProviders();
        for (int i2 = 0; i2 < providers.length; ++i2) {
            this.provider.addChoice(providers[i2].getName());
        }
        this.keySize = new Parameter((NamedObj)this, "keySize", new IntToken(1024));
        this.keySize.setTypeEquals(BaseType.INT);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.algorithm) {
            this._algorithm = ((StringToken)this.algorithm.getToken()).stringValue();
        } else if (attribute == this.keySize) {
            this._keySize = ((IntToken)this.keySize.getToken()).intValue();
        } else if (attribute == this.provider) {
            this._provider = ((StringToken)this.provider.getToken()).stringValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        try {
            if (this.input.hasToken(0)) {
                byte[] dataBytes = ArrayToken.arrayTokenToUnsignedByteArray((ArrayToken)this.input.get(0));
                dataBytes = this._process(dataBytes);
                this.output.send(0, ArrayToken.unsignedByteArrayToArrayToken(dataBytes));
            }
        }
        catch (Throwable throwable) {
            throw new IllegalActionException((Nameable)this, throwable, "Problem sending data");
        }
    }

    protected abstract byte[] _process(byte[] var1) throws IllegalActionException;
}

