/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.security.KeyToken;
import ptolemy.actor.lib.security.SignatureActor;
import ptolemy.data.ArrayToken;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class SignatureVerifier
extends SignatureActor {
    public TypedIOPort signature = new TypedIOPort(this, "signature", true, false);
    public TypedIOPort publicKey;
    private PublicKey _publicKey;

    public SignatureVerifier(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.signature.setTypeEquals(new ArrayType(BaseType.UNSIGNED_BYTE));
        this.publicKey = new TypedIOPort(this, "publicKey", true, false);
        this.publicKey.setTypeEquals(KeyToken.KEY);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.publicKey.hasToken(0)) {
            KeyToken keyToken = (KeyToken)this.publicKey.get(0);
            this._publicKey = (PublicKey)keyToken.getValue();
        }
        if (this.input.hasToken(0) && this.signature.hasToken(0) && this._publicKey != null) {
            byte[] signatureData = ArrayToken.arrayTokenToUnsignedByteArray((ArrayToken)this.signature.get(0));
            ArrayToken inputToken = (ArrayToken)this.input.get(0);
            try {
                this._signature.initVerify(this._publicKey);
                this._signature.update(ArrayToken.arrayTokenToUnsignedByteArray(inputToken));
                if (!this._signature.verify(signatureData)) {
                    throw new IllegalActionException((Nameable)this, "Signature verification failed, potential corruption or man in the middle attack?");
                }
            }
            catch (GeneralSecurityException ex) {
                throw new IllegalActionException((Nameable)this, ex, "There was a problem with the key or signature.");
            }
            this.output.send(0, inputToken);
        }
    }
}

