/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.FixTransformer;
import ptolemy.data.FixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;
import ptolemy.math.FixPoint;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;
import ptolemy.math.Rounding;

public class FixConst
extends FixTransformer {
    public Parameter value = new Parameter(this, "value");
    public TypedIOPort trigger = null;

    public FixConst(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.value.setTypeEquals(BaseType.SCALAR);
        this.value.setExpression("0.0");
        this.trigger = new TypedIOPort(this, "trigger", true, false);
        this.trigger.setMultiport(true);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"0\" y=\"0\" width=\"60\" height=\"20\" style=\"fill:white\"/>\n</svg>\n");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        FixConst newObject = (FixConst)super.clone(workspace);
        newObject.output.setTypeEquals(BaseType.FIX);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        for (int i = 0; i < this.trigger.getWidth(); ++i) {
            if (!this.trigger.hasToken(i)) continue;
            this.trigger.get(i);
        }
        Precision precision = new Precision(((Parameter)this.getAttribute("outputPrecision")).getExpression());
        Overflow overflow = Overflow.getName(((Parameter)this.getAttribute("outputOverflow")).getExpression().toLowerCase());
        Rounding rounding = Rounding.getName(((Parameter)this.getAttribute("outputRounding")).getExpression().toLowerCase());
        FixPoint result = new FixPoint(((ScalarToken)this.value.getToken()).doubleValue(), (Quantization)new FixPointQuantization(precision, overflow, rounding));
        this.sendOutput(this.output, 0, new FixToken(result));
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this.trigger.numberOfSources() > 0) {
            for (int i = 0; i < this.trigger.getWidth(); ++i) {
                if (!this.trigger.isKnown(i) || !this.trigger.hasToken(i)) continue;
                return super.prefire();
            }
            if (this._debugging) {
                this._debug("Called prefire(), which returns false because the trigger port is connected and has no input.");
            }
            return false;
        }
        return super.prefire();
    }
}

