/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.FixToken;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.math.FixPoint;
import ptolemy.math.Precision;

public class FixToString
extends Transformer {
    public FixToString(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.FIX);
        this.output.setTypeEquals(BaseType.STRING);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            FixPoint value = ((FixToken)this.input.get(0)).fixValue();
            String string = value.bigDecimalValue().toString() + " " + value.getPrecision().toString(Precision.VHDL);
            this.output.send(0, new StringToken(string));
        }
    }
}

