/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import java.util.Iterator;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.QueuedTypedIOPort;
import ptolemy.data.FixToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Rounding;

public class FixTransformer
extends TypedAtomicActor {
    public QueuedTypedIOPort output = this.newFixOutputPort("output");

    public FixTransformer(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        Parameter synthesizable = new Parameter(this, "synthesizable");
        synthesizable.setExpression("true");
        synthesizable.setTypeEquals(BaseType.BOOLEAN);
    }

    public String getPortPrecision(IOPort port) throws IllegalActionException {
        Parameter precision = null;
        precision = (Parameter)((Entity)port.getContainer()).getAttribute(port.getName() + "Precision");
        if (precision == null) {
            throw new IllegalActionException((Nameable)this, port.getName() + " does not have an precision parameter.");
        }
        return precision.getExpression();
    }

    public void sendOutput(TypedIOPort port, int channel, Token token) throws NoRoomException, IllegalActionException {
        if (port.getType() == BaseType.FIX && token instanceof FixToken) {
            Precision precision = new Precision(((Parameter)this.getAttribute(port.getName() + "Precision")).getExpression());
            Overflow overflow = Overflow.getName(((Parameter)this.getAttribute(port.getName() + "Overflow")).getExpression().toLowerCase());
            Rounding rounding = Rounding.getName(((Parameter)this.getAttribute(port.getName() + "Rounding")).getExpression().toLowerCase());
            FixPointQuantization quantization = new FixPointQuantization(precision, overflow, rounding);
            token = ((FixToken)token).quantize(quantization);
        }
        port.send(channel, token);
    }

    public QueuedTypedIOPort newFixOutputPort(String name) throws IllegalActionException, NameDuplicationException {
        StringParameter precision = new StringParameter(this, name + "Precision");
        precision.setExpression("31:0");
        StringParameter overflow = new StringParameter(this, name + "Overflow");
        StringParameter rounding = new StringParameter(this, name + "Rounding");
        overflow.setExpression("CLIP");
        Iterator iterator = Overflow.nameIterator();
        while (iterator.hasNext()) {
            overflow.addChoice(((String)iterator.next()).toUpperCase());
        }
        rounding.setExpression("HALF_EVEN");
        iterator = Rounding.nameIterator();
        while (iterator.hasNext()) {
            rounding.addChoice(((String)iterator.next()).toUpperCase());
        }
        QueuedTypedIOPort port = new QueuedTypedIOPort(this, name, false, true);
        port.setTypeEquals(BaseType.FIX);
        return port;
    }

    protected void _checkFixTokenWidth(FixToken token, int width) throws IllegalActionException {
        if (token.fixValue().getPrecision().getNumberOfBits() != width) {
            throw new IllegalActionException((Nameable)this, "Bit width violation: " + token + " is not equal to " + width);
        }
    }

    protected void _checkFixMaxValue(FixToken token, int max) throws IllegalActionException {
        this._checkFixTokenWidth(token, Integer.toBinaryString(max).length());
    }

    protected void _setAndHideQuantizationParameters(String precisionString, String overflowString, String roundingString) {
        this._setQuantizationParameters(precisionString, overflowString, roundingString);
        this._showQuantizationParameters(false, false, false);
    }

    protected void _showQuantizationParameters(boolean showPrecision, boolean showOverflow, boolean showRounding) {
        Parameter precision = (Parameter)this.getAttribute("outputPrecision");
        precision.setVisibility(showPrecision ? Settable.FULL : Settable.NONE);
        Parameter overflow = (Parameter)this.getAttribute("outputOverflow");
        overflow.setVisibility(showOverflow ? Settable.FULL : Settable.NONE);
        Parameter rounding = (Parameter)this.getAttribute("outputRounding");
        rounding.setVisibility(showRounding ? Settable.FULL : Settable.NONE);
    }

    protected void _setQuantizationParameters(String precisionString, String overflowString, String roundingString) {
        if (precisionString != null) {
            ((Parameter)this.getAttribute("outputPrecision")).setExpression(precisionString);
        }
        if (overflowString != null) {
            ((Parameter)this.getAttribute("outputOverflow")).setExpression(overflowString);
        }
        if (roundingString != null) {
            ((Parameter)this.getAttribute("outputRounding")).setExpression(roundingString);
        }
    }
}

