/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import java.util.LinkedList;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.Token;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class QueuedTypedIOPort
extends TypedIOPort {
    private LinkedList<Token> myQueue = new LinkedList();
    private Token _oldToken = null;
    private int latency = 0;
    private Token initialToken = null;

    public QueuedTypedIOPort(ComponentEntity container, String name, boolean isInput, boolean isOutput) throws IllegalActionException, NameDuplicationException {
        super(container, name, isInput, isOutput);
    }

    public void setSize(int size, Token initialValue) {
        this.latency = size;
        this.initialToken = initialValue;
        this._createQueue();
    }

    public void resize(int size) {
        this.latency = size;
        this._createQueue();
    }

    public void clear() {
        this.myQueue.clear();
    }

    public void setInitToken(Token initialValue) {
        this.initialToken = initialValue;
        this._createQueue();
    }

    private void _createQueue() {
        this.myQueue.clear();
        this._oldToken = this.initialToken;
        for (int i = 1; i < this.latency; ++i) {
            this.myQueue.add(this.initialToken);
        }
    }

    @Override
    public void send(int channelIndex, Token token) throws IllegalActionException, NoRoomException {
        if (this.latency == 0) {
            super.send(channelIndex, token);
        } else {
            this.myQueue.add(token);
            super.send(channelIndex, this._oldToken);
            this._oldToken = this.myQueue.removeFirst();
        }
    }

    public void resend(int channelIndex) throws IllegalActionException, NoRoomException {
        if (this.latency != 0) {
            super.send(channelIndex, this._oldToken);
        }
    }
}

