/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.sched;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import ptolemy.actor.Actor;
import ptolemy.actor.sched.ScheduleElement;

public class Firing
extends ScheduleElement {
    private Actor _actor;
    private List _firing = null;

    public Firing() {
    }

    public Firing(Actor actor) {
        this._actor = actor;
    }

    @Override
    public Iterator actorIterator() {
        return new ActorIterator(this.getIterationCount());
    }

    @Override
    public Iterator firingIterator() {
        if (this._firing == null) {
            this._firing = Collections.singletonList(this);
        }
        return this._firing.iterator();
    }

    public Actor getActor() {
        return this._actor;
    }

    public void setActor(Actor actor) {
        this._incrementVersion();
        this._actor = actor;
    }

    public String toString() {
        String result = "Fire Actor " + this._actor;
        int iterationCount = this.getIterationCount();
        if (iterationCount > 1) {
            result = result + " " + iterationCount + " times";
        }
        return result;
    }

    private class ActorIterator
    implements Iterator {
        private long _startingVersion;
        private int _currentElement;
        private int _iterationCount;

        public ActorIterator(int iterationCount) {
            this._startingVersion = Firing.this._getVersion();
            this._currentElement = 0;
            this._iterationCount = iterationCount;
        }

        @Override
        public boolean hasNext() {
            if (this._startingVersion != Firing.this._getVersion()) {
                throw new ConcurrentModificationException("Schedule structure changed while iterator is active.");
            }
            return this._currentElement <= this._iterationCount;
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element to return.");
            }
            ++this._currentElement;
            return Firing.this.getActor();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

