/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.sched;

import java.util.List;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.sched.Firing;
import ptolemy.actor.sched.NotSchedulableException;
import ptolemy.actor.sched.Schedule;
import ptolemy.actor.sched.StaticSchedulingDirector;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class Scheduler
extends Attribute {
    protected static final String _DEFAULT_SCHEDULER_NAME = "Scheduler";
    private boolean _valid = false;
    private Schedule _cachedGetSchedule = null;

    public Scheduler() {
        try {
            this.setName(_DEFAULT_SCHEDULER_NAME);
        }
        catch (KernelException ex) {
            throw new InternalErrorException(this, (Throwable)ex, null);
        }
    }

    public Scheduler(Workspace workspace) {
        super(workspace);
        try {
            this.setName(_DEFAULT_SCHEDULER_NAME);
        }
        catch (KernelException ex) {
            throw new InternalErrorException(this, (Throwable)ex, null);
        }
    }

    public Scheduler(Director container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Scheduler newObject = (Scheduler)super.clone(workspace);
        newObject._valid = false;
        newObject._cachedGetSchedule = null;
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schedule getSchedule() throws IllegalActionException, NotSchedulableException {
        try {
            this.workspace().getReadAccess();
            StaticSchedulingDirector director = (StaticSchedulingDirector)this.getContainer();
            if (director == null) {
                throw new IllegalActionException((Nameable)this, "Scheduler has no director.");
            }
            CompositeActor compositeActor = (CompositeActor)director.getContainer();
            if (compositeActor == null) {
                throw new IllegalActionException((Nameable)this, "Director has no container.");
            }
            if (!this.isValid() || this._cachedGetSchedule == null) {
                this._cachedGetSchedule = this._getSchedule();
            }
            Schedule schedule = this._cachedGetSchedule;
            return schedule;
        }
        finally {
            this.workspace().doneReading();
        }
    }

    public boolean isValid() {
        return this._valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        try {
            this._workspace.getWriteAccess();
            NamedObj oldContainer = this.getContainer();
            if (oldContainer instanceof Director && oldContainer != container) {
                Scheduler previous = null;
                StaticSchedulingDirector castContainer = (StaticSchedulingDirector)oldContainer;
                for (Scheduler altScheduler : castContainer.attributeList(Scheduler.class)) {
                    if (altScheduler == this) continue;
                    previous = altScheduler;
                }
                castContainer._setScheduler(previous);
            }
            super.setContainer(container);
            if (container instanceof StaticSchedulingDirector) {
                ((StaticSchedulingDirector)container)._setScheduler(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public void setValid(boolean valid) {
        this._valid = valid;
        if (!valid) {
            this._cachedGetSchedule = null;
        }
    }

    protected Schedule _getSchedule() throws IllegalActionException, NotSchedulableException {
        StaticSchedulingDirector director = (StaticSchedulingDirector)this.getContainer();
        CompositeActor compositeActor = (CompositeActor)director.getContainer();
        List actors = compositeActor.deepEntityList();
        Schedule schedule = new Schedule();
        for (Actor actor : actors) {
            Firing firing = new Firing();
            firing.setActor(actor);
            schedule.add(firing);
        }
        return schedule;
    }
}

