/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.util;

import java.util.Iterator;
import java.util.LinkedList;
import ptolemy.actor.util.CQComparator;
import ptolemy.kernel.util.DebugListener;
import ptolemy.kernel.util.Debuggable;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;

public class CalendarQueue
implements Debuggable {
    private LinkedList _debugListeners = null;
    private boolean _debugging;
    private int _queueSizeOverThreshold = 0;
    private int _queueSizeUnderThreshold = 0;
    private int _bottomThreshold;
    private CQLinkedList[] _bucket;
    private Object _cachedMinimumBucket;
    private CQComparator _cqComparator;
    private int _indexOfMinimumBucket = 0;
    private boolean _indexOfMinimumBucketValid = false;
    private boolean _initialized = false;
    private int _logMinNumBuckets = 1;
    private int _logNumberOfBuckets;
    private int _logQueueBinCountFactor = 1;
    private Object _minimumEntry = null;
    private long _minVirtualBucket;
    private int _minBucket;
    private int _numberOfBuckets;
    private int _numberOfBucketsMask;
    private Object _previousTakenEntry = null;
    private int _queueSize = 0;
    private boolean _resizeEnabled = true;
    private static final int _RESIZE_LAG = 32;
    private static final int _SAMPLE_SIZE = 8;
    private Object[] _sampleEntries = new Object[8];
    private int _sampleEntryIndex = 0;
    private boolean _sampleValid = false;
    private int _topThreshold;

    public CalendarQueue(CQComparator comparator) {
        this._cqComparator = comparator;
    }

    public CalendarQueue(CQComparator comparator, int minNumBuckets, int binCountFactor) {
        this(comparator);
        this._logMinNumBuckets = CalendarQueue.log(minNumBuckets);
        this._logQueueBinCountFactor = CalendarQueue.log(binCountFactor);
    }

    @Override
    public void addDebugListener(DebugListener listener) {
        if (this._debugListeners == null) {
            this._debugListeners = new LinkedList();
        } else if (this._debugListeners.contains(listener)) {
            return;
        }
        this._debugListeners.add(listener);
        this._debugging = true;
    }

    public void clear() {
        this._initialized = false;
        this._queueSize = 0;
        this._indexOfMinimumBucketValid = false;
        this._cachedMinimumBucket = null;
    }

    public final Object get() throws InvalidStateException {
        if (this._indexOfMinimumBucketValid) {
            return this._cachedMinimumBucket;
        }
        int indexOfMinimum = this._getIndexOfMinimumBucket();
        Object result = this._getFromBucket(indexOfMinimum);
        this._collect(result);
        if (this._debugging) {
            this._debug("--- getting from queue: " + result);
        }
        this._cachedMinimumBucket = result;
        return result;
    }

    public boolean includes(Object entry) {
        if (this._queueSize == 0) {
            return false;
        }
        return this._bucket[this._getBinIndex(entry)].includes(entry);
    }

    public final boolean isEmpty() {
        return this._queueSize == 0;
    }

    public static int log(int value) {
        int result;
        if (value <= 0) {
            throw new ArithmeticException("CalendarQueue: Cannot take the log of a non-positive number: " + value);
        }
        if (value == 1) {
            return 0;
        }
        for (result = 1; 1 << result < value && result < 32; result <<= 1) {
        }
        return result;
    }

    public boolean put(Object entry) {
        if (this._debugging) {
            this._debug("+++ putting in queue: " + entry);
        }
        if (!this._initialized) {
            this._cqComparator.setZeroReference(entry);
            this._cqComparator.setBinWidth(null);
            this._queueSize = 0;
            this._localInit(this._logMinNumBuckets, entry);
            this._sampleValid = false;
        }
        int binNumber = this._getBinIndex(entry);
        if (this._minimumEntry == null || this._queueSize == 0 || this._cqComparator.compare(entry, this._minimumEntry) < 0) {
            this._minimumEntry = entry;
            this._minVirtualBucket = this._cqComparator.getVirtualBinNumber(entry);
            this._minBucket = this._getBinIndex(entry);
        }
        this._bucket[binNumber].insert(entry);
        ++this._queueSize;
        this._resize(true);
        return true;
    }

    public boolean remove(Object entry) {
        if (this._queueSize == 0) {
            return false;
        }
        boolean result = this._bucket[this._getBinIndex(entry)].remove(entry);
        if (result) {
            --this._queueSize;
            this._resize(false);
        }
        return result;
    }

    @Override
    public void removeDebugListener(DebugListener listener) {
        if (this._debugListeners == null) {
            return;
        }
        this._debugListeners.remove(listener);
        if (this._debugListeners.size() == 0) {
            this._debugListeners = null;
            this._debugging = false;
        }
    }

    public void setAdaptive(boolean flag) {
        this._resizeEnabled = flag;
    }

    public final int size() {
        return this._queueSize;
    }

    public final Object take() throws InvalidStateException {
        int indexOfMinimum = this._getIndexOfMinimumBucket();
        Object result = this._takeFromBucket(indexOfMinimum);
        this._collect(result);
        if (this._debugging) {
            this._debug("--- taking from queue: " + result);
        }
        return result;
    }

    public final Object[] toArray() {
        return this.toArray(Integer.MAX_VALUE);
    }

    public final Object[] toArray(int limit) {
        if (limit > this._queueSize) {
            limit = this._queueSize;
        }
        Object[] result = new Object[limit];
        if (this._queueSize == 0) {
            return result;
        }
        int index = 0;
        int currentBucket = this._minBucket;
        long virtualBucket = this._minVirtualBucket;
        long minimumNextVirtualBucket = Long.MAX_VALUE;
        boolean foundValue = false;
        int nextStartBucket = this._minBucket;
        CQCell[] bucketHead = new CQCell[this._bucket.length];
        for (int i = 0; i < this._bucket.length; ++i) {
            bucketHead[i] = this._bucket[i].head;
        }
        while (true) {
            if (bucketHead[currentBucket] != null) {
                long nextVirtualBucket;
                Object nextInBucket = bucketHead[currentBucket].contents;
                while (this._cqComparator.getVirtualBinNumber(nextInBucket) == virtualBucket) {
                    result[index] = nextInBucket;
                    if (++index == limit) {
                        return result;
                    }
                    bucketHead[currentBucket] = bucketHead[currentBucket].next;
                    if (bucketHead[currentBucket] == null) break;
                    nextInBucket = bucketHead[currentBucket].contents;
                }
                if ((nextVirtualBucket = this._cqComparator.getVirtualBinNumber(nextInBucket)) < minimumNextVirtualBucket || nextVirtualBucket == Long.MAX_VALUE) {
                    foundValue = true;
                    minimumNextVirtualBucket = nextVirtualBucket;
                    nextStartBucket = currentBucket;
                }
            }
            ++virtualBucket;
            if (++currentBucket == this._numberOfBuckets) {
                currentBucket = 0;
            }
            if (currentBucket != nextStartBucket) continue;
            if (!foundValue) {
                throw new InternalErrorException("Queue is empty, but size() is not zero! It is: " + this._queueSize);
            }
            virtualBucket = minimumNextVirtualBucket;
            foundValue = false;
            minimumNextVirtualBucket = Long.MAX_VALUE;
        }
    }

    private void _collect(Object entry) {
        if (this._previousTakenEntry == null || this._cqComparator.compare(entry, this._previousTakenEntry) > 0) {
            this._sampleEntries[this._sampleEntryIndex++] = entry;
            if (this._sampleEntryIndex == 8) {
                this._sampleEntryIndex = 0;
                this._sampleValid = true;
            }
            this._previousTakenEntry = entry;
        }
    }

    private final void _debug(String message) {
        if (this._debugListeners == null || !this._debugging) {
            return;
        }
        Iterator listeners = this._debugListeners.iterator();
        while (listeners.hasNext()) {
            ((DebugListener)listeners.next()).message(message);
        }
    }

    private int _getBinIndex(Object entry) {
        long i = this._cqComparator.getVirtualBinNumber(entry);
        return (int)(i &= (long)this._numberOfBucketsMask);
    }

    private Object _getFromBucket(int index) {
        return this._bucket[index].head.contents;
    }

    private int _getIndexOfMinimumBucket() {
        block9: {
            if (this._queueSize == 0) {
                throw new InvalidStateException("Queue is empty.");
            }
            if (this._indexOfMinimumBucketValid) {
                return this._indexOfMinimumBucket;
            }
            int i = this._minBucket;
            int j = 0;
            int indexOfMinimum = i;
            Object minSoFar = null;
            do {
                if (!this._bucket[i].isEmpty()) {
                    Object minimumInBucket = this._bucket[i].head.contents;
                    if (this._cqComparator.getVirtualBinNumber(minimumInBucket) == this._minVirtualBucket + (long)j) {
                        this._indexOfMinimumBucket = i;
                        break block9;
                    }
                    if (minSoFar == null) {
                        minSoFar = minimumInBucket;
                        indexOfMinimum = i;
                    } else if (this._cqComparator.compare(minimumInBucket, minSoFar) < 0) {
                        minSoFar = minimumInBucket;
                        indexOfMinimum = i;
                    }
                }
                ++j;
                if (++i != this._numberOfBuckets) continue;
                i = 0;
            } while (i != this._minBucket);
            if (minSoFar == null) {
                throw new InternalErrorException("Queue is empty, but size() is not zero!");
            }
            this._indexOfMinimumBucket = indexOfMinimum;
        }
        this._indexOfMinimumBucketValid = true;
        return this._indexOfMinimumBucket;
    }

    private void _localInit(int logNumberOfBuckets, Object firstEntry) {
        this._logNumberOfBuckets = logNumberOfBuckets;
        this._numberOfBuckets = 1 << logNumberOfBuckets;
        this._numberOfBucketsMask = this._numberOfBuckets - 1;
        int numberOfBuckets = 1 << this._logNumberOfBuckets;
        this._bucket = new CQLinkedList[numberOfBuckets];
        for (int i = 0; i < numberOfBuckets; ++i) {
            this._bucket[i] = new CQLinkedList();
        }
        this._minimumEntry = firstEntry;
        this._minVirtualBucket = this._cqComparator.getVirtualBinNumber(firstEntry);
        this._minBucket = this._getBinIndex(firstEntry);
        this._bottomThreshold = this._numberOfBuckets >> this._logQueueBinCountFactor;
        this._topThreshold = this._numberOfBuckets << this._logQueueBinCountFactor;
        this._queueSizeUnderThreshold = 0;
        this._queueSizeOverThreshold = 0;
        this._initialized = true;
    }

    private void _resize(boolean increasing) {
        this._indexOfMinimumBucketValid = false;
        if (!this._resizeEnabled) {
            return;
        }
        int logNewSize = this._logNumberOfBuckets;
        boolean resize = false;
        if (increasing) {
            if (this._queueSize > this._topThreshold) {
                ++this._queueSizeOverThreshold;
            }
            if (this._queueSizeOverThreshold > 32) {
                resize = true;
                this._queueSizeOverThreshold = 0;
                logNewSize = this._logNumberOfBuckets + this._logQueueBinCountFactor;
                if (this._debugging) {
                    this._debug(">>>>>> increasing number of buckets to: " + (1 << logNewSize));
                }
            }
        } else {
            if (this._queueSize < this._bottomThreshold) {
                ++this._queueSizeUnderThreshold;
            }
            if (this._queueSizeUnderThreshold > 32) {
                resize = true;
                this._queueSizeUnderThreshold = 0;
                int tempLogNewSize = this._logNumberOfBuckets - this._logQueueBinCountFactor;
                if (tempLogNewSize > this._logMinNumBuckets) {
                    logNewSize = tempLogNewSize;
                    if (this._debugging) {
                        this._debug(">>>>>> decreasing number of buckets to: " + (1 << logNewSize));
                    }
                }
            }
        }
        if (!resize) {
            return;
        }
        if (this._sampleValid) {
            Object[] sampleCopy = new Object[8];
            for (int i = 0; i < 8; ++i) {
                sampleCopy[i] = this._sampleEntries[this._sampleEntryIndex++];
                if (this._sampleEntryIndex != 8) continue;
                this._sampleEntryIndex = 0;
            }
            this._cqComparator.setBinWidth(sampleCopy);
            if (this._debugging) {
                this._debug(">>> changing bin width.");
            }
        }
        CQLinkedList[] old_bucket = this._bucket;
        int old_numberOfBuckets = this._numberOfBuckets;
        this._localInit(logNewSize, this._minimumEntry);
        this._queueSize = 0;
        boolean saveDebugging = this._debugging;
        this._debugging = false;
        boolean saveResizeEnabled = this._resizeEnabled;
        this._resizeEnabled = false;
        for (int i = 0; i < old_numberOfBuckets; ++i) {
            while (!old_bucket[i].isEmpty()) {
                this.put(old_bucket[i].take());
            }
        }
        this._debugging = saveDebugging;
        this._resizeEnabled = saveResizeEnabled;
    }

    private Object _takeFromBucket(int index) {
        Object minEntry = this._bucket[index].take();
        this._minBucket = index;
        this._minimumEntry = minEntry;
        this._minVirtualBucket = this._cqComparator.getVirtualBinNumber(minEntry);
        --this._queueSize;
        this._resize(false);
        return minEntry;
    }

    private static class CQCell {
        public Object contents;
        public CQCell next;

        public CQCell(Object contents, CQCell next) {
            this.contents = contents;
            this.next = next;
        }

        public final CQCell find(Object element) {
            CQCell p = this;
            while (p != null) {
                if (p.contents.equals(element)) {
                    return p;
                }
                p = p.next;
            }
            return null;
        }
    }

    private class CQLinkedList {
        public CQCell head = null;
        public CQCell tail = null;

        public final boolean includes(Object object) {
            if (this.isEmpty()) {
                return false;
            }
            return this.head.find(object) != null;
        }

        public final boolean isEmpty() {
            return this.head == null;
        }

        public final void insert(Object object) {
            if (this.head == null) {
                this.tail = this.head = new CQCell(object, null);
                return;
            }
            if (CalendarQueue.this._cqComparator.compare(object, this.tail.contents) >= 0) {
                CQCell newTail;
                this.tail.next = newTail = new CQCell(object, null);
                this.tail = newTail;
                return;
            }
            if (CalendarQueue.this._cqComparator.compare(this.head.contents, object) > 0) {
                this.head = new CQCell(object, this.head);
                return;
            }
            CQCell previousCell = this.head;
            CQCell currentCell = previousCell.next;
            do {
                if (CalendarQueue.this._cqComparator.compare(currentCell.contents, object) > 0) {
                    CQCell newCell;
                    previousCell.next = newCell = new CQCell(object, currentCell);
                    return;
                }
                previousCell = currentCell;
            } while ((currentCell = previousCell.next) != null);
        }

        public final boolean remove(Object object) {
            if (this.head == null) {
                return false;
            }
            if (this.head.contents.equals(object)) {
                if (this.head != this.tail) {
                    this.head = this.head.next;
                } else {
                    this.head = null;
                    this.tail = null;
                }
                return true;
            }
            CQCell previousCell = this.head;
            CQCell currentCell = previousCell.next;
            do {
                if (currentCell.contents.equals(object)) {
                    if (this.tail == currentCell) {
                        this.tail = previousCell;
                    }
                    previousCell.next = currentCell.next;
                    return true;
                }
                previousCell = currentCell;
            } while ((currentCell = currentCell.next) != null);
            return false;
        }

        public final Object take() {
            CQCell oldHead = this.head;
            this.head = this.head.next;
            if (this.head == null) {
                this.tail = null;
            }
            return oldHead.contents;
        }
    }
}

