/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.util;

import java.util.Comparator;
import ptolemy.actor.IOPort;
import ptolemy.actor.sched.NotSchedulableException;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.TemporaryVariable;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class DFUtilities {
    public static int getRate(IOPort port) throws NotSchedulableException, IllegalActionException {
        if (port.isInput() && port.isOutput()) {
            throw new NotSchedulableException(port, "Port is both an input and an output, which is not allowed in SDF.");
        }
        if (port.isInput()) {
            return DFUtilities.getTokenConsumptionRate(port);
        }
        if (port.isOutput()) {
            return DFUtilities.getTokenProductionRate(port);
        }
        throw new NotSchedulableException(port, "Port is neither an input and an output, which is not allowed in SDF.");
    }

    public static Variable getRateVariable(Port port, String name) {
        Variable parameter = (Variable)port.getAttribute(name);
        if (parameter == null) {
            String altName = "_" + name;
            parameter = (Variable)port.getAttribute(altName);
        }
        return parameter;
    }

    public static int getRateVariableValue(Port port, String name, int defaultValue) throws IllegalActionException {
        Variable parameter = DFUtilities.getRateVariable(port, name);
        if (parameter == null) {
            return defaultValue;
        }
        Token token = parameter.getToken();
        if (token instanceof IntToken) {
            return ((IntToken)token).intValue();
        }
        throw new IllegalActionException("Variable " + parameter.getFullName() + " was expected " + "to contain an IntToken, but instead " + "contained a " + token.getType() + ".");
    }

    public static int getTokenConsumptionRate(IOPort port) throws IllegalActionException {
        if (!port.isInput()) {
            return 0;
        }
        return DFUtilities.getRateVariableValue(port, "tokenConsumptionRate", 1);
    }

    public static int getTokenInitProduction(IOPort port) throws IllegalActionException {
        if (!port.isOutput()) {
            return 0;
        }
        return DFUtilities.getRateVariableValue(port, "tokenInitProduction", 0);
    }

    public static int getTokenProductionRate(IOPort port) throws IllegalActionException {
        if (!port.isOutput()) {
            return 0;
        }
        return DFUtilities.getRateVariableValue(port, "tokenProductionRate", 1);
    }

    public static void setExpressionIfNotDefined(Port port, String name, String value) throws IllegalActionException {
        Variable rateParameter = (Variable)port.getAttribute(name);
        if (rateParameter == null) {
            try {
                String altName = "_" + name;
                rateParameter = (Variable)port.getAttribute(altName);
                if (rateParameter == null) {
                    rateParameter = new Parameter(port, altName);
                    rateParameter.setVisibility(Settable.NOT_EDITABLE);
                    rateParameter.setPersistent(false);
                }
                rateParameter.setExpression(value);
            }
            catch (KernelException ex) {
                throw new InternalErrorException(port, (Throwable)ex, "Should not occur");
            }
        }
    }

    public static void setIfNotDefined(Port port, String name, int value) throws IllegalActionException {
        Variable rateParameter = (Variable)port.getAttribute(name);
        if (rateParameter == null) {
            try {
                String altName = "_" + name;
                rateParameter = (Variable)port.getAttribute(altName);
                if (rateParameter == null) {
                    rateParameter = new Parameter(port, altName);
                    rateParameter.setVisibility(Settable.NOT_EDITABLE);
                    rateParameter.setPersistent(false);
                }
                rateParameter.setToken(new IntToken(value));
            }
            catch (KernelException ex) {
                throw new InternalErrorException(port, (Throwable)ex, "Should not occur");
            }
        }
    }

    public static void setOrCreate(NamedObj container, String name, int value) throws IllegalActionException {
        Variable variable = DFUtilities._getOrCreate(container, name);
        variable.setToken(new IntToken(value));
    }

    public static void setOrCreate(NamedObj container, String name, String expression) throws IllegalActionException {
        Variable variable = DFUtilities._getOrCreate(container, name);
        variable.setExpression(expression);
    }

    public static void setRate(Port port, String name, int rate) throws IllegalActionException {
        if (rate < 0) {
            throw new IllegalActionException("Negative rate is not allowed: " + rate);
        }
        Variable parameter = (Variable)port.getAttribute(name);
        if (parameter != null) {
            parameter.setToken(new IntToken(rate));
        } else {
            try {
                parameter = new Variable((NamedObj)port, name, new IntToken(rate));
                parameter.setVisibility(Settable.NOT_EDITABLE);
                parameter.setPersistent(false);
            }
            catch (KernelException ex) {
                throw new InternalErrorException(port, (Throwable)ex, "Should not occur");
            }
        }
    }

    public static void setRateVariable(Port port, String name, int value) throws IllegalActionException {
        Variable rateParameter = (Variable)port.getAttribute(name);
        if (rateParameter == null) {
            try {
                String altName = "_" + name;
                rateParameter = (Variable)port.getAttribute(altName);
                if (rateParameter == null) {
                    rateParameter = new Parameter(port, altName);
                    rateParameter.setVisibility(Settable.NOT_EDITABLE);
                    rateParameter.setPersistent(false);
                }
            }
            catch (KernelException ex) {
                throw new InternalErrorException(port, (Throwable)ex, "Should not occur");
            }
        }
        rateParameter.setToken(new IntToken(value));
    }

    public static void setTokenConsumptionRate(IOPort port, int rate) throws IllegalActionException {
        DFUtilities.setRate(port, "tokenConsumptionRate", rate);
    }

    public static void setTokenInitProduction(IOPort port, int rate) throws IllegalActionException {
        DFUtilities.setRate(port, "tokenInitProduction", rate);
    }

    public static void setTokenProductionRate(IOPort port, int rate) throws IllegalActionException {
        DFUtilities.setRate(port, "tokenProductionRate", rate);
    }

    public static void showRate(Port port, boolean flag) throws IllegalActionException {
        String name = "_showRate";
        Variable variable = (Variable)port.getAttribute(name);
        if (variable == null) {
            try {
                variable = new Parameter(port, name);
                variable.setVisibility(Settable.EXPERT);
                variable.setPersistent(false);
            }
            catch (KernelException ex) {
                throw new InternalErrorException(port, (Throwable)ex, "Should not occur");
            }
        }
        variable.setToken(BooleanToken.getInstance(flag));
    }

    private static Variable _getOrCreate(NamedObj container, String name) throws IllegalActionException {
        Variable variable = (Variable)container.getAttribute(name);
        if (variable == null) {
            try {
                variable = new TemporaryVariable(container, name);
                variable.setVisibility(Settable.NOT_EDITABLE);
                variable.setPersistent(false);
            }
            catch (KernelException ex) {
                throw new InternalErrorException(container, (Throwable)ex, "Should not occur");
            }
        }
        return variable;
    }

    public static class NamedObjComparator
    implements Comparator {
        public int compare(Object object1, Object object2) {
            if (object1 instanceof NamedObj && object2 instanceof NamedObj) {
                NamedObj namedObject1 = (NamedObj)object1;
                NamedObj namedObject2 = (NamedObj)object2;
                int compare = namedObject1.getFullName().compareTo(namedObject2.getFullName());
                if (compare != 0) {
                    return compare;
                }
                Class<?> class1 = namedObject1.getClass();
                Class<?> class2 = namedObject2.getClass();
                compare = class1.getName().compareTo(class2.getName());
                if (compare != 0) {
                    return compare;
                }
                if (object1.equals(object2)) {
                    return 0;
                }
                throw new InternalErrorException("Comparator not capable of comparing not equal objects.");
            }
            throw new InternalErrorException("Arguments to comparator must be instances of NamedObj: " + object1 + ", " + object2);
        }
    }
}

