/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import ptolemy.actor.Actor;
import ptolemy.actor.IOPort;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Node;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.SingletonAttribute;
import ptolemy.kernel.util.Workspace;

public abstract class FunctionDependency
extends SingletonAttribute {
    protected DirectedGraph _dependencyGraph;
    private long _functionDependencyVersion = -1L;

    public FunctionDependency(Entity container) throws IllegalActionException, NameDuplicationException {
        super(container, "_functionDependency");
        this.setPersistent(false);
    }

    public DirectedGraph getDependencyGraph() {
        this._validate();
        return this._dependencyGraph;
    }

    public Set getDependentOutputPorts(IOPort inputPort) {
        this._validate();
        if (!inputPort.getContainer().equals(this.getContainer())) {
            throw new InternalErrorException("The input port " + inputPort.getName() + " does not belong to the " + "actor " + this.getContainer().getName());
        }
        Collection reachableOutputs = this._dependencyGraph.reachableNodes(this._dependencyGraph.node(inputPort));
        HashSet<Object> dependentOutputPorts = new HashSet<Object>();
        for (Node node : reachableOutputs) {
            dependentOutputPorts.add(node.getWeight());
        }
        return dependentOutputPorts;
    }

    public List getInputPortsDependentOn(IOPort outputPort) {
        this._validate();
        if (!outputPort.getContainer().equals(this.getContainer())) {
            throw new InternalErrorException("The output port " + outputPort.getName() + " does not belong to the " + "actor " + this.getContainer().getName());
        }
        Collection backwardReachableInputs = this._dependencyGraph.backwardReachableNodes(this._dependencyGraph.node(outputPort));
        LinkedList<Object> dependentInputPorts = new LinkedList<Object>();
        for (Node node : backwardReachableInputs) {
            dependentInputPorts.add(node.getWeight());
        }
        return dependentInputPorts;
    }

    @Override
    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        super.setContainer(container);
        this._functionDependencyVersion = -1L;
    }

    protected final DirectedGraph _constructConnectedDependencyGraph() {
        DirectedGraph dependencyGraph = this._constructDisconnectedDependencyGraph();
        ListIterator inputs = ((Actor)((Object)this.getContainer())).inputPortList().listIterator();
        while (inputs.hasNext()) {
            IOPort inputPort = (IOPort)inputs.next();
            ListIterator outputs = ((Actor)((Object)this.getContainer())).outputPortList().listIterator();
            while (outputs.hasNext()) {
                dependencyGraph.addEdge(inputPort, outputs.next());
            }
        }
        return dependencyGraph;
    }

    protected void _constructDependencyGraph() {
        this._dependencyGraph = this._constructConnectedDependencyGraph();
    }

    protected final DirectedGraph _constructDisconnectedDependencyGraph() {
        DirectedGraph dependencyGraph = new DirectedGraph();
        ListIterator inputs = ((Actor)((Object)this.getContainer())).inputPortList().listIterator();
        while (inputs.hasNext()) {
            IOPort input = (IOPort)inputs.next();
            dependencyGraph.addNodeWeight(input);
        }
        ListIterator outputs = ((Actor)((Object)this.getContainer())).outputPortList().listIterator();
        while (outputs.hasNext()) {
            IOPort output = (IOPort)outputs.next();
            dependencyGraph.addNodeWeight(output);
        }
        return dependencyGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _validate() {
        Workspace workspace = this.getContainer().workspace();
        long workspaceVersion = workspace.getVersion();
        if (this._functionDependencyVersion != workspaceVersion) {
            try {
                workspace.getReadAccess();
                this._constructDependencyGraph();
                this._functionDependencyVersion = workspaceVersion;
            }
            finally {
                workspace.doneReading();
            }
        }
    }
}

