/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import java.util.LinkedList;
import ptolemy.data.AbstractNotConvertibleToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;

public class ArrayToken
extends AbstractNotConvertibleToken {
    public static final ArrayToken NIL = new ArrayToken(BaseType.NIL);
    private Token[] _value;
    private Type _elementType;

    public ArrayToken(Token[] value) throws IllegalActionException {
        int i;
        int length = value.length;
        if (length < 1) {
            throw new IllegalActionException("ArrayToken(Token[]) called with a an array of length less than 1.  To create an array of length 0, use the ArrayToken(Token) constructor or the \"emptyArray(type)\" function in the expression language. The reason is that elements in ArrayToken must have a type.");
        }
        this._elementType = value[0].getType();
        for (i = 0; i < length; ++i) {
            Type valueType = value[i].getType();
            this._elementType = TypeLattice.leastUpperBound(this._elementType, valueType);
        }
        this._value = new Token[length];
        for (i = 0; i < length; ++i) {
            this._value[i] = this._elementType.convert(value[i]);
        }
    }

    public ArrayToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        ParseTreeEvaluator evaluator = new ParseTreeEvaluator();
        Token token = evaluator.evaluateParseTree(tree);
        if (!(token instanceof ArrayToken)) {
            throw new IllegalActionException("An array token cannot be created from the expression '" + init + "'");
        }
        this._value = ((ArrayToken)token)._value;
        this._elementType = ((ArrayToken)token)._elementType;
    }

    public ArrayToken(Type elementType) {
        this._value = new Token[0];
        this._elementType = elementType;
    }

    public ArrayToken(Type elementType, Token[] value) throws IllegalActionException {
        this._elementType = elementType;
        int length = value.length;
        this._value = new Token[length];
        for (int i = 0; i < length; ++i) {
            this._value[i] = this._elementType.convert(value[i]);
        }
    }

    @Override
    public Token add(Token rightArgument) throws IllegalActionException {
        try {
            return this._add(rightArgument);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("add", this, rightArgument));
        }
    }

    @Override
    public Token addReverse(Token leftArgument) throws IllegalActionException {
        try {
            return this._add(leftArgument);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("addReverse", this, leftArgument));
        }
    }

    public static byte[] arrayTokenToUnsignedByteArray(ArrayToken dataArrayToken) {
        byte[] dataBytes = new byte[dataArrayToken.length()];
        for (int j = 0; j < dataArrayToken.length(); ++j) {
            UnsignedByteToken dataToken = (UnsignedByteToken)dataArrayToken.getElement(j);
            dataBytes[j] = dataToken.byteValue();
        }
        return dataBytes;
    }

    public Token[] arrayValue() {
        Token[] result = new Token[this._value.length];
        if (this._value.length > 0) {
            System.arraycopy(this._value, 0, result, 0, this._value.length);
        }
        return result;
    }

    @Override
    public Token divide(Token rightArgument) throws IllegalActionException {
        try {
            return this._divide(rightArgument);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("divide", this, rightArgument));
        }
    }

    @Override
    public Token divideReverse(Token rightArgument) throws IllegalActionException {
        try {
            return this._divideReverse(rightArgument);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("divide", this, rightArgument));
        }
    }

    public ArrayToken elementAdd(Token token) throws IllegalActionException {
        Token[] result = new Token[this._value.length];
        try {
            for (int i = 0; i < this._value.length; ++i) {
                result[i] = this._value[i].add(token);
            }
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("elementAdd", this, token));
        }
        return new ArrayToken(result);
    }

    public ArrayToken elementDivide(Token token) throws IllegalActionException {
        Token[] result = new Token[this._value.length];
        try {
            for (int i = 0; i < this._value.length; ++i) {
                result[i] = this._value[i].divide(token);
            }
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("elementDivide", this, token));
        }
        return new ArrayToken(result);
    }

    public ArrayToken elementModulo(Token token) throws IllegalActionException {
        Token[] result = new Token[this._value.length];
        try {
            for (int i = 0; i < this._value.length; ++i) {
                result[i] = this._value[i].modulo(token);
            }
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("elementModulo", this, token));
        }
        return new ArrayToken(result);
    }

    public ArrayToken elementMultiply(Token token) throws IllegalActionException {
        Token[] result = new Token[this._value.length];
        try {
            for (int i = 0; i < this._value.length; ++i) {
                result[i] = this._value[i].multiply(token);
            }
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("elementMultiply", this, token));
        }
        return new ArrayToken(result);
    }

    public static Type elementMultiplyReturnType(Type type1, Type type2) throws IllegalActionException {
        if (type1 instanceof ArrayType) {
            return new ArrayType(TypeLattice.leastUpperBound(((ArrayType)type1).getElementType(), type2));
        }
        return new ArrayType(BaseType.UNKNOWN);
    }

    public ArrayToken elementSubtract(Token token) throws IllegalActionException {
        Token[] result = new Token[this._value.length];
        try {
            for (int i = 0; i < this._value.length; ++i) {
                result[i] = this._value[i].subtract(token);
            }
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("elementSubtract", this, token));
        }
        return new ArrayToken(result);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.isNil() || ((ArrayToken)object).isNil()) {
            return false;
        }
        ArrayToken arrayArgument = (ArrayToken)object;
        int length = arrayArgument.length();
        if (this._value.length != length) {
            return false;
        }
        Token[] array = arrayArgument._value;
        for (int i = 0; i < length; ++i) {
            if (this._value[i].equals(array[i]) && !this._value[i].isNil()) continue;
            return false;
        }
        return true;
    }

    public ArrayToken extract(ArrayToken selection) throws IllegalActionException {
        int i;
        LinkedList<Token> result = new LinkedList<Token>();
        if (((Object)selection.getElementType()).equals(BaseType.BOOLEAN)) {
            if (selection.length() != this.length()) {
                throw new IllegalActionException("When the argument is an array of booleans, it must have the same length as this array.");
            }
            for (i = 0; i < selection.length(); ++i) {
                if (!selection.getElement(i).equals(BooleanToken.TRUE)) continue;
                result.add(this.getElement(i));
            }
        } else if (((Object)selection.getElementType()).equals(BaseType.INT)) {
            for (i = 0; i < selection.length(); ++i) {
                int index = ((IntToken)selection.getElement(i)).intValue();
                result.add(this.getElement(index));
            }
        } else {
            throw new IllegalActionException("The argument must be {boolean} or {int}.");
        }
        if (result.size() > 0) {
            Token[] resultArray = new Token[result.size()];
            resultArray = result.toArray(resultArray);
            return new ArrayToken(resultArray);
        }
        return new ArrayToken(this.getElementType());
    }

    public Token getElement(int index) {
        return this._value[index];
    }

    public Type getElementType() {
        return this._elementType;
    }

    @Override
    public Type getType() {
        return new ArrayType(this.getElementType(), this.length());
    }

    public int hashCode() {
        if (this._value != null && this._value.length > 0) {
            return this._value[0].hashCode();
        }
        if (this._elementType != null) {
            return this._elementType.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean isNil() {
        return this == NIL;
    }

    public int length() {
        return this._value.length;
    }

    @Override
    public Token modulo(Token rightArgument) throws IllegalActionException {
        try {
            return this._modulo(rightArgument);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("modulo", this, rightArgument));
        }
    }

    @Override
    public Token moduloReverse(Token rightArgument) throws IllegalActionException {
        try {
            return this._moduloReverse(rightArgument);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("modulo", this, rightArgument));
        }
    }

    @Override
    public Token multiply(Token rightArgument) throws IllegalActionException {
        try {
            return this._multiply(rightArgument);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("multiply", this, rightArgument));
        }
    }

    @Override
    public Token multiplyReverse(Token leftArgument) throws IllegalActionException {
        try {
            return this._multiply(leftArgument);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("multiplyReverse", this, leftArgument));
        }
    }

    @Override
    public Token one() throws IllegalActionException {
        Token[] oneValueArray = new Token[this._value.length];
        for (int i = 0; i < this._value.length; ++i) {
            oneValueArray[i] = this._value[i].one();
        }
        return new ArrayToken(oneValueArray);
    }

    public ArrayToken subarray(int index, int count) throws IllegalActionException {
        if (index < 0) {
            throw new IllegalActionException("index argument of subarray() must be non-negative.");
        }
        if (count > 0 && index < this._value.length && index >= 0) {
            if (count + index > this._value.length) {
                count = this._value.length - index;
            }
            Token[] result = new Token[count];
            System.arraycopy(this._value, index, result, 0, count);
            return new ArrayToken(result);
        }
        return new ArrayToken(this.getElementType());
    }

    @Override
    public Token subtract(Token rightArgument) throws IllegalActionException {
        try {
            return this._subtract(rightArgument);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("subtract", this, rightArgument));
        }
    }

    @Override
    public Token subtractReverse(Token rightArgument) throws IllegalActionException {
        try {
            return this._subtractReverse(rightArgument);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, ArrayToken.notSupportedMessage("divide", this, rightArgument));
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        for (int i = 0; i < this._value.length; ++i) {
            buffer.append(this._value[i].toString());
            if (i >= this._value.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static ArrayToken unsignedByteArrayToArrayToken(byte[] dataBytes) throws IllegalActionException {
        int bytesAvailable = dataBytes.length;
        Token[] dataArrayToken = new Token[bytesAvailable];
        for (int j = 0; j < bytesAvailable; ++j) {
            dataArrayToken[j] = new UnsignedByteToken(dataBytes[j]);
        }
        return new ArrayToken(dataArrayToken);
    }

    @Override
    public Token zero() throws IllegalActionException {
        if (this._value.length == 0) {
            return this;
        }
        Token[] zeroValueArray = new Token[this._value.length];
        for (int i = 0; i < this._value.length; ++i) {
            zeroValueArray[i] = this._value[i].zero();
        }
        return new ArrayToken(zeroValueArray);
    }

    @Override
    protected Token _add(Token rightArgument) throws IllegalActionException {
        Token[] result = new Token[this._value.length];
        if (rightArgument instanceof ArrayToken) {
            ArrayToken rightArray = (ArrayToken)rightArgument;
            if (rightArray.length() == this.length()) {
                for (int i = 0; i < this._value.length; ++i) {
                    result[i] = this._value[i].add(rightArray.getElement(i));
                }
            } else if (rightArray.length() == 1) {
                Token scalar = rightArray.getElement(0);
                for (int i = 0; i < this._value.length; ++i) {
                    result[i] = this._value[i].add(scalar);
                }
            } else if (this.length() == 1) {
                result = new Token[rightArray.length()];
                Token scalar = this.getElement(0);
                for (int i = 0; i < rightArray.length(); ++i) {
                    result[i] = rightArray.getElement(i).add(scalar);
                }
            } else {
                this._checkArgumentLength(rightArgument);
            }
        } else {
            for (int i = 0; i < this._value.length; ++i) {
                result[i] = this._value[i].add(rightArgument);
            }
        }
        return new ArrayToken(result);
    }

    @Override
    protected Token _divide(Token rightArgument) throws IllegalActionException {
        Token[] result = new Token[this._value.length];
        if (rightArgument instanceof ArrayToken) {
            ArrayToken rightArray = (ArrayToken)rightArgument;
            if (rightArray.length() == this.length()) {
                for (int i = 0; i < this._value.length; ++i) {
                    result[i] = this._value[i].divide(rightArray.getElement(i));
                }
            } else if (rightArray.length() == 1) {
                Token scalar = rightArray.getElement(0);
                for (int i = 0; i < this._value.length; ++i) {
                    result[i] = this._value[i].divide(scalar);
                }
            } else if (this.length() == 1) {
                result = new Token[rightArray.length()];
                Token scalar = this.getElement(0);
                for (int i = 0; i < rightArray.length(); ++i) {
                    result[i] = scalar.divide(rightArray.getElement(i));
                }
            } else {
                this._checkArgumentLength(rightArgument);
            }
        } else {
            for (int i = 0; i < this._value.length; ++i) {
                result[i] = this._value[i].divide(rightArgument);
            }
        }
        return new ArrayToken(result);
    }

    protected Token _divideReverse(Token rightArgument) throws IllegalActionException {
        if (rightArgument instanceof ArrayToken) {
            return ((ArrayToken)rightArgument).divide(this);
        }
        Token[] result = new Token[this._value.length];
        for (int i = 0; i < this._value.length; ++i) {
            result[i] = rightArgument.divide(this._value[i]);
        }
        return new ArrayToken(result);
    }

    @Override
    protected BooleanToken _isCloseTo(Token token, double epsilon) throws IllegalActionException {
        ArrayToken rightArray = (ArrayToken)token;
        if (this.length() != rightArray.length()) {
            return BooleanToken.FALSE;
        }
        for (int i = 0; i < this._value.length; ++i) {
            BooleanToken result = this._value[i].isCloseTo(rightArray.getElement(i), epsilon);
            if (result.booleanValue()) continue;
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    protected BooleanToken _isEqualTo(Token token) throws IllegalActionException {
        if (this.isNil() || token.isNil()) {
            return BooleanToken.FALSE;
        }
        this._checkArgumentLength(token);
        ArrayToken rightArray = (ArrayToken)token;
        for (int i = 0; i < this._value.length; ++i) {
            BooleanToken result = this._value[i].isEqualTo(rightArray.getElement(i));
            if (result.booleanValue()) continue;
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    protected Token _modulo(Token rightArgument) throws IllegalActionException {
        Token[] result = new Token[this._value.length];
        if (rightArgument instanceof ArrayToken) {
            ArrayToken rightArray = (ArrayToken)rightArgument;
            if (rightArray.length() == this.length()) {
                for (int i = 0; i < this._value.length; ++i) {
                    result[i] = this._value[i].modulo(rightArray.getElement(i));
                }
            } else if (rightArray.length() == 1) {
                Token scalar = rightArray.getElement(0);
                for (int i = 0; i < this._value.length; ++i) {
                    result[i] = this._value[i].modulo(scalar);
                }
            } else if (this.length() == 1) {
                result = new Token[rightArray.length()];
                Token scalar = this.getElement(0);
                for (int i = 0; i < rightArray.length(); ++i) {
                    result[i] = scalar.modulo(rightArray.getElement(i));
                }
            } else {
                this._checkArgumentLength(rightArgument);
            }
        } else {
            for (int i = 0; i < this._value.length; ++i) {
                result[i] = this._value[i].modulo(rightArgument);
            }
        }
        return new ArrayToken(result);
    }

    protected Token _moduloReverse(Token rightArgument) throws IllegalActionException {
        if (rightArgument instanceof ArrayToken) {
            return ((ArrayToken)rightArgument).modulo(this);
        }
        Token[] result = new Token[this._value.length];
        for (int i = 0; i < this._value.length; ++i) {
            result[i] = rightArgument.modulo(this._value[i]);
        }
        return new ArrayToken(result);
    }

    @Override
    protected Token _multiply(Token rightArgument) throws IllegalActionException {
        Token[] result = new Token[this._value.length];
        if (rightArgument instanceof ArrayToken) {
            ArrayToken rightArray = (ArrayToken)rightArgument;
            if (rightArray.length() == this.length()) {
                for (int i = 0; i < this._value.length; ++i) {
                    result[i] = this._value[i].multiply(rightArray.getElement(i));
                }
            } else if (rightArray.length() == 1) {
                Token scalar = rightArray.getElement(0);
                for (int i = 0; i < this._value.length; ++i) {
                    result[i] = this._value[i].multiply(scalar);
                }
            } else if (this.length() == 1) {
                result = new Token[rightArray.length()];
                Token scalar = this.getElement(0);
                for (int i = 0; i < rightArray.length(); ++i) {
                    result[i] = rightArray.getElement(i).multiply(scalar);
                }
            } else {
                this._checkArgumentLength(rightArgument);
            }
        } else {
            for (int i = 0; i < this._value.length; ++i) {
                result[i] = this._value[i].multiply(rightArgument);
            }
        }
        return new ArrayToken(result);
    }

    @Override
    protected Token _subtract(Token rightArgument) throws IllegalActionException {
        Token[] result = new Token[this._value.length];
        if (rightArgument instanceof ArrayToken) {
            ArrayToken rightArray = (ArrayToken)rightArgument;
            if (rightArray.length() == this.length()) {
                for (int i = 0; i < this._value.length; ++i) {
                    result[i] = this._value[i].subtract(rightArray.getElement(i));
                }
            } else if (rightArray.length() == 1) {
                Token scalar = rightArray.getElement(0);
                for (int i = 0; i < this._value.length; ++i) {
                    result[i] = this._value[i].subtract(scalar);
                }
            } else if (this.length() == 1) {
                result = new Token[rightArray.length()];
                Token scalar = this.getElement(0);
                for (int i = 0; i < rightArray.length(); ++i) {
                    result[i] = scalar.subtract(rightArray.getElement(i));
                }
            } else {
                this._checkArgumentLength(rightArgument);
            }
        } else {
            for (int i = 0; i < this._value.length; ++i) {
                result[i] = this._value[i].subtract(rightArgument);
            }
        }
        return new ArrayToken(result);
    }

    protected Token _subtractReverse(Token rightArgument) throws IllegalActionException {
        if (rightArgument instanceof ArrayToken) {
            return ((ArrayToken)rightArgument).subtract(this);
        }
        Token[] result = new Token[this._value.length];
        for (int i = 0; i < this._value.length; ++i) {
            result[i] = rightArgument.subtract(this._value[i]);
        }
        return new ArrayToken(result);
    }

    private void _checkArgumentLength(Token token) throws IllegalActionException {
        int length = ((ArrayToken)token).length();
        if (this.length() != length) {
            throw new IllegalActionException("The length of the argument (" + length + ") is not the same as the length of this token (" + this.length() + ").");
        }
    }
}

