/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;

public class BooleanToken
extends ScalarToken {
    public static final BooleanToken TRUE = new BooleanToken(true);
    public static final BooleanToken NIL = new BooleanToken(false);
    public static final BooleanToken FALSE = new BooleanToken(false);
    private boolean _value;

    public BooleanToken() {
        this._value = false;
    }

    public BooleanToken(boolean b) {
        this._value = b;
    }

    public BooleanToken(String init) throws IllegalActionException {
        if (init == null || init.equals("nil")) {
            throw new IllegalActionException(BooleanToken.notSupportedNullNilStringMessage("BooleanToken", init));
        }
        this._value = init.toLowerCase().equals("true");
    }

    public BooleanToken and(BooleanToken rightArgument) {
        if (this.isNil() || rightArgument.isNil()) {
            return NIL;
        }
        if (this._value && rightArgument.booleanValue()) {
            return TRUE;
        }
        return FALSE;
    }

    public boolean booleanValue() {
        return this._value;
    }

    public static BooleanToken convert(Token token) throws IllegalActionException {
        if (token instanceof BooleanToken) {
            return (BooleanToken)token;
        }
        if (token.isNil()) {
            return NIL;
        }
        int compare = TypeLattice.compare((Type)BaseType.BOOLEAN, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(BooleanToken.notSupportedIncomparableConversionMessage(token, "boolean"));
        }
        throw new IllegalActionException(BooleanToken.notSupportedConversionMessage(token, "boolean"));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.isNil() || ((BooleanToken)object).isNil()) {
            return false;
        }
        return ((BooleanToken)object).booleanValue() == this._value;
    }

    public static BooleanToken getInstance(boolean value) {
        if (value) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public Type getType() {
        return BaseType.BOOLEAN;
    }

    public int hashCode() {
        if (this._value) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isNil() {
        return this == NIL;
    }

    public BooleanToken not() {
        if (this.isNil()) {
            return NIL;
        }
        if (this.booleanValue()) {
            return FALSE;
        }
        return TRUE;
    }

    @Override
    public Token one() {
        return TRUE;
    }

    public BooleanToken or(BooleanToken rightArgument) {
        if (this.isNil() || rightArgument.isNil()) {
            return NIL;
        }
        if (this._value || rightArgument.booleanValue()) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public String toString() {
        if (this.isNil()) {
            return super.toString();
        }
        if (this.booleanValue()) {
            return "true";
        }
        return "false";
    }

    public BooleanToken xor(BooleanToken rightArgument) {
        if (this.isNil() || rightArgument.isNil()) {
            return NIL;
        }
        if (this._value ^ rightArgument.booleanValue()) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public Token zero() {
        return FALSE;
    }

    @Override
    protected ScalarToken _absolute() {
        return this;
    }

    @Override
    protected ScalarToken _add(ScalarToken rightArgument) {
        return this.or((BooleanToken)rightArgument);
    }

    @Override
    protected ScalarToken _bitwiseAnd(ScalarToken rightArgument) throws IllegalActionException {
        return this.and((BooleanToken)rightArgument);
    }

    @Override
    protected ScalarToken _bitwiseNot() throws IllegalActionException {
        return this.not();
    }

    @Override
    protected ScalarToken _bitwiseOr(ScalarToken rightArgument) throws IllegalActionException {
        return this.or((BooleanToken)rightArgument);
    }

    @Override
    protected ScalarToken _bitwiseXor(ScalarToken rightArgument) throws IllegalActionException {
        return this.xor((BooleanToken)rightArgument);
    }

    @Override
    protected ScalarToken _divide(ScalarToken rightArgument) throws IllegalActionException {
        if (this.isNil() || ((BooleanToken)rightArgument).isNil()) {
            return NIL;
        }
        boolean denomValue = ((BooleanToken)rightArgument).booleanValue();
        if (denomValue) {
            return this;
        }
        throw new IllegalActionException("BooleanToken: division by false-valued token (analogous to division by zero).");
    }

    @Override
    protected BooleanToken _isCloseTo(ScalarToken token, double epsilon) {
        return this._isEqualTo(token);
    }

    @Override
    protected BooleanToken _isEqualTo(ScalarToken token) {
        if (this.equals(token)) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    protected BooleanToken _isLessThan(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(BooleanToken.notSupportedMessage("isLessThan", this, rightArgument));
    }

    @Override
    protected ScalarToken _modulo(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(BooleanToken.notSupportedMessage("modulo", this, rightArgument));
    }

    @Override
    protected ScalarToken _multiply(ScalarToken rightArgument) throws IllegalActionException {
        return this.and((BooleanToken)rightArgument);
    }

    @Override
    protected ScalarToken _subtract(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(BooleanToken.notSupportedMessage("subtract", this, rightArgument));
    }
}

