/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.FloatToken;
import ptolemy.data.IntToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.TokenUtilities;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.unit.UnitUtilities;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.math.Complex;

public class DoubleToken
extends ScalarToken {
    public static final DoubleToken NIL = new DoubleToken(Double.NaN);
    public static final DoubleToken ONE = new DoubleToken(1.0);
    public static final DoubleToken ZERO = new DoubleToken(0.0);
    private double _value;

    public DoubleToken() {
        this._value = 0.0;
    }

    public DoubleToken(double value) {
        this._value = value;
    }

    public DoubleToken(String init) throws IllegalActionException {
        if (init == null || init.equals("nil")) {
            throw new IllegalActionException(DoubleToken.notSupportedNullNilStringMessage("DoubleToken", init));
        }
        try {
            this._value = Double.parseDouble(init);
        }
        catch (NumberFormatException e) {
            throw new IllegalActionException(null, e, "Failed to parse \"" + init + "\" as a number.");
        }
    }

    @Override
    public Complex complexValue() {
        return new Complex(this._value, 0.0);
    }

    public static DoubleToken convert(Token token) throws IllegalActionException {
        if (token instanceof DoubleToken) {
            return (DoubleToken)token;
        }
        if (token.isNil()) {
            return NIL;
        }
        int compare = TypeLattice.compare((Type)BaseType.DOUBLE, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(DoubleToken.notSupportedIncomparableConversionMessage(token, "double"));
        }
        compare = TypeLattice.compare((Type)BaseType.FLOAT, token);
        if (compare == 0 || compare == 1) {
            FloatToken floatToken = FloatToken.convert(token);
            DoubleToken result = new DoubleToken(floatToken.doubleValue());
            if (floatToken._unitCategoryExponents != null && !UnitUtilities.isUnitless(floatToken._unitCategoryExponents)) {
                result._unitCategoryExponents = floatToken._copyOfCategoryExponents();
            }
            return result;
        }
        compare = TypeLattice.compare((Type)BaseType.INT, token);
        if (compare == 0 || compare == 1) {
            IntToken intToken = IntToken.convert(token);
            DoubleToken result = new DoubleToken(intToken.doubleValue());
            if (intToken._unitCategoryExponents != null && !UnitUtilities.isUnitless(intToken._unitCategoryExponents)) {
                result._unitCategoryExponents = intToken._copyOfCategoryExponents();
            }
            return result;
        }
        throw new IllegalActionException(DoubleToken.notSupportedConversionMessage(token, "double"));
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.isNil() || ((DoubleToken)object).isNil()) {
            return false;
        }
        return ((DoubleToken)object).doubleValue() == this._value;
    }

    @Override
    public Type getType() {
        return BaseType.DOUBLE;
    }

    public int hashCode() {
        return (int)this._value;
    }

    @Override
    public boolean isNil() {
        return this == NIL;
    }

    @Override
    public Token one() {
        return ONE;
    }

    @Override
    public String toString() {
        String unitString = "";
        if (!this._isUnitless()) {
            unitString = " * " + this.unitsString();
        }
        if (this.isNil()) {
            return super.toString();
        }
        if (Double.isNaN(this._value) || Double.isInfinite(this._value)) {
            return Double.toString(this._value) + unitString;
        }
        double mag = Math.abs(this._value);
        if (mag == 0.0 || mag < 1000000.0 && mag > 0.001) {
            return TokenUtilities.regularFormat.format(this._value) + unitString;
        }
        return TokenUtilities.exponentialFormat.format(this._value) + unitString;
    }

    @Override
    public Token zero() {
        return ZERO;
    }

    @Override
    protected ScalarToken _absolute() {
        DoubleToken result = this._value >= 0.0 ? this : new DoubleToken(-this._value);
        return result;
    }

    @Override
    protected ScalarToken _add(ScalarToken rightArgument) {
        double sum = this._value + ((DoubleToken)rightArgument).doubleValue();
        return new DoubleToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseAnd(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(DoubleToken.notSupportedMessage("bitwiseAnd", this, rightArgument));
    }

    @Override
    protected ScalarToken _bitwiseNot() throws IllegalActionException {
        throw new IllegalActionException(DoubleToken.notSupportedMessage("bitwiseNot", this, this));
    }

    @Override
    protected ScalarToken _bitwiseOr(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(DoubleToken.notSupportedMessage("bitwiseOr", this, rightArgument));
    }

    @Override
    protected ScalarToken _bitwiseXor(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(DoubleToken.notSupportedMessage("bitwiseXor", this, rightArgument));
    }

    @Override
    protected ScalarToken _divide(ScalarToken divisor) {
        double quotient = this._value / ((DoubleToken)divisor).doubleValue();
        return new DoubleToken(quotient);
    }

    @Override
    protected BooleanToken _isCloseTo(ScalarToken rightArgument, double epsilon) {
        double left;
        double right = ((DoubleToken)rightArgument).doubleValue();
        if (right > (left = this.doubleValue()) + epsilon || right < left - epsilon) {
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    protected BooleanToken _isLessThan(ScalarToken rightArgument) throws IllegalActionException {
        DoubleToken convertedArgument = (DoubleToken)rightArgument;
        return BooleanToken.getInstance(this._value < convertedArgument.doubleValue());
    }

    @Override
    protected ScalarToken _modulo(ScalarToken rightArgument) {
        double remainder = this._value % ((DoubleToken)rightArgument).doubleValue();
        return new DoubleToken(remainder);
    }

    @Override
    protected ScalarToken _multiply(ScalarToken rightArgument) {
        double product = this._value * ((DoubleToken)rightArgument).doubleValue();
        return new DoubleToken(product);
    }

    @Override
    protected ScalarToken _subtract(ScalarToken rightArgument) {
        double difference = this._value - ((DoubleToken)rightArgument).doubleValue();
        return new DoubleToken(difference);
    }
}

