/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.TokenUtilities;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;

public class PetiteToken
extends ScalarToken {
    public static final PetiteToken ONE = new PetiteToken(1.0);
    public static final PetiteToken ZERO = new PetiteToken(0.0);
    private double _value;

    public PetiteToken() {
        this._value = 0.0;
    }

    public PetiteToken(double value) {
        this._value = PetiteToken._adjust(value);
    }

    public PetiteToken(String init) throws IllegalActionException {
        try {
            this._value = PetiteToken._adjust(Double.parseDouble(init));
        }
        catch (NumberFormatException e) {
            throw new IllegalActionException(e.getMessage());
        }
    }

    public static PetiteToken convert(Token token) throws IllegalActionException {
        if (token instanceof PetiteToken) {
            return (PetiteToken)token;
        }
        if (token instanceof DoubleToken) {
            return new PetiteToken(((DoubleToken)token).doubleValue());
        }
        throw new IllegalActionException(PetiteToken.notSupportedConversionMessage(token, "petite"));
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    public double petiteValue() {
        return this._value;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return ((PetiteToken)object).petiteValue() == this._value;
    }

    @Override
    public Type getType() {
        return BaseType.PETITE;
    }

    public int hashCode() {
        return Double.valueOf(this._value).hashCode();
    }

    @Override
    public Token one() {
        return ONE;
    }

    @Override
    public String toString() {
        String unitString = "";
        if (!this._isUnitless()) {
            unitString = " * " + this.unitsString();
        }
        return TokenUtilities.regularFormat.format(this._value) + "p" + unitString;
    }

    @Override
    public Token zero() {
        return ZERO;
    }

    @Override
    protected ScalarToken _absolute() {
        PetiteToken result = this._value >= 0.0 ? this : new PetiteToken(-this._value);
        return result;
    }

    @Override
    protected ScalarToken _add(ScalarToken rightArgument) {
        double sum = this._value + ((PetiteToken)rightArgument).doubleValue();
        return new PetiteToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseAnd(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(PetiteToken.notSupportedMessage("bitwiseAnd", this, rightArgument));
    }

    @Override
    protected ScalarToken _bitwiseNot() throws IllegalActionException {
        throw new IllegalActionException(PetiteToken.notSupportedMessage("bitwiseNot", this, this));
    }

    @Override
    protected ScalarToken _bitwiseOr(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(PetiteToken.notSupportedMessage("bitwiseOr", this, rightArgument));
    }

    @Override
    protected ScalarToken _bitwiseXor(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(PetiteToken.notSupportedMessage("bitwiseXor", this, rightArgument));
    }

    @Override
    protected ScalarToken _divide(ScalarToken divisor) {
        double quotient = this._value / ((PetiteToken)divisor).doubleValue();
        return new PetiteToken(quotient);
    }

    @Override
    protected BooleanToken _isCloseTo(ScalarToken rightArgument, double epsilon) {
        double left;
        double right = ((PetiteToken)rightArgument).doubleValue();
        if (right > (left = this.petiteValue()) + epsilon || right < left - epsilon) {
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    protected BooleanToken _isLessThan(ScalarToken rightArgument) throws IllegalActionException {
        PetiteToken convertedArgument = (PetiteToken)rightArgument;
        return BooleanToken.getInstance(this._value < convertedArgument.doubleValue());
    }

    @Override
    protected ScalarToken _modulo(ScalarToken rightArgument) {
        double remainder = this._value % ((PetiteToken)rightArgument).doubleValue();
        return new PetiteToken(remainder);
    }

    @Override
    protected ScalarToken _multiply(ScalarToken rightArgument) {
        double product = this._value * ((PetiteToken)rightArgument).doubleValue();
        return new PetiteToken(product);
    }

    @Override
    protected ScalarToken _subtract(ScalarToken rightArgument) {
        double difference = this._value - ((PetiteToken)rightArgument).doubleValue();
        return new PetiteToken(difference);
    }

    protected static double _adjust(double number) {
        if (number >= 1.0) {
            return 1.0;
        }
        if (number < -1.0) {
            return -1.0;
        }
        return number;
    }
}

