/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ModelScope;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParseTreeFreeVariableCollector;
import ptolemy.data.expr.ParseTreeFreeVariableRenamer;
import ptolemy.data.expr.ParseTreeWriter;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.PtParser;
import ptolemy.data.expr.ScopeExtender;
import ptolemy.data.expr.ScopeExtendingAttribute;
import ptolemy.data.expr.UnknownResultException;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.StructuredType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeConstant;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.type.Typeable;
import ptolemy.graph.Inequality;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.AbstractSettableAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedList;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.ValueListener;
import ptolemy.kernel.util.Workspace;

public class Variable
extends AbstractSettableAttribute
implements Typeable,
ValueListener {
    protected String _currentExpression = null;
    protected boolean _needsEvaluation = false;
    protected ParserScope _parserScope = null;
    protected boolean _parseTreeValid = false;
    protected List _valueListeners;
    private transient boolean _dependencyLoop = false;
    private static StringToken _EMPTY_STRING_TOKEN = new StringToken("");
    private String _initialExpression;
    private boolean _isLazy;
    private boolean _isStringMode = false;
    private boolean _isTokenUnknown = false;
    private boolean _noTokenYet = true;
    private Token _initialToken;
    private HashMap _variablesDependentOn = null;
    private transient long _variablesDependentOnVersion = -1L;
    private Type _varType = BaseType.UNKNOWN;
    private ParseTreeEvaluator _parseTreeEvaluator;
    private boolean _propagating;
    private Token _token;
    private List _constraints = new LinkedList();
    private Type _declaredType = BaseType.UNKNOWN;
    private ASTPtRootNode _parseTree;
    private Type _typeAtMost = BaseType.UNKNOWN;
    private TypeTerm _typeTerm = null;
    private Settable.Visibility _visibility = Settable.EXPERT;

    public Variable() {
        this.setPersistent(false);
    }

    public Variable(Workspace workspace) {
        super(workspace);
        this.setPersistent(false);
    }

    public Variable(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setPersistent(false);
    }

    public Variable(NamedObj container, String name, Token token) throws IllegalActionException, NameDuplicationException {
        this(container, name, token, true);
    }

    protected Variable(NamedObj container, String name, Token token, boolean incrementWorkspaceVersion) throws IllegalActionException, NameDuplicationException {
        super(container, name, incrementWorkspaceVersion);
        if (token != null) {
            this._setToken(token);
            super.setExpression(token.toString());
        }
        this.setPersistent(false);
    }

    @Override
    public synchronized void addValueListener(ValueListener listener) {
        if (this._valueListeners == null) {
            this._valueListeners = new LinkedList();
        }
        if (!this._valueListeners.contains(listener)) {
            this._valueListeners.add(listener);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Variable newObject = (Variable)super.clone(workspace);
        if (this._currentExpression != null) {
            newObject._needsEvaluation = true;
        }
        newObject._dependencyLoop = false;
        newObject._parserScope = null;
        newObject._variablesDependentOn = null;
        newObject._valueListeners = null;
        if (this._declaredType instanceof StructuredType && !this._declaredType.isConstant()) {
            newObject._varType = newObject._declaredType = (Type)((StructuredType)this._declaredType).clone();
        }
        newObject._parseTree = null;
        newObject._parseTreeValid = false;
        newObject._constraints = new LinkedList();
        newObject._typeTerm = null;
        return newObject;
    }

    public Type getDeclaredType() {
        return this._declaredType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getFreeIdentifiers() throws IllegalActionException {
        if (this._currentExpression == null) {
            return Collections.EMPTY_SET;
        }
        try {
            this.workspace().getReadAccess();
            this._parseIfNecessary();
            ParseTreeFreeVariableCollector collector = new ParseTreeFreeVariableCollector();
            Set set = collector.collectFreeVariables(this._parseTree);
            return set;
        }
        finally {
            this.workspace().doneReading();
        }
    }

    @Override
    public String getExpression() {
        String value = this._currentExpression;
        if (value == null) {
            Token token = null;
            try {
                token = this.getToken();
            }
            catch (IllegalActionException illegalActionException) {
                // empty catch block
            }
            if (token != null) {
                value = this.isStringMode() ? ((StringToken)token).stringValue() : token.toString();
            }
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public ParserScope getParserScope() {
        if (this._parserScope == null) {
            this._parserScope = new VariableScope();
        }
        return this._parserScope;
    }

    public NamedList getScope() {
        return Variable.getScope(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedList getScope(NamedObj object) {
        try {
            object.workspace().getReadAccess();
            NamedList scope = new NamedList();
            for (NamedObj container = object.getContainer(); container != null; container = container.getContainer()) {
                Iterator level1 = container.attributeList().iterator();
                Attribute var2 = null;
                while (level1.hasNext()) {
                    var2 = (Attribute)level1.next();
                    if (!(var2 instanceof Variable) || var2 == object || var2.workspace() != object.workspace()) continue;
                    try {
                        scope.append(var2);
                    }
                    catch (NameDuplicationException ex) {
                    }
                    catch (IllegalActionException ex) {}
                }
                for (ScopeExtender extender : container.attributeList(ScopeExtender.class)) {
                    for (Attribute var2 : extender.attributeList()) {
                        if (!(var2 instanceof Variable) || var2 == object || var2.workspace() != object.workspace()) continue;
                        try {
                            scope.append(var2);
                        }
                        catch (NameDuplicationException ex) {
                        }
                        catch (IllegalActionException ex) {}
                    }
                }
            }
            NamedList namedList = scope;
            return namedList;
        }
        finally {
            object.workspace().doneReading();
        }
    }

    public Token getToken() throws IllegalActionException {
        if (this._isTokenUnknown) {
            throw new UnknownResultException(this);
        }
        if (this._needsEvaluation) {
            this._evaluate();
        }
        if (this._token == null && this.isStringMode()) {
            this._token = _EMPTY_STRING_TOKEN;
        }
        return this._token;
    }

    @Override
    public Type getType() {
        try {
            if (this._needsEvaluation) {
                this._evaluate();
            }
            return this._varType;
        }
        catch (IllegalActionException iae) {
            return this._declaredType;
        }
    }

    @Override
    public InequalityTerm getTypeTerm() {
        if (this._typeTerm == null) {
            this._typeTerm = new TypeTerm();
        }
        return this._typeTerm;
    }

    @Override
    public String getValueAsString() {
        Token value = null;
        try {
            value = this.getToken();
        }
        catch (IllegalActionException ex) {
            // empty catch block
        }
        String tokenString = value == null ? "null" : value.toString();
        return tokenString;
    }

    public Variable getVariable(String name) throws IllegalActionException {
        return ((VariableScope)this.getParserScope()).getVariable(name);
    }

    @Override
    public Settable.Visibility getVisibility() {
        return this._visibility;
    }

    public void invalidate() {
        if (this._currentExpression != null) {
            this._needsEvaluation = true;
        }
        if (this._variablesDependentOn != null) {
            for (Map.Entry entry : this._variablesDependentOn.entrySet()) {
                Variable variable = (Variable)entry.getValue();
                variable.removeValueListener(this);
            }
            this._variablesDependentOn.clear();
        }
        this._notifyValueListeners();
    }

    public boolean isKnown() throws IllegalActionException {
        try {
            this.getToken();
        }
        catch (UnknownResultException ex) {
            return false;
        }
        return true;
    }

    public boolean isLazy() {
        return this._isLazy;
    }

    public boolean isStringMode() {
        if (this._isStringMode) {
            return true;
        }
        return this.getAttribute("_stringMode") != null;
    }

    @Override
    public boolean isTypeAcceptable() {
        return this.getType().isInstantiable();
    }

    @Override
    public synchronized void removeValueListener(ValueListener listener) {
        if (this._valueListeners != null) {
            this._valueListeners.remove(listener);
        }
    }

    public void reset() {
        if (this._noTokenYet) {
            return;
        }
        if (this._initialToken != null) {
            try {
                this.setToken(this._initialToken);
            }
            catch (IllegalActionException ex) {
                throw new InternalErrorException(ex.getMessage());
            }
        } else {
            this.setExpression(this._initialExpression);
        }
    }

    @Override
    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        NamedObj previousContainer = this.getContainer();
        super.setContainer(container);
        if (container != previousContainer) {
            this._invalidateShadowedSettables(container);
            if (previousContainer != null) {
                this.validate();
            }
        }
    }

    @Override
    public void setExpression(String expr) {
        try {
            super.setExpression(expr);
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        if (this._debugging) {
            this._debug("setExpression: " + expr);
        }
        if (expr == null || expr.trim().equals("")) {
            this._token = null;
            this._needsEvaluation = false;
            if (this._declaredType instanceof StructuredType) {
                ((StructuredType)this._varType).initialize(BaseType.UNKNOWN);
            } else {
                this._varType = this._declaredType;
            }
        } else {
            this._needsEvaluation = true;
        }
        this._currentExpression = expr;
        this._parseTree = null;
        this._parseTreeValid = false;
        this._notifyValueListeners();
    }

    public void setLazy(boolean lazy) {
        if (this._debugging) {
            this._debug("setLazy: " + lazy);
        }
        this._isLazy = lazy;
    }

    @Override
    public void setName(String name) throws IllegalActionException, NameDuplicationException {
        String previousName = this.getName();
        LinkedList<ValueListener> changed = new LinkedList<ValueListener>();
        if (previousName != null && !previousName.equals(name)) {
            try {
                if (this._valueListeners != null) {
                    for (ValueListener listener : this._valueListeners) {
                        if (!(listener instanceof Variable)) continue;
                        ParseTreeFreeVariableRenamer parseTreeFreeVariableRenamer = new ParseTreeFreeVariableRenamer();
                        ((Variable)listener)._parseIfNecessary();
                        parseTreeFreeVariableRenamer.renameVariables(((Variable)listener)._parseTree, (Variable)listener, this, name);
                        ParseTreeWriter writer = new ParseTreeWriter();
                        ((Variable)listener).setExpression(writer.parseTreeToExpression(((Variable)listener)._parseTree));
                        changed.add(listener);
                    }
                }
                super.setName(name);
                this._invalidateShadowedSettables(this.getContainer());
                this.validate();
            }
            catch (IllegalActionException ex) {
                super.setName(previousName);
                for (Variable variable : changed) {
                    ParseTreeFreeVariableRenamer renamer = new ParseTreeFreeVariableRenamer();
                    renamer.renameVariables(variable._parseTree, variable, this, previousName);
                    ParseTreeWriter writer = new ParseTreeWriter();
                    variable.setExpression(writer.parseTreeToExpression(variable._parseTree));
                }
                this.validate();
                throw ex;
            }
        } else {
            super.setName(name);
        }
    }

    public void setParseTreeEvaluator(ParseTreeEvaluator parseTreeEvaluator) {
        this._parseTreeEvaluator = parseTreeEvaluator;
    }

    public void setStringMode(boolean stringMode) throws IllegalActionException {
        this._isStringMode = stringMode;
        if (this._isStringMode) {
            this.setTypeEquals(BaseType.STRING);
        } else {
            this.setTypeEquals(BaseType.UNKNOWN);
        }
    }

    public void setToken(Token token) throws IllegalActionException {
        if (this._debugging) {
            this._debug("setToken: " + token);
        }
        this._setTokenAndNotify(token);
        if (this._currentExpression != null) {
            this._currentExpression = null;
            this._parseTree = null;
            this._parseTreeValid = false;
        }
        this.setUnknown(false);
    }

    public void setToken(String expression) throws IllegalActionException {
        this.setExpression(expression);
        this.validate();
    }

    @Override
    public void setTypeAtLeast(Typeable lesser) {
        if (this._debugging) {
            String name = "not named";
            if (lesser instanceof Nameable) {
                name = ((Nameable)((Object)lesser)).getFullName();
            }
            this._debug("setTypeAtLeast: " + name);
        }
        Inequality ineq = new Inequality(lesser.getTypeTerm(), this.getTypeTerm());
        this._constraints.add(ineq);
    }

    @Override
    public void setTypeAtLeast(InequalityTerm typeTerm) {
        if (this._debugging) {
            String name = "not named";
            if (typeTerm.getAssociatedObject() instanceof Nameable) {
                name = ((Nameable)typeTerm.getAssociatedObject()).getFullName();
            }
            this._debug("setTypeAtLeast: " + name);
        }
        Inequality ineq = new Inequality(typeTerm, this.getTypeTerm());
        this._constraints.add(ineq);
    }

    @Override
    public void setTypeAtMost(Type type) throws IllegalActionException {
        if (this._debugging) {
            this._debug("setTypeAtMost: " + type);
        }
        if (type == BaseType.UNKNOWN) {
            this._typeAtMost = BaseType.UNKNOWN;
            return;
        }
        if (!type.isInstantiable()) {
            throw new IllegalActionException((Nameable)this, "setTypeAtMost(): the argument " + type + " is not an instantiable type in the type lattice.");
        }
        Type currentType = this.getType();
        int typeInfo = TypeLattice.compare(currentType, type);
        if (typeInfo == 1 || typeInfo == 2) {
            throw new IllegalActionException((Nameable)this, "setTypeAtMost(): the current type " + ((Object)currentType).toString() + " is not less than the desired bounding type " + ((Object)type).toString());
        }
        this._typeAtMost = type;
    }

    @Override
    public void setTypeEquals(Type type) throws IllegalActionException {
        if (this._debugging) {
            this._debug("setTypeEquals: " + type);
        }
        if (this._token != null) {
            if (type.isCompatible(this._token.getType())) {
                this._token = type.convert(this._token);
            } else {
                throw new IllegalActionException((Nameable)this, "The currently contained token " + this._token.getClass().getName() + "(" + this._token.toString() + ") is not compatible with the desired type " + ((Object)type).toString());
            }
        }
        try {
            this._declaredType = (Type)type.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalErrorException("Variable.setTypeEquals: The specified type cannot be cloned.");
        }
        this._varType = this._declaredType;
        if (this._token != null && this._declaredType instanceof StructuredType) {
            ((StructuredType)this._varType).updateType((StructuredType)this._token.getType());
        }
    }

    public void setUnknown(boolean value) {
        if (this._debugging) {
            this._debug("setUnknown: " + value);
        }
        this._isTokenUnknown = value;
    }

    @Override
    public void setVisibility(Settable.Visibility visibility) {
        if (this._debugging) {
            this._debug("setVisibility: " + visibility);
        }
        this._visibility = visibility;
    }

    @Override
    public void setTypeSameAs(Typeable equal) {
        if (this._debugging) {
            String name = "not named";
            if (equal instanceof Nameable) {
                name = ((Nameable)((Object)equal)).getFullName();
            }
            this._debug("setTypeSameAs: " + name);
        }
        Inequality ineq = new Inequality(this.getTypeTerm(), equal.getTypeTerm());
        this._constraints.add(ineq);
        ineq = new Inequality(equal.getTypeTerm(), this.getTypeTerm());
        this._constraints.add(ineq);
    }

    public String stringRepresentation() {
        return this.getExpression();
    }

    @Override
    public String toString() {
        Token value = null;
        try {
            value = this.getToken();
        }
        catch (IllegalActionException ex) {
            // empty catch block
        }
        String tokenString = value == null ? "value undefined" : value.toString();
        if (tokenString.length() > 50) {
            tokenString = "value elided";
        }
        return super.toString() + " " + tokenString;
    }

    @Override
    public List typeConstraintList() {
        LinkedList<Inequality> result = new LinkedList<Inequality>();
        result.addAll(this._constraints);
        try {
            Token currentToken = this.getToken();
            if (currentToken != null) {
                Type currentType = currentToken.getType();
                TypeConstant current = new TypeConstant(currentType);
                Inequality ineq = new Inequality(current, this.getTypeTerm());
                result.add(ineq);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this._typeAtMost != BaseType.UNKNOWN) {
            TypeConstant atMost = new TypeConstant(this._typeAtMost);
            Inequality ineq = new Inequality(this.getTypeTerm(), atMost);
            result.add(ineq);
        }
        return result;
    }

    @Override
    public Collection validate() throws IllegalActionException {
        NamedObj container;
        if (this._debugging) {
            this._debug("validate");
        }
        this.invalidate();
        List errors = this._propagate();
        if (errors != null && errors.size() > 0) {
            Iterator errorsIterator = errors.iterator();
            StringBuffer message = new StringBuffer();
            while (errorsIterator.hasNext()) {
                Exception error = (Exception)errorsIterator.next();
                message.append(error.getMessage());
                if (!errorsIterator.hasNext()) continue;
                message.append("\n-------------- and --------------\n");
            }
            throw new IllegalActionException(message.toString());
        }
        if (!this._isLazy && (container = this.getContainer()) != null) {
            container.attributeChanged(this);
        }
        HashSet result = null;
        if (this._valueListeners != null) {
            result = new HashSet();
            for (Object listener : this._valueListeners) {
                if (!(listener instanceof Variable)) continue;
                result.add(listener);
            }
        }
        return result;
    }

    @Override
    public void valueChanged(Settable settable) {
        if (!this._needsEvaluation) {
            if (this._currentExpression != null) {
                this._needsEvaluation = true;
            }
            this._notifyValueListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _description(int detail, int indent, int bracket) {
        try {
            this.workspace().getReadAccess();
            String result = Variable._getIndentPrefix(indent);
            if (bracket == 1 || bracket == 2) {
                result = result + "{";
            }
            result = result + this.toString();
            if (bracket == 2) {
                result = result + "}";
            }
            String string = result;
            return string;
        }
        finally {
            this.workspace().doneReading();
        }
    }

    protected void _evaluate() throws IllegalActionException {
        if (this._currentExpression == null || (this.isStringMode() ? this._currentExpression.equals("") : this._currentExpression.trim().equals(""))) {
            this._setToken(null);
            return;
        }
        if (this._dependencyLoop) {
            this._dependencyLoop = false;
            throw new IllegalActionException("There is a dependency loop where " + this.getFullName() + " directly or indirectly" + " refers to itself in its expression: " + this._currentExpression);
        }
        this._dependencyLoop = true;
        try {
            this.workspace().getReadAccess();
            this._parseIfNecessary();
            if (this._parseTreeEvaluator == null) {
                this._parseTreeEvaluator = new ParseTreeEvaluator();
            }
            if (this._parserScope == null) {
                this._parserScope = new VariableScope();
            }
            Token result = this._parseTreeEvaluator.evaluateParseTree(this._parseTree, this._parserScope);
            this._setTokenAndNotify(result);
        }
        catch (IllegalActionException ex) {
            this._needsEvaluation = true;
            throw new IllegalActionException((Nameable)this, ex, "Error evaluating expression: " + this._currentExpression);
        }
        finally {
            this._dependencyLoop = false;
            this.workspace().doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _notifyValueListeners() {
        if (this._valueListeners != null) {
            Iterator listeners;
            Variable variable = this;
            synchronized (variable) {
                listeners = new LinkedList(this._valueListeners).iterator();
            }
            while (listeners.hasNext()) {
                ValueListener listener = (ValueListener)listeners.next();
                listener.valueChanged(this);
            }
        }
    }

    protected final void _parseIfNecessary() throws IllegalActionException {
        if (!this._parseTreeValid) {
            if (this._currentExpression == null) {
                throw new IllegalActionException((Nameable)this, "Empty expression cannot be parsed!");
            }
            PtParser parser = new PtParser();
            this._parseTree = this.isStringMode() ? parser.generateStringParseTree(this._currentExpression) : parser.generateParseTree(this._currentExpression);
            this._parseTreeValid = this._parseTree != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List _propagate() {
        if (this._propagating) {
            return null;
        }
        this._propagating = true;
        try {
            LinkedList<IllegalActionException> result = null;
            if (this._needsEvaluation && !this._isLazy) {
                try {
                    this._evaluate();
                }
                catch (IllegalActionException ex) {
                    try {
                        this.handleModelError(this, ex);
                    }
                    catch (IllegalActionException ex2) {
                        result = new LinkedList<IllegalActionException>();
                        result.add(ex2);
                    }
                }
            }
            LinkedList<IllegalActionException> additionalErrors = this._propagateToValueListeners();
            if (result == null) {
                result = additionalErrors;
            } else if (additionalErrors != null) {
                result.addAll(additionalErrors);
            }
            LinkedList<IllegalActionException> linkedList = result;
            return linkedList;
        }
        finally {
            this._propagating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List _propagateToValueListeners() {
        LinkedList result = null;
        if (this._valueListeners != null) {
            Iterator listeners;
            Variable variable = this;
            synchronized (variable) {
                listeners = new LinkedList(this._valueListeners).iterator();
            }
            while (listeners.hasNext()) {
                List additionalErrors;
                ValueListener listener = (ValueListener)listeners.next();
                if (!(listener instanceof Variable) || !((Variable)listener)._needsEvaluation || (additionalErrors = ((Variable)listener)._propagate()) == null) continue;
                if (result == null) {
                    result = new LinkedList();
                }
                result.addAll(additionalErrors);
            }
        }
        return result;
    }

    @Override
    protected void _propagateValue(NamedObj destination) throws IllegalActionException {
        ((Settable)((Object)destination)).setExpression(this.getExpression());
    }

    protected void _setToken(Token newToken) throws IllegalActionException {
        if (newToken == null) {
            this._token = null;
            this._needsEvaluation = false;
            if (this._declaredType instanceof StructuredType) {
                ((StructuredType)this._varType).initialize(BaseType.UNKNOWN);
            } else {
                this._varType = this._declaredType;
            }
        } else {
            Type tokenType;
            int comparison;
            Type declaredType;
            try {
                declaredType = (Type)this._declaredType.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new InternalErrorException("Variable._setToken: Cannot clone the declared type of this Variable.");
            }
            if (declaredType instanceof StructuredType) {
                ((StructuredType)declaredType).initialize(BaseType.UNKNOWN);
            }
            if (!declaredType.isCompatible(newToken.getType())) {
                throw new IllegalActionException((Nameable)this, "Variable._setToken: Cannot store a token of type " + ((Object)newToken.getType()).toString() + ", which is incompatible with type " + ((Object)declaredType).toString());
            }
            newToken = declaredType.convert(newToken);
            if (this._declaredType instanceof StructuredType) {
                ((StructuredType)this._varType).updateType((StructuredType)newToken.getType());
            } else {
                this._varType = newToken.getType();
            }
            if (this._typeAtMost != BaseType.UNKNOWN && ((comparison = TypeLattice.compare(tokenType = newToken.getType(), this._typeAtMost)) == 1 || comparison == 2)) {
                throw new IllegalActionException((Nameable)this, "Cannot store a token of type " + ((Object)tokenType).toString() + ", which is not less than or equal to " + ((Object)this._typeAtMost).toString());
            }
            if (this._noTokenYet) {
                this._initialExpression = this._currentExpression;
                if (this._currentExpression == null) {
                    this._initialToken = newToken;
                }
                this._noTokenYet = false;
            }
            this._token = newToken;
            this._needsEvaluation = false;
        }
    }

    protected void _setTokenAndNotify(Token newToken) throws IllegalActionException {
        Token oldToken = this._token;
        Type oldVarType = this._varType;
        if (this._varType instanceof StructuredType) {
            try {
                oldVarType = (Type)((StructuredType)this._varType).clone();
            }
            catch (CloneNotSupportedException ex2) {
                throw new InternalErrorException("Variable._setTokenAndNotify:  Cannot clone _varType" + ex2.getMessage());
            }
        }
        boolean oldNoTokenYet = this._noTokenYet;
        String oldInitialExpression = this._initialExpression;
        Token oldInitialToken = this._initialToken;
        try {
            this._setToken(newToken);
            NamedObj container = this.getContainer();
            if (container != null) {
                if (!((Object)oldVarType).equals(this._varType) && oldVarType != BaseType.UNKNOWN) {
                    container.attributeTypeChanged(this);
                }
                container.attributeChanged(this);
            }
            this._notifyValueListeners();
        }
        catch (IllegalActionException ex) {
            this._token = oldToken;
            if (this._varType instanceof StructuredType && oldVarType instanceof StructuredType) {
                ((StructuredType)this._varType).updateType((StructuredType)oldVarType);
            } else {
                this._varType = oldVarType;
            }
            this._noTokenYet = oldNoTokenYet;
            this._initialExpression = oldInitialExpression;
            this._initialToken = oldInitialToken;
            throw ex;
        }
    }

    private void _invalidateShadowedSettables(NamedObj object) throws IllegalActionException {
        if (object == null) {
            return;
        }
        for (Variable variable : object.attributeList(Variable.class)) {
            if (!variable.getName().equals(this.getName())) continue;
            variable.invalidate();
        }
        for (ScopeExtendingAttribute attribute : object.attributeList(ScopeExtendingAttribute.class)) {
            for (Variable variable : attribute.attributeList(Variable.class)) {
                if (!variable.getName().equals(this.getName())) continue;
                variable.invalidate();
            }
        }
        NamedObj container = object.getContainer();
        if (container != null) {
            this._invalidateShadowedSettables(container);
        }
    }

    protected class VariableScope
    extends ModelScope {
        private NamedObj _reference;

        public VariableScope() {
            this(null);
        }

        public VariableScope(NamedObj reference) {
            this._reference = reference;
        }

        @Override
        public Token get(String name) throws IllegalActionException {
            Variable results = this.getVariable(name);
            if (results != null) {
                return results.getToken();
            }
            return null;
        }

        @Override
        public Type getType(String name) throws IllegalActionException {
            Variable result;
            NamedObj reference = this._reference;
            if (this._reference == null) {
                reference = Variable.this.getContainer();
            }
            if ((result = VariableScope.getScopedVariable(Variable.this, reference, name)) != null) {
                return result.getType();
            }
            return null;
        }

        @Override
        public InequalityTerm getTypeTerm(String name) throws IllegalActionException {
            Variable result;
            NamedObj reference = this._reference;
            if (this._reference == null) {
                reference = Variable.this.getContainer();
            }
            if ((result = VariableScope.getScopedVariable(Variable.this, reference, name)) != null) {
                return result.getTypeTerm();
            }
            return null;
        }

        public Variable getVariable(String name) throws IllegalActionException {
            Variable result;
            if (Variable.this._variablesDependentOn == null) {
                Variable.this._variablesDependentOn = new HashMap();
            } else if (Variable.this._variablesDependentOnVersion == Variable.this.workspace().getVersion()) {
                Variable result2 = (Variable)Variable.this._variablesDependentOn.get(name);
                if (result2 != null) {
                    return result2;
                }
            } else {
                Variable.this._variablesDependentOn.clear();
            }
            Variable.this._variablesDependentOnVersion = Variable.this.workspace().getVersion();
            NamedObj reference = this._reference;
            if (this._reference == null) {
                reference = Variable.this.getContainer();
            }
            if ((result = VariableScope.getScopedVariable(Variable.this, reference, name)) != null) {
                if (!Variable.this._variablesDependentOn.containsValue(result)) {
                    result.addValueListener(Variable.this);
                    Variable.this._variablesDependentOn.put(name, result);
                }
                return result;
            }
            return null;
        }

        @Override
        public Set identifierSet() {
            NamedObj reference = this._reference;
            if (this._reference == null) {
                reference = Variable.this.getContainer();
            }
            return VariableScope.getAllScopedVariableNames(Variable.this, reference);
        }
    }

    private class TypeTerm
    implements InequalityTerm {
        private TypeTerm() {
        }

        @Override
        public Object getAssociatedObject() {
            return Variable.this;
        }

        @Override
        public Object getValue() {
            return Variable.this.getType();
        }

        @Override
        public InequalityTerm[] getVariables() {
            if (this.isSettable()) {
                InequalityTerm[] result = new InequalityTerm[]{this};
                return result;
            }
            return new InequalityTerm[0];
        }

        @Override
        public void initialize(Object e) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("TypeTerm.initialize: The type is not settable.");
            }
            if (!(e instanceof Type)) {
                throw new IllegalActionException("TypeTerm.initialize: The argument is not a Type.");
            }
            if (Variable.this._declaredType == BaseType.UNKNOWN) {
                Variable.this._varType = (Type)e;
            } else {
                ((StructuredType)Variable.this._varType).initialize((Type)e);
            }
        }

        @Override
        public boolean isSettable() {
            return !Variable.this._declaredType.isConstant();
        }

        @Override
        public boolean isValueAcceptable() {
            return Variable.this.isTypeAcceptable();
        }

        @Override
        public void setValue(Object e) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("TypeTerm.setValue: The type is not settable.");
            }
            if (!Variable.this._declaredType.isSubstitutionInstance((Type)e)) {
                throw new IllegalActionException("Variable$TypeTerm.setValue: Cannot update the type of this variable to the new type. Variable: " + Variable.this.getFullName() + ", Variable type: " + ((Object)Variable.this._declaredType).toString() + ", New type: " + e.toString());
            }
            if (Variable.this._declaredType == BaseType.UNKNOWN) {
                Variable.this._varType = (Type)e;
            } else {
                ((StructuredType)Variable.this._varType).updateType((StructuredType)e);
            }
        }

        public String toString() {
            return "(" + Variable.this.toString() + ", " + Variable.this.getType() + ")";
        }
    }
}

