/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.type;

import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.FunctionType;
import ptolemy.data.type.RecordType;
import ptolemy.data.type.StructuredType;
import ptolemy.data.type.Type;
import ptolemy.data.type.UnionType;
import ptolemy.graph.CPO;
import ptolemy.graph.DirectedAcyclicGraph;
import ptolemy.kernel.util.InternalErrorException;

public class TypeLattice {
    private static TheTypeLattice _lattice = new TheTypeLattice();
    private static int[][] _compareCache;

    public static CPO basicLattice() {
        return _lattice._basicLattice;
    }

    public static synchronized int compare(Token token1, Token token2) {
        if (token1 == null || token2 == null) {
            throw new IllegalArgumentException("TypeLattice.compare(Token, Token): one or both of the argument tokens is null:  token1 = " + token1 + ", token2 = " + token2);
        }
        return TypeLattice.compare(token1.getType(), token2.getType());
    }

    public static synchronized int compare(Token token, Type type) {
        if (token == null) {
            throw new IllegalArgumentException("TypeLattice.compare(Token, Type): token argument is null");
        }
        return TypeLattice.compare(token.getType(), type);
    }

    public static synchronized int compare(Type type, Token token) {
        if (token == null) {
            throw new IllegalArgumentException("TypeLattice.compare(Type, Token): token argument is null");
        }
        return TypeLattice.compare(type, token.getType());
    }

    public static synchronized int compare(Type type1, Type type2) {
        if (type1 == null || type2 == null) {
            throw new IllegalArgumentException("TypeLattice.compare(Type, Type): one or both of the argument types is null:  type1 = " + type1 + ", type2 = " + type2);
        }
        int i1 = type1.getTypeHash();
        int i2 = type2.getTypeHash();
        if (i1 != Integer.MIN_VALUE && i2 != Integer.MIN_VALUE) {
            if (TypeLattice._getCachedTypeComparisonResult(i1, i2) == Integer.MIN_VALUE) {
                TypeLattice._setCachedTypeComparisonResult(i1, i2, _lattice.compare(type1, type2));
            }
            return TypeLattice._getCachedTypeComparisonResult(i1, i2);
        }
        return _lattice.compare(type1, type2);
    }

    public static CPO lattice() {
        return _lattice;
    }

    public static synchronized Type leastUpperBound(Type type1, Type type2) {
        return (Type)_lattice.leastUpperBound(type1, type2);
    }

    private static final int _getCachedTypeComparisonResult(int index1, int index2) {
        return _compareCache[index1][index2];
    }

    private static final void _setCachedTypeComparisonResult(int index1, int index2, int value) {
        TypeLattice._compareCache[index1][index2] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<TypeLattice> clazz = TypeLattice.class;
        synchronized (TypeLattice.class) {
            _compareCache = new int[17][17];
            for (int i = 0; i <= 16; ++i) {
                for (int j = 0; j <= 16; ++j) {
                    TypeLattice._compareCache[i][j] = Integer.MIN_VALUE;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class TheTypeLattice
    implements CPO {
        private DirectedAcyclicGraph _basicLattice;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object bottom() {
            Class<TypeLattice> clazz = TypeLattice.class;
            synchronized (TypeLattice.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this._basicLattice.bottom();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compare(Object t1, Object t2) {
            Class<TypeLattice> clazz = TypeLattice.class;
            synchronized (TypeLattice.class) {
                Type t2Rep;
                if (!(t1 instanceof Type) || !(t2 instanceof Type)) {
                    throw new IllegalArgumentException("TheTypeLattice.compare: Arguments are not instances of Type:  type1 = " + t1 + ", type2 = " + t2);
                }
                Type ct1 = (Type)t1;
                Type ct2 = (Type)t2;
                Type t1Rep = this._toRepresentative(ct1);
                if (((Object)t1Rep).equals(t2Rep = this._toRepresentative(ct2)) && t1Rep instanceof StructuredType) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return ((StructuredType)t1)._compare((StructuredType)t2);
                }
                if (!(!(t1Rep instanceof ArrayType) || t2Rep instanceof ArrayType || t2.equals(BaseType.UNKNOWN) || t2.equals(BaseType.GENERAL) || t2.equals(BaseType.ARRAY_BOTTOM))) {
                    ArrayType arrayType = (ArrayType)t1;
                    if (arrayType.hasKnownLength() && arrayType.length() != 1 && !t2.equals(BaseType.GENERAL)) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return 2;
                    }
                    int elementComparison = this.compare(((ArrayType)ct1).getElementType(), t2Rep);
                    if (elementComparison == 0 || elementComparison == 1) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return 1;
                    }
                    if (t2Rep == BaseType.GENERAL) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return -1;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return 2;
                }
                if (!(!(t2Rep instanceof ArrayType) || t1Rep instanceof ArrayType || t1.equals(BaseType.UNKNOWN) || t1.equals(BaseType.GENERAL) || t1.equals(BaseType.ARRAY_BOTTOM))) {
                    ArrayType arrayType = (ArrayType)t2;
                    if (arrayType.hasKnownLength() && arrayType.length() != 1 && !t1.equals(BaseType.GENERAL)) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return 2;
                    }
                    int elementComparison = this.compare(((ArrayType)ct2).getElementType(), t1Rep);
                    if (elementComparison == 0 || elementComparison == 1) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return -1;
                    }
                    if (t1Rep == BaseType.GENERAL) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return 1;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return 2;
                }
                if (this._basicLattice.containsNodeWeight(t1Rep) && this._basicLattice.containsNodeWeight(t2Rep)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return this._basicLattice.compare(t1Rep, t2Rep);
                }
                if (((Object)t1Rep).equals(t2Rep)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return 0;
                }
                if (t1Rep == BaseType.UNKNOWN || t2Rep == BaseType.GENERAL) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return -1;
                }
                if (t2Rep == BaseType.UNKNOWN || t1Rep == BaseType.GENERAL) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return 1;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return 2;
            }
        }

        @Override
        public Object[] downSet(Object e) {
            throw new UnsupportedOperationException("TheTypeLattice.downSet(): operation not supported for the type lattice.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object greatestLowerBound(Object t1, Object t2) {
            Class<TypeLattice> clazz = TypeLattice.class;
            synchronized (TypeLattice.class) {
                Type t2Rep;
                if (!(t1 instanceof Type) || !(t2 instanceof Type)) {
                    throw new IllegalArgumentException("TheTypeLattice.greatestLowerBound: Arguments are not instances of Type.");
                }
                Type ct1 = (Type)t1;
                Type ct2 = (Type)t2;
                Type t1Rep = this._toRepresentative(ct1);
                if (((Object)t1Rep).equals(t2Rep = this._toRepresentative(ct2)) && t1Rep instanceof StructuredType) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return ((StructuredType)t1)._greatestLowerBound((StructuredType)t2);
                }
                if (t1Rep instanceof ArrayType && !(t2Rep instanceof ArrayType) && !t2.equals(BaseType.UNKNOWN) && !t2.equals(BaseType.ARRAY_BOTTOM)) {
                    ArrayType arrayType = (ArrayType)t1;
                    int elementComparison = this.compare(((ArrayType)ct1).getElementType(), t2Rep);
                    if (elementComparison == 0 || elementComparison == 1) {
                        if (arrayType.hasKnownLength() && arrayType.length() != 1) {
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return BaseType.UNKNOWN;
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t2;
                    }
                    if (t2Rep == BaseType.GENERAL) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t1;
                    }
                    if (this._basicLattice.containsNodeWeight(t2Rep)) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return this._basicLattice.greatestLowerBound(t1Rep, t2Rep);
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return BaseType.UNKNOWN;
                }
                if (t2Rep instanceof ArrayType && !(t1Rep instanceof ArrayType) && !t1.equals(BaseType.UNKNOWN) && !t1.equals(BaseType.ARRAY_BOTTOM)) {
                    ArrayType arrayType = (ArrayType)t2;
                    int elementComparison = this.compare(((ArrayType)ct2).getElementType(), t1Rep);
                    if (elementComparison == 0 || elementComparison == 1) {
                        if (arrayType.hasKnownLength() && arrayType.length() != 1) {
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return BaseType.UNKNOWN;
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t1;
                    }
                    if (t1Rep == BaseType.GENERAL) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t2;
                    }
                    if (this._basicLattice.containsNodeWeight(t1Rep)) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return this._basicLattice.greatestLowerBound(t1Rep, t2Rep);
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return BaseType.UNKNOWN;
                }
                if (this._basicLattice.containsNodeWeight(t1Rep) && this._basicLattice.containsNodeWeight(t2Rep)) {
                    int relation = this._basicLattice.compare(t1Rep, t2Rep);
                    if (relation == 0) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t1;
                    }
                    if (relation == -1) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t1;
                    }
                    if (relation == 1) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t2;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return this._basicLattice.greatestLowerBound(t1Rep, t2Rep);
                }
                if (((Object)t1Rep).equals(t2Rep)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return t1;
                }
                if (t1Rep == BaseType.UNKNOWN || t2Rep == BaseType.GENERAL) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return t1;
                }
                if (t2Rep == BaseType.UNKNOWN || t1Rep == BaseType.GENERAL) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return t2;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.bottom();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object greatestLowerBound(Object[] subset) {
            Class<TypeLattice> clazz = TypeLattice.class;
            synchronized (TypeLattice.class) {
                if (subset.length == 0) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return BaseType.GENERAL;
                }
                Object glb = subset[0];
                for (int i = 0; i < subset.length; ++i) {
                    glb = this.greatestLowerBound(glb, subset[i]);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return glb;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object greatestElement(Object[] subset) {
            Class<TypeLattice> clazz = TypeLattice.class;
            synchronized (TypeLattice.class) {
                for (int i = 0; i < subset.length; ++i) {
                    boolean isGreatest = true;
                    for (int j = 0; j < subset.length; ++j) {
                        int result = this.compare(subset[i], subset[j]);
                        if (result != -1 && result != 2) continue;
                        isGreatest = false;
                        break;
                    }
                    if (!isGreatest) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return subset[i];
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }

        @Override
        public boolean isLattice() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object leastElement(Object[] subset) {
            Class<TypeLattice> clazz = TypeLattice.class;
            synchronized (TypeLattice.class) {
                for (int i = 0; i < subset.length; ++i) {
                    boolean isLeast = true;
                    for (int j = 0; j < subset.length; ++j) {
                        int result = this.compare(subset[i], subset[j]);
                        if (result != 1 && result != 2) continue;
                        isLeast = false;
                        break;
                    }
                    if (!isLeast) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return subset[i];
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object leastUpperBound(Object t1, Object t2) {
            Class<TypeLattice> clazz = TypeLattice.class;
            synchronized (TypeLattice.class) {
                Type t2Rep;
                if (!(t1 instanceof Type) || !(t2 instanceof Type)) {
                    throw new IllegalArgumentException("TheTypeLattice.leastUpperBound: Arguments are not instances of Type.");
                }
                Type ct1 = (Type)t1;
                Type ct2 = (Type)t2;
                Type t1Rep = this._toRepresentative(ct1);
                if (((Object)t1Rep).equals(t2Rep = this._toRepresentative(ct2)) && t1Rep instanceof StructuredType) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return ((StructuredType)t1)._leastUpperBound((StructuredType)t2);
                }
                if (!(!(t1Rep instanceof ArrayType) || t2Rep instanceof ArrayType || t2.equals(BaseType.UNKNOWN) || t2.equals(BaseType.GENERAL) || t2.equals(BaseType.ARRAY_BOTTOM))) {
                    ArrayType arrayType = (ArrayType)t1;
                    Type elementType = ((ArrayType)ct1).getElementType();
                    int elementComparison = this.compare(elementType, t2Rep);
                    if (elementComparison == 0 || elementComparison == 1) {
                        if (arrayType.hasKnownLength() && arrayType.length() != 1) {
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return new ArrayType(elementType);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t1;
                    }
                    if (t2Rep == BaseType.GENERAL) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t2;
                    }
                    if (this._basicLattice.containsNodeWeight(t2Rep) && this._basicLattice.containsNodeWeight(elementType)) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return new ArrayType((Type)this._basicLattice.leastUpperBound(elementType, t2Rep));
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return BaseType.GENERAL;
                }
                if (!(!(t2Rep instanceof ArrayType) || t1Rep instanceof ArrayType || t1.equals(BaseType.UNKNOWN) || t1.equals(BaseType.GENERAL) || t1.equals(BaseType.ARRAY_BOTTOM))) {
                    ArrayType arrayType = (ArrayType)t2;
                    Type elementType = ((ArrayType)ct2).getElementType();
                    int elementComparison = this.compare(elementType, t1Rep);
                    if (elementComparison == 0 || elementComparison == 1) {
                        if (arrayType.hasKnownLength() && arrayType.length() != 1) {
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return new ArrayType(elementType);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t2;
                    }
                    if (t1Rep == BaseType.GENERAL) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t1;
                    }
                    if (this._basicLattice.containsNodeWeight(t1Rep) && this._basicLattice.containsNodeWeight(elementType)) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return new ArrayType((Type)this._basicLattice.leastUpperBound(elementType, t1Rep));
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return BaseType.GENERAL;
                }
                if (this._basicLattice.containsNodeWeight(t1Rep) && this._basicLattice.containsNodeWeight(t2Rep)) {
                    int relation = this._basicLattice.compare(t1Rep, t2Rep);
                    if (relation == 0) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t1;
                    }
                    if (relation == -1) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t2;
                    }
                    if (relation == 1) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return t1;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return this._basicLattice.leastUpperBound(t1Rep, t2Rep);
                }
                if (((Object)t1Rep).equals(t2Rep)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return t1;
                }
                if (t1Rep == BaseType.UNKNOWN || t2Rep == BaseType.GENERAL) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return t2;
                }
                if (t2Rep == BaseType.UNKNOWN || t1Rep == BaseType.GENERAL) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return t1;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.top();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object leastUpperBound(Object[] subset) {
            Class<TypeLattice> clazz = TypeLattice.class;
            synchronized (TypeLattice.class) {
                if (subset.length == 0) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return BaseType.UNKNOWN;
                }
                Object lub = subset[0];
                for (int i = 0; i < subset.length; ++i) {
                    lub = this.leastUpperBound(lub, subset[i]);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return lub;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object top() {
            Class<TypeLattice> clazz = TypeLattice.class;
            synchronized (TypeLattice.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this._basicLattice.top();
            }
        }

        @Override
        public Object[] upSet(Object e) {
            throw new UnsupportedOperationException("TheTypeLattice.upSet(): operation not supported for the type lattice.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TheTypeLattice() {
            Class<TypeLattice> clazz = TypeLattice.class;
            synchronized (TypeLattice.class) {
                this._basicLattice = new DirectedAcyclicGraph();
                StructuredType arrayRep = new ArrayType(BaseType.UNKNOWN)._getRepresentative();
                String[] labels = new String[]{};
                Type[] types = new Type[]{};
                StructuredType recordRep = new RecordType(labels, types)._getRepresentative();
                StructuredType unionRep = new UnionType(labels, types)._getRepresentative();
                new FunctionType(new Type[0], BaseType.UNKNOWN)._getRepresentative();
                this._basicLattice.addNodeWeight(BaseType.BOOLEAN);
                this._basicLattice.addNodeWeight(BaseType.BOOLEAN_MATRIX);
                this._basicLattice.addNodeWeight(BaseType.UNSIGNED_BYTE);
                this._basicLattice.addNodeWeight(BaseType.COMPLEX);
                this._basicLattice.addNodeWeight(BaseType.COMPLEX_MATRIX);
                this._basicLattice.addNodeWeight(BaseType.DOUBLE);
                this._basicLattice.addNodeWeight(BaseType.DOUBLE_MATRIX);
                this._basicLattice.addNodeWeight(BaseType.UNSIZED_FIX);
                this._basicLattice.addNodeWeight(BaseType.SIZED_FIX);
                this._basicLattice.addNodeWeight(BaseType.FIX_MATRIX);
                this._basicLattice.addNodeWeight(BaseType.FLOAT);
                this._basicLattice.addNodeWeight(BaseType.INT);
                this._basicLattice.addNodeWeight(BaseType.INT_MATRIX);
                this._basicLattice.addNodeWeight(BaseType.LONG);
                this._basicLattice.addNodeWeight(BaseType.LONG_MATRIX);
                this._basicLattice.addNodeWeight(BaseType.MATRIX);
                this._basicLattice.addNodeWeight(BaseType.UNKNOWN);
                this._basicLattice.addNodeWeight(BaseType.OBJECT);
                this._basicLattice.addNodeWeight(BaseType.XMLTOKEN);
                this._basicLattice.addNodeWeight(BaseType.SCALAR);
                this._basicLattice.addNodeWeight(BaseType.SHORT);
                this._basicLattice.addNodeWeight(BaseType.STRING);
                this._basicLattice.addNodeWeight(BaseType.EVENT);
                this._basicLattice.addNodeWeight(BaseType.GENERAL);
                this._basicLattice.addNodeWeight(BaseType.PETITE);
                this._basicLattice.addNodeWeight(BaseType.NIL);
                this._basicLattice.addNodeWeight(arrayRep);
                this._basicLattice.addNodeWeight(BaseType.ARRAY_BOTTOM);
                this._basicLattice.addNodeWeight(recordRep);
                this._basicLattice.addNodeWeight(unionRep);
                this._basicLattice.addEdge(BaseType.XMLTOKEN, BaseType.GENERAL);
                this._basicLattice.addEdge(BaseType.UNKNOWN, BaseType.XMLTOKEN);
                this._basicLattice.addEdge(BaseType.OBJECT, BaseType.GENERAL);
                this._basicLattice.addEdge(BaseType.UNKNOWN, BaseType.OBJECT);
                this._basicLattice.addEdge(BaseType.STRING, BaseType.GENERAL);
                this._basicLattice.addEdge(BaseType.MATRIX, BaseType.STRING);
                this._basicLattice.addEdge(BaseType.BOOLEAN_MATRIX, BaseType.MATRIX);
                this._basicLattice.addEdge(BaseType.BOOLEAN, BaseType.BOOLEAN_MATRIX);
                this._basicLattice.addEdge(BaseType.BOOLEAN, BaseType.SCALAR);
                this._basicLattice.addEdge(BaseType.UNKNOWN, BaseType.BOOLEAN);
                this._basicLattice.addEdge(BaseType.FIX_MATRIX, BaseType.MATRIX);
                this._basicLattice.addEdge(BaseType.SCALAR, BaseType.MATRIX);
                this._basicLattice.addEdge(BaseType.LONG_MATRIX, BaseType.MATRIX);
                this._basicLattice.addEdge(BaseType.COMPLEX_MATRIX, BaseType.MATRIX);
                this._basicLattice.addEdge(BaseType.UNSIZED_FIX, BaseType.FIX_MATRIX);
                this._basicLattice.addEdge(BaseType.SIZED_FIX, BaseType.UNSIZED_FIX);
                this._basicLattice.addEdge(BaseType.UNSIZED_FIX, BaseType.SCALAR);
                this._basicLattice.addEdge(BaseType.UNKNOWN, BaseType.SIZED_FIX);
                this._basicLattice.addEdge(BaseType.LONG, BaseType.SCALAR);
                this._basicLattice.addEdge(BaseType.LONG, BaseType.LONG_MATRIX);
                this._basicLattice.addEdge(BaseType.INT_MATRIX, BaseType.LONG_MATRIX);
                this._basicLattice.addEdge(BaseType.INT, BaseType.LONG);
                this._basicLattice.addEdge(BaseType.INT, BaseType.INT_MATRIX);
                this._basicLattice.addEdge(BaseType.UNKNOWN, BaseType.UNSIGNED_BYTE);
                this._basicLattice.addEdge(BaseType.UNKNOWN, BaseType.PETITE);
                this._basicLattice.addEdge(BaseType.INT_MATRIX, BaseType.DOUBLE_MATRIX);
                this._basicLattice.addEdge(BaseType.DOUBLE_MATRIX, BaseType.COMPLEX_MATRIX);
                this._basicLattice.addEdge(BaseType.DOUBLE, BaseType.DOUBLE_MATRIX);
                this._basicLattice.addEdge(BaseType.INT, BaseType.DOUBLE);
                this._basicLattice.addEdge(BaseType.DOUBLE, BaseType.SCALAR);
                this._basicLattice.addEdge(BaseType.PETITE, BaseType.DOUBLE);
                this._basicLattice.addEdge(BaseType.COMPLEX, BaseType.SCALAR);
                this._basicLattice.addEdge(BaseType.COMPLEX, BaseType.COMPLEX_MATRIX);
                this._basicLattice.addEdge(BaseType.DOUBLE, BaseType.COMPLEX);
                this._basicLattice.addEdge(BaseType.UNSIGNED_BYTE, BaseType.SHORT);
                this._basicLattice.addEdge(BaseType.SHORT, BaseType.INT);
                this._basicLattice.addEdge(BaseType.SHORT, BaseType.FLOAT);
                this._basicLattice.addEdge(BaseType.FLOAT, BaseType.DOUBLE);
                this._basicLattice.addEdge(BaseType.EVENT, BaseType.GENERAL);
                this._basicLattice.addEdge(BaseType.UNKNOWN, BaseType.EVENT);
                this._basicLattice.addEdge(arrayRep, BaseType.STRING);
                this._basicLattice.addEdge(BaseType.ARRAY_BOTTOM, arrayRep);
                this._basicLattice.addEdge(BaseType.UNKNOWN, BaseType.ARRAY_BOTTOM);
                this._basicLattice.addEdge(recordRep, BaseType.STRING);
                this._basicLattice.addEdge(BaseType.UNKNOWN, recordRep);
                this._basicLattice.addEdge(unionRep, BaseType.GENERAL);
                this._basicLattice.addEdge(BaseType.UNKNOWN, unionRep);
                this._basicLattice.addEdge(BaseType.UNKNOWN, BaseType.NIL);
                this._basicLattice.addEdge(BaseType.NIL, BaseType.BOOLEAN);
                this._basicLattice.addEdge(BaseType.NIL, BaseType.UNSIGNED_BYTE);
                if (!this._basicLattice.isLattice()) {
                    throw new InternalErrorException("TheTypeLattice: The type hierarchy is not a lattice.");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private Type _toRepresentative(Type t) {
            if (t instanceof StructuredType) {
                return ((StructuredType)t)._getRepresentative();
            }
            return t;
        }
    }
}

