/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import java.util.List;
import ptolemy.actor.IOPort;
import ptolemy.data.unit.EquationVisitor;
import ptolemy.data.unit.UnitEquation;
import ptolemy.data.unit.UnitTerm;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.util.IllegalActionException;

public class ExpandPortNames
extends EquationVisitor {
    List _actorPorts;

    public void expand(UnitEquation equation, ComponentEntity actor) throws IllegalActionException {
        this._actorPorts = actor.portList();
        equation.visit(this);
    }

    @Override
    protected Object _visitUnitTerm(UnitTerm uTerm) throws IllegalActionException {
        if (uTerm.isVariable()) {
            String portName = uTerm.getVariable();
            if (portName == null) {
                throw new IllegalActionException(uTerm + " is not a variable");
            }
            for (IOPort actorPort : this._actorPorts) {
                if (!actorPort.getName().equals(portName)) continue;
                uTerm.setVariable(actorPort.getName(actorPort.getContainer().getContainer()));
                return null;
            }
            throw new IllegalActionException("Can't find Model port " + portName);
        }
        return null;
    }
}

