/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import java.text.DecimalFormat;
import java.util.Vector;
import ptolemy.actor.IOPort;
import ptolemy.actor.IORelation;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.unit.Unit;
import ptolemy.data.unit.UnitEquation;
import ptolemy.data.unit.UnitLibrary;
import ptolemy.data.unit.UnitTerm;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.moml.MoMLChangeRequest;

public class Solution {
    private static final int _UNKNOWN = -1;
    private static final int _CONSISTENT = 0;
    private static final int _INCONSISTENT = 1;
    private static final int _NONUNIQUE = 2;
    double[][] _arrayP;
    Index _branchPoint = null;
    Vector _branchPoints = null;
    Vector _constraints = null;
    String[] _constraintExplanations = null;
    int[] _constraintState = null;
    boolean _debug = false;
    boolean[] _done;
    TypedCompositeActor _model;
    int _numConstraints = 0;
    int _numVariables = 0;
    private static final DecimalFormat _pFormat = new DecimalFormat(" 0;-0");
    private int _solveState = -1;
    NamedObj[] _source;
    String _stateDescription = "No description";
    Solution _upper = null;
    String[] _varBindings = null;
    String[] _variables;
    int[] _varState = null;
    Unit[] _vectorA;
    private static final DecimalFormat _vNumFormat = new DecimalFormat("00");

    private Solution() {
    }

    public Solution(TypedCompositeActor model, String[] vLabels, Vector constraints) throws IllegalActionException {
        this._constraints = constraints;
        this._numConstraints = constraints.size();
        this._variables = vLabels;
        this._model = model;
        this._numVariables = this._variables.length;
        this._vectorA = new Unit[this._numConstraints];
        this._source = new NamedObj[this._numConstraints];
        this._done = new boolean[this._numConstraints];
        this._arrayP = new double[this._numConstraints][];
        for (int i = 0; i < this._numConstraints; ++i) {
            this._arrayP[i] = new double[this._numVariables];
            this._done[i] = false;
        }
        for (int constraintNum = 0; constraintNum < this._numConstraints; ++constraintNum) {
            UnitEquation constraint = (UnitEquation)constraints.elementAt(constraintNum);
            UnitEquation canonicalEquation = constraint.canonicalize();
            Vector rightUTerms = canonicalEquation.getRhs().getUTerms();
            if (rightUTerms.size() != 1) {
                throw new IllegalActionException("canonicalEquation " + canonicalEquation + " has nonsingular RHS");
            }
            UnitTerm rhsUterm = (UnitTerm)rightUTerms.elementAt(0);
            if (!rhsUterm.isUnit()) {
                throw new IllegalActionException("canonicalEquation " + canonicalEquation + " has nonUnit RHS");
            }
            this._vectorA[constraintNum] = rhsUterm.getUnit();
            this._source[constraintNum] = constraint.getSource();
            Vector leftUTerms = canonicalEquation.getLhs().getUTerms();
            for (int i = 0; i < leftUTerms.size(); ++i) {
                UnitTerm leftUTerm = (UnitTerm)leftUTerms.elementAt(i);
                if (leftUTerm == null) {
                    throw new IllegalActionException("canonicalEquation " + canonicalEquation + " has nonVar LHS");
                }
                String variableLabel = leftUTerm.getVariable();
                double exponent = leftUTerm.getExponent();
                int varIndex = -1;
                for (int j = 0; j < this._variables.length; ++j) {
                    if (!this._variables[j].equals(variableLabel)) continue;
                    varIndex = j;
                    break;
                }
                this._arrayP[constraintNum][varIndex] = exponent;
            }
        }
    }

    public void annotateGraph() {
        String color;
        if (this._debug) {
            this.trace();
        }
        StringBuffer moml = new StringBuffer();
        for (int j = 0; j < this._numVariables; ++j) {
            String explanation = this._varBindings[j];
            color = null;
            if (this._varState[j] == 0) {
                color = "green";
            } else if (this._varState[j] == 1) {
                color = "red";
            }
            moml.append("<port name=\"" + this._variables[j] + "\">" + " <property name=\"_color\" " + "class = \"ptolemy.kernel.util.StringAttribute\" " + "value = \"" + color + "\"/>" + "<property name=\"_explanation\" " + "class = \"ptolemy.kernel.util.StringAttribute\" " + "value = \"" + explanation + "\"/>" + "</port>");
        }
        for (int constraintNum = 0; constraintNum < this._numConstraints; ++constraintNum) {
            NamedObj source = this._source[constraintNum];
            String expression = this._constraintExplanations[constraintNum];
            color = null;
            if (this._constraintState[constraintNum] == 0) {
                color = "green";
            } else if (this._constraintState[constraintNum] == 1) {
                color = "red";
            }
            if (source instanceof IOPort) {
                IOPort port = (IOPort)source;
                ComponentEntity actor = (ComponentEntity)port.getContainer();
                moml.append("<entity name=\"" + actor.getName() + "\">" + this._momlAnnotate(port, color, expression) + "</entity>");
                continue;
            }
            if (source instanceof IORelation) {
                IORelation relation = (IORelation)source;
                moml.append(this._momlAnnotate(relation, color, expression));
                continue;
            }
            if (!(source instanceof ComponentEntity)) continue;
            ComponentEntity componentEntity = (ComponentEntity)source;
            moml.append(this._momlAnnotate(componentEntity, color, expression));
        }
        if (moml.length() > 0) {
            String momlUpdate = "<group>" + moml.toString() + "</group>";
            MoMLChangeRequest request = new MoMLChangeRequest(this, this._model, momlUpdate);
            request.setUndoable(true);
            request.setPersistent(false);
            this._debug("Solver.annotateGraph moml " + momlUpdate);
            this._model.requestChange(request);
        }
    }

    public Solution completeSolution() {
        Index g;
        this._debug("Solver.completeSolution.initial " + this.headerInfo() + this.stateInfo());
        while ((g = this._findG()) != null) {
            this._eliminate(g);
            this._debug("Solver.completeSolution " + this.stateInfo());
        }
        for (int i = 0; i < this._numConstraints; ++i) {
            this._done[i] = true;
        }
        this._analyzeState();
        if (this._debug) {
            this.trace();
        }
        return this;
    }

    public Solution copy() {
        Solution retv = new Solution();
        retv._numConstraints = this._numConstraints;
        retv._variables = this._variables;
        retv._model = this._model;
        retv._numVariables = this._numVariables;
        retv._source = this._source;
        retv._debug = this._debug;
        retv._constraints = this._constraints;
        retv._vectorA = new Unit[this._numConstraints];
        retv._done = new boolean[this._numConstraints];
        retv._arrayP = new double[this._numConstraints][];
        for (int i = 0; i < this._numConstraints; ++i) {
            retv._arrayP[i] = new double[this._numVariables];
            for (int j = 0; j < this._numVariables; ++j) {
                retv._arrayP[i][j] = this._arrayP[i][j];
            }
            retv._done[i] = this._done[i];
            retv._vectorA[i] = this._vectorA[i].copy();
        }
        retv._upper = this;
        return retv;
    }

    public String getShortStateDesc() {
        switch (this._solveState) {
            case -1: {
                return "UnKnown";
            }
            case 2: {
                return "No Unique Solution";
            }
            case 1: {
                return "Inconsistent";
            }
            case 0: {
                return "Consistent";
            }
        }
        return "Unknown";
    }

    public String getStateDesc() {
        return this._stateDescription;
    }

    public StringBuffer headerInfo() {
        StringBuffer retv = new StringBuffer();
        retv.append("Header\nVariables\n");
        for (int j = 0; j < this._numVariables; ++j) {
            retv.append("   " + _vNumFormat.format(j) + " " + this._variables[j] + "\n");
        }
        retv.append("\n");
        retv.append("ConstrNum  Source\n");
        for (int i = 0; i < this._numConstraints; ++i) {
            NamedObj source = this._source[i];
            retv.append("" + _vNumFormat.format(i) + "         " + source.toString() + " " + ((UnitEquation)this._constraints.elementAt(i)).descriptiveForm() + "\n");
        }
        retv.append("\\Header\n");
        return retv;
    }

    public Vector minimalSpanSolutions() {
        Vector<Solution> solutions = new Vector<Solution>();
        this._debug("Solver.minimalSpanSolutions " + this.headerInfo() + " initial\n" + this.stateInfo());
        Solution root = this.copy();
        for (Index g : root._findAllG()) {
            root._eliminate(g);
        }
        root._checkForInConsistency();
        if (root._solveState == 1) {
            root._analyzeState();
            solutions.add(root);
        } else {
            root._branchPoint = null;
            this._debug("Solver.solve root\n" + root.stateInfo());
            root._branchPoints = root._findAllG();
            if (root._branchPoints.size() > 0) {
                for (int i = 0; i < root._branchPoints.size(); ++i) {
                    Solution s = root.copy();
                    Vector results = s._partialSolveRecursively(1, (Index)root._branchPoints.elementAt(i));
                    solutions.addAll(results);
                }
            } else {
                root._analyzeState();
                solutions.add(root);
            }
        }
        if (this._debug) {
            for (int i = 0; i < solutions.size(); ++i) {
                Solution solution = (Solution)solutions.elementAt(i);
                System.out.println("A Solution\n" + solution.stateInfo());
            }
        }
        return solutions;
    }

    public StringBuffer stateInfo() {
        StringBuffer retv = new StringBuffer();
        retv.append("State\n");
        retv.append("BranchPoints " + this._branchPoints + "\n    ");
        for (int j = 0; j < this._numVariables; ++j) {
            retv.append(" " + _vNumFormat.format(j));
        }
        retv.append("\n");
        for (int i = 0; i < this._numConstraints; ++i) {
            if (this._done[i]) {
                retv.append("T ");
            } else {
                retv.append("F ");
            }
            retv.append("" + _vNumFormat.format(i) + " ");
            for (int j = 0; j < this._numVariables; ++j) {
                retv.append("" + _pFormat.format(this._arrayP[i][j]) + " ");
            }
            retv.append("" + this._vectorA[i] + " " + this._vectorA[i].descriptiveForm());
            retv.append(" " + ((UnitEquation)this._constraints.elementAt(i)).descriptiveForm());
            retv.append("\n");
        }
        if (this._branchPoint == null) {
            retv.append("BranchPoint = null\n");
        } else {
            retv.append("BranchPoint = " + this._branchPoint.toString() + "\n");
        }
        retv.append("Solution: " + this.getStateDesc());
        retv.append("\n\\State\n");
        return retv;
    }

    public void trace() {
        System.out.print("Solver.trace\n");
        Solution s = this;
        while (s != null) {
            System.out.print(s.stateInfo());
            s = s._upper;
        }
        System.out.print(this.headerInfo());
    }

    private void _analyzeState() {
        int numNonZeroP;
        this._varBindings = new String[this._numVariables];
        this._constraintExplanations = new String[this._numConstraints];
        this._varState = new int[this._numVariables];
        this._constraintState = new int[this._numConstraints];
        String inconsistencyDesc = "";
        for (int i = 0; i < this._numConstraints; ++i) {
            this._constraintState[i] = -1;
            this._constraintExplanations[i] = "";
            if (!this._done[i]) continue;
            numNonZeroP = 0;
            for (int j = 0; j < this._numVariables; ++j) {
                if (this._arrayP[i][j] == 0.0) continue;
                ++numNonZeroP;
            }
            if (numNonZeroP == 0 && !this._vectorA[i].equals(UnitLibrary.Identity)) {
                Unit factor = this._vectorA[i].invert();
                String uString = factor.descriptiveForm();
                this._constraintState[i] = 1;
                this._constraintExplanations[i] = uString;
                continue;
            }
            if (numNonZeroP > 1 && this._vectorA[i].equals(UnitLibrary.Identity)) {
                this._constraintState[i] = 2;
                continue;
            }
            String uString = this._vectorA[i].descriptiveForm();
            this._constraintState[i] = 0;
            this._constraintExplanations[i] = uString;
        }
        for (int j = 0; j < this._numVariables; ++j) {
            this._varBindings[j] = "";
            numNonZeroP = 0;
            for (int i = 0; i < this._numConstraints; ++i) {
                if (!this._done[i] || this._arrayP[i][j] == 0.0) continue;
                Unit U = this._vectorA[i].pow(1.0 / this._arrayP[i][j]);
                if (numNonZeroP > 0) {
                    int n = j;
                    this._varBindings[n] = this._varBindings[n] + ";";
                }
                int n = j;
                this._varBindings[n] = this._varBindings[n] + U.descriptiveForm();
                ++numNonZeroP;
            }
            if (numNonZeroP > 1) {
                this._varBindings[j] = "*AMBIGUOUS* " + this._varBindings[j];
                this._varState[j] = 1;
            }
            if (numNonZeroP == 1) {
                this._varState[j] = 0;
                continue;
            }
            this._varBindings[j] = "<Unbound>";
            this._varState[j] = 2;
        }
        boolean stateInconsistent = false;
        boolean stateNonUnique = false;
        this._solveState = 0;
        block14: for (int i = 0; i < this._numConstraints; ++i) {
            switch (this._constraintState[i]) {
                case 1: {
                    stateInconsistent = true;
                    NamedObj source = this._source[i];
                    String sourceName = "NoSource";
                    if (source instanceof IORelation) {
                        sourceName = ((IORelation)source).getName();
                    } else if (source instanceof ComponentEntity) {
                        sourceName = ((ComponentEntity)source).getName();
                    } else if (source instanceof TypedIOPort) {
                        sourceName = source.getName(source.getContainer().getContainer());
                    }
                    inconsistencyDesc = inconsistencyDesc + " " + sourceName + " " + this._constraintExplanations[i];
                    continue block14;
                }
                case 2: {
                    stateNonUnique = true;
                }
            }
        }
        if (stateInconsistent && stateNonUnique) {
            this._debug("State is both Inconsistent and NonUnique");
        }
        for (int j = 0; j < this._numVariables; ++j) {
            if (this._varState[j] != 1) continue;
            stateInconsistent = true;
            inconsistencyDesc = inconsistencyDesc + " " + this._variables[j] + "=" + this._varBindings[j];
        }
        this._solveState = stateInconsistent ? 1 : (stateNonUnique ? 2 : 0);
        switch (this._solveState) {
            case -1: {
                this._stateDescription = "UnKnown";
                break;
            }
            case 2: {
                this._stateDescription = "No Unique Solution";
                break;
            }
            case 1: {
                this._stateDescription = "Inconsistent" + inconsistencyDesc;
                break;
            }
            case 0: {
                this._stateDescription = "Consistent";
            }
        }
    }

    private int[] _branchesFrom(Index g) {
        int k = g.getK();
        int l = g.getL();
        int num = 0;
        for (int i = 0; i < this._numConstraints; ++i) {
            if (i == k || this._arrayP[i][l] == 0.0) continue;
            ++num;
        }
        int[] retv = new int[num];
        int index = 0;
        for (int i = 0; i < this._numConstraints; ++i) {
            if (i == k || this._arrayP[i][l] == 0.0) continue;
            retv[index++] = i;
        }
        return retv;
    }

    private void _checkForInConsistency() {
        for (int i = 0; i < this._numConstraints; ++i) {
            if (this._vectorA[i].equals(UnitLibrary.Identity)) continue;
            boolean inconsistent = true;
            for (int j = 0; j < this._numVariables; ++j) {
                if (this._arrayP[i][j] == 0.0) continue;
                inconsistent = false;
            }
            if (!inconsistent) continue;
            this._done[i] = true;
            this._solveState = 1;
        }
    }

    private void _debug(String msg) {
        if (this._debug) {
            System.out.println(msg);
        }
    }

    private void _eliminate(Index g) {
        Unit U;
        int k = g.getK();
        int l = g.getL();
        this._debug("Eliminating (" + k + ", " + l + ")");
        this._vectorA[k] = U = this._vectorA[k].pow(1.0 / this._arrayP[k][l]);
        this._arrayP[k][l] = 1.0;
        for (int i = 0; i < this._numConstraints; ++i) {
            if (i == k || this._done[i] || this._arrayP[i][l] == 0.0) continue;
            this._vectorA[i] = this._vectorA[i].divideBy(U.pow(this._arrayP[i][l]));
            this._arrayP[i][l] = 0.0;
        }
        this._branchPoint = g;
        this._done[k] = true;
    }

    private Vector _findAllG() {
        Vector<Index> retv = new Vector<Index>();
        for (int i = 0; i < this._numConstraints; ++i) {
            if (this._done[i]) continue;
            int l = -1;
            boolean possible = false;
            for (int j = 0; j < this._numVariables; ++j) {
                if (this._arrayP[i][j] == 0.0) continue;
                if (l == -1) {
                    possible = true;
                    l = j;
                    continue;
                }
                possible = false;
                break;
            }
            if (!possible) continue;
            retv.add(new Index(i, l));
        }
        return retv;
    }

    private Vector _findAllGInRows(int[] rows) {
        Vector<Index> retv = new Vector<Index>();
        for (int a = 0; a < rows.length; ++a) {
            int k = rows[a];
            Index g = this._findGInRow(k);
            if (g == null) continue;
            retv.add(g);
        }
        return retv;
    }

    private Index _findG() {
        for (int i = 0; i < this._numConstraints; ++i) {
            if (this._done[i]) continue;
            int l = -1;
            boolean possible = false;
            for (int j = 0; j < this._numVariables; ++j) {
                if (this._arrayP[i][j] == 0.0) continue;
                if (l == -1) {
                    possible = true;
                    l = j;
                    continue;
                }
                possible = false;
                break;
            }
            if (!possible) continue;
            return new Index(i, l);
        }
        return null;
    }

    private Index _findGInRow(int k) {
        int l = -1;
        for (int j = 0; j < this._numVariables; ++j) {
            if (this._arrayP[k][j] == 0.0) continue;
            if (l == -1) {
                l = j;
                continue;
            }
            return null;
        }
        if (l == -1) {
            return null;
        }
        return new Index(k, l);
    }

    private String _momlAnnotate(NamedObj entity, String color, String expression) {
        String colorProperty = null;
        StringAttribute currentColor = (StringAttribute)entity.getAttribute("_color");
        if (currentColor != null && color == null) {
            colorProperty = "<deleteProperty _name=_color/>";
        } else if (color != null) {
            colorProperty = "<property name=\"_color\" class = \"ptolemy.kernel.util.StringAttribute\" value = \"" + color + "\"/>";
        }
        return "<" + entity.getElementName() + " name=\"" + entity.getName() + "\" class=\"" + entity.getClassName() + "\">" + colorProperty + "<property name=\"_explanation\" " + "class = \"ptolemy.kernel.util.StringAttribute\" " + "value = \"" + expression + "\"/></" + entity.getElementName() + ">";
    }

    private Vector _partialSolveRecursively(int level, Index g) {
        Vector<Solution> retv = new Vector<Solution>();
        this._debug("\nSolver._eliminateRecursively level " + level + " BrancPoint " + g + "\n" + this.stateInfo());
        int[] rows = this._branchesFrom(g);
        this._eliminate(g);
        this._checkForInConsistency();
        this._branchPoints = this._findAllGInRows(rows);
        if (this._solveState != 1 && this._branchPoints.size() > 0) {
            if (this._debug) {
                int a;
                System.out.print("Branch Rows at level " + level + " for " + g);
                for (a = 0; a < rows.length; ++a) {
                    System.out.print(" " + rows[a]);
                }
                System.out.print("\nRemaining BranchPoints");
                for (a = 0; a < this._branchPoints.size(); ++a) {
                    System.out.print(" " + this._branchPoints.elementAt(a));
                }
                System.out.print("\n");
            }
            for (int gi = 0; gi < this._branchPoints.size(); ++gi) {
                Solution s = this.copy();
                Vector results = s._partialSolveRecursively(level + 1, (Index)this._branchPoints.elementAt(gi));
                if (results == null) continue;
                retv.addAll(results);
            }
        } else {
            this._analyzeState();
            if (this._debug) {
                this.trace();
            }
            retv.add(this);
        }
        return retv;
    }

    private static class Index {
        int k;
        int l;

        private Index(int k1, int l1) {
            this.k = k1;
            this.l = l1;
        }

        public int getK() {
            return this.k;
        }

        public int getL() {
            return this.l;
        }

        public String toString() {
            return "(" + this.k + "," + this.l + ")";
        }
    }
}

