/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.Receiver;
import ptolemy.actor.TimedDirector;
import ptolemy.actor.sched.StaticSchedulingDirector;
import ptolemy.actor.util.GeneralComparator;
import ptolemy.actor.util.Time;
import ptolemy.actor.util.TotallyOrderedSet;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.ct.kernel.CTCompositeActor;
import ptolemy.domains.ct.kernel.CTDynamicActor;
import ptolemy.domains.ct.kernel.CTExecutionPhase;
import ptolemy.domains.ct.kernel.CTGeneralDirector;
import ptolemy.domains.ct.kernel.CTReceiver;
import ptolemy.domains.ct.kernel.CTSchedule;
import ptolemy.domains.ct.kernel.CTScheduler;
import ptolemy.domains.ct.kernel.ODESolver;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public abstract class CTDirector
extends StaticSchedulingDirector
implements TimedDirector,
CTGeneralDirector {
    public Parameter errorTolerance;
    public Parameter initStepSize;
    public Parameter maxIterations;
    public Parameter maxStepSize;
    public Parameter minStepSize;
    public Parameter startTime;
    public Parameter stopTime;
    public Parameter synchronizeToRealTime;
    public Parameter valueResolution;
    protected long _timeBase;
    private TotallyOrderedSet _breakpoints;
    private ODESolver _currentSolver = null;
    private double _currentStepSize;
    private boolean _discretePhase;
    private double _errorTolerance;
    private CTExecutionPhase _executionPhase;
    private double _initStepSize;
    private Time _iterationBeginTime;
    private int _maxIterations;
    private double _maxStepSize;
    private double _minStepSize;
    private Set _prefiredActors = new HashSet();
    private Time _startTime;
    private double _startTimeValue;
    private Time _stopTime;
    private double _stopTimeValue;
    private double _suggestedNextStepSize;
    private double _valueResolution;

    public CTDirector() {
        this((Workspace)null);
    }

    public CTDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._initParameters();
        try {
            this.setScheduler(new CTScheduler(container.workspace()));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(this.getFullName() + "Error setting a CTScheduler.");
        }
        catch (NameDuplicationException ex) {
            throw new InternalErrorException("There is already a scheduler with name " + this.getFullName());
        }
    }

    public CTDirector(Workspace workspace) {
        super(workspace);
        this._initParameters();
        try {
            this.setScheduler(new CTScheduler(workspace));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(this.getFullName() + "Error setting a CTScheduler.");
        }
        catch (NameDuplicationException ex) {
            throw new InternalErrorException("There is already a scheduler with name " + this.getFullName());
        }
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (this._debugging) {
            this._debug("Updating CTDirector parameter: ", attribute.getName());
        }
        if (attribute == this.startTime) {
            double startTimeValue;
            this._startTimeValue = startTimeValue = ((DoubleToken)this.startTime.getToken()).doubleValue();
        } else if (attribute == this.stopTime) {
            double stopTimeValue;
            this._stopTimeValue = stopTimeValue = ((DoubleToken)this.stopTime.getToken()).doubleValue();
        } else if (attribute == this.initStepSize) {
            double value = ((DoubleToken)this.initStepSize.getToken()).doubleValue();
            if (value < 0.0) {
                throw new IllegalActionException((Nameable)this, "Cannot set a negative step size.");
            }
            this._initStepSize = value;
        } else if (attribute == this.errorTolerance) {
            double value = ((DoubleToken)this.errorTolerance.getToken()).doubleValue();
            if (value < 0.0) {
                throw new IllegalActionException((Nameable)this, "Cannot set a negative error tolerance.");
            }
            this._errorTolerance = value;
        } else if (attribute == this.minStepSize) {
            double value = ((DoubleToken)this.minStepSize.getToken()).doubleValue();
            if (value < 0.0) {
                throw new IllegalActionException((Nameable)this, "Cannot set a negative step size.");
            }
            this._minStepSize = value;
        } else if (attribute == this.maxStepSize) {
            double value = ((DoubleToken)this.maxStepSize.getToken()).doubleValue();
            if (value < 0.0) {
                throw new IllegalActionException((Nameable)this, "Cannot set a negative step size.");
            }
            this._maxStepSize = value;
        } else if (attribute == this.valueResolution) {
            double value = ((DoubleToken)this.valueResolution.getToken()).doubleValue();
            if (value < 0.0) {
                throw new IllegalActionException((Nameable)this, "Cannot set a negative value resolution.");
            }
            this._valueResolution = value;
        } else if (attribute == this.maxIterations) {
            int value = ((IntToken)this.maxIterations.getToken()).intValue();
            if (value < 1) {
                throw new IllegalActionException((Nameable)this, "Cannot set a zero or negative iteration number.");
            }
            this._maxIterations = value;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public abstract boolean canBeInsideDirector();

    public abstract boolean canBeTopLevelDirector();

    @Override
    public abstract void fire() throws IllegalActionException;

    @Override
    public void fireAt(Actor actor, Time time) throws IllegalActionException {
        Time currentTime = this.getModelTime();
        if (time.compareTo(currentTime) < 0) {
            throw new IllegalActionException((Nameable)actor, "Requested fire time: " + time + " is earlier than" + " the current time." + currentTime);
        }
        if (this._breakpoints == null) {
            throw new IllegalActionException("Breakpoint table can not be null!");
        }
        if (this._debugging) {
            String name = actor.getName();
            this._debug("----> " + name + " requests refiring at " + time);
        }
        this._breakpoints.insert(time);
    }

    public final TotallyOrderedSet getBreakPoints() {
        return this._breakpoints;
    }

    public final ODESolver getCurrentODESolver() {
        return this._currentSolver;
    }

    @Override
    public double getCurrentStepSize() {
        return this._currentStepSize;
    }

    @Override
    public double getErrorTolerance() {
        return this._errorTolerance;
    }

    @Override
    public CTExecutionPhase getExecutionPhase() {
        return this._executionPhase;
    }

    public final double getInitialStepSize() {
        return this._initStepSize;
    }

    @Override
    public Time getIterationBeginTime() {
        return this._iterationBeginTime;
    }

    public final int getMaxIterations() {
        return this._maxIterations;
    }

    public final double getMaxStepSize() {
        return this._maxStepSize;
    }

    public final double getMinStepSize() {
        return this._minStepSize;
    }

    @Override
    public Time getModelNextIterationTime() {
        return this.getIterationBeginTime().add(this.getCurrentStepSize());
    }

    @Override
    public final Time getModelStartTime() {
        return this._startTime;
    }

    @Override
    public final Time getModelStopTime() {
        return this._stopTime;
    }

    public final double getSuggestedNextStepSize() {
        return this._suggestedNextStepSize;
    }

    public final double getValueResolution() {
        return this._valueResolution;
    }

    @Override
    public void initialize() throws IllegalActionException {
        this._postfireReturns = true;
        this._timeBase = System.currentTimeMillis();
        super.initialize();
    }

    @Override
    public boolean isDiscretePhase() {
        return this._discretePhase;
    }

    @Override
    public Receiver newReceiver() {
        return new CTReceiver();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        boolean postfireReturns;
        if (!this._isTopLevel() && this.getBreakPoints().size() > 0) {
            Time time = (Time)this.getBreakPoints().first();
            CompositeActor container = (CompositeActor)this.getContainer();
            container.getExecutiveDirector().fireAt((Actor)container, time);
        }
        boolean bl = postfireReturns = this._postfireReturns && !this._stopRequested;
        if (this._debugging && this._verbose) {
            this._debug("Postfire returns " + postfireReturns + " at: " + this.getModelTime());
        }
        return postfireReturns;
    }

    public void prefireClear() {
        this._prefiredActors.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prefireDynamicActors() throws IllegalActionException {
        this._setExecutionPhase(CTExecutionPhase.PREFIRING_DYNAMIC_ACTORS_PHASE);
        try {
            CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
            Iterator actors = schedule.get(2).actorIterator();
            while (actors.hasNext() && !this._stopRequested) {
                Actor actor = (Actor)actors.next();
                if (this._debugging && this._verbose) {
                    this._debug("Prefire dynamic actor: " + actor.getName());
                }
                boolean ready = actor.prefire();
                if (actor instanceof CTCompositeActor) {
                    boolean bl = ready = ready && ((CTCompositeActor)actor).prefireDynamicActors();
                }
                if (!ready) {
                    this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
                    throw new IllegalActionException((Nameable)actor, "Actor is not ready to fire. In the CT domain, all dynamic actors should be ready to fire at all times.\n Does the actor only operate on sequence of tokens?");
                }
                if (!this._debugging || !this._verbose) continue;
                this._debug("Prefire of " + actor.getName() + " returns " + ready);
            }
            Iterator integrators = schedule.get(2).actorIterator();
            while (integrators.hasNext() && !this._stopRequested) {
                CTDynamicActor dynamic = (CTDynamicActor)integrators.next();
                if (this._debugging && this._verbose) {
                    this._debug("Emit tentative state " + dynamic.getName());
                }
                dynamic.emitCurrentStates();
            }
        }
        finally {
            this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
        }
        return !this._stopRequested;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        CTScheduler scheduler;
        NamedObj nameable;
        if (this._debugging) {
            this._debug(this.getFullName(), "preinitializing.");
        }
        if (!((nameable = this.getContainer()) instanceof CompositeActor)) {
            throw new IllegalActionException((Nameable)this, "has no CompositeActor container.");
        }
        CompositeActor container = (CompositeActor)nameable;
        if (container.getContainer() != null) {
            if (!this.canBeInsideDirector()) {
                throw new IllegalActionException((Nameable)this, "cannot serve as an inside director.");
            }
        } else if (!this.canBeTopLevelDirector()) {
            throw new IllegalActionException((Nameable)this, "cannot serve as an top-level director.");
        }
        if ((scheduler = (CTScheduler)this.getScheduler()) == null) {
            throw new IllegalActionException((Nameable)this, "has no scheduler.");
        }
        scheduler.setValid(false);
        this._initializeLocalVariables();
        super.preinitialize();
        this._startTime = new Time((Director)this, this._startTimeValue);
        this._stopTime = new Time((Director)this, this._stopTimeValue);
        this._iterationBeginTime = this._startTime;
    }

    public void setCurrentStepSize(double stepSize) {
        if (this._debugging) {
            this._debug("----- Setting the current step size to " + stepSize);
        }
        this._currentStepSize = stepSize;
    }

    public void setSuggestedNextStepSize(double stepsize) {
        this._suggestedNextStepSize = stepsize > this.getMaxStepSize() ? this.getMaxStepSize() : stepsize;
    }

    @Override
    public String[] suggestedModalModelDirectors() {
        String[] defaultSuggestions = new String[]{"ptolemy.domains.ct.kernel.HSFSMDirector", "ptolemy.domains.fsm.kernel.FSMDirector"};
        return defaultSuggestions;
    }

    protected void _initParameters() {
        try {
            this.startTime = new Parameter(this, "startTime");
            this.startTime.setExpression("0.0");
            this.startTime.setTypeEquals(BaseType.DOUBLE);
            this.stopTime = new Parameter(this, "stopTime");
            this.stopTime.setExpression("Infinity");
            this.stopTime.setTypeEquals(BaseType.DOUBLE);
            this.initStepSize = new Parameter(this, "initStepSize");
            this.initStepSize.setExpression("0.1");
            this.initStepSize.setTypeEquals(BaseType.DOUBLE);
            this.minStepSize = new Parameter(this, "minStepSize");
            this.minStepSize.setExpression("1e-5");
            this.minStepSize.setTypeEquals(BaseType.DOUBLE);
            this.maxStepSize = new Parameter(this, "maxStepSize");
            this.maxStepSize.setExpression("1.0");
            this.maxStepSize.setTypeEquals(BaseType.DOUBLE);
            this.maxIterations = new Parameter(this, "maxIterations");
            this.maxIterations.setExpression("20");
            this.maxIterations.setTypeEquals(BaseType.INT);
            this.errorTolerance = new Parameter(this, "errorTolerance");
            this.errorTolerance.setExpression("1e-4");
            this.errorTolerance.setTypeEquals(BaseType.DOUBLE);
            this.valueResolution = new Parameter(this, "valueResolution");
            this.valueResolution.setExpression("1e-6");
            this.valueResolution.setTypeEquals(BaseType.DOUBLE);
            this.synchronizeToRealTime = new Parameter(this, "synchronizeToRealTime");
            this.synchronizeToRealTime.setExpression("false");
            this.synchronizeToRealTime.setTypeEquals(BaseType.BOOLEAN);
            this.timeResolution.setVisibility(Settable.FULL);
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException("Parameter creation error: " + e);
        }
        catch (NameDuplicationException ex) {
            throw new InvalidStateException(this, "Parameter name duplication: " + ex);
        }
    }

    protected final ODESolver _instantiateODESolver(String className) throws IllegalActionException {
        ODESolver newSolver;
        if (this._debugging) {
            this._debug("instantiating solver..." + className);
        }
        try {
            Class<?> solver = Class.forName(className);
            newSolver = (ODESolver)solver.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalActionException((Nameable)this, "ODESolver: " + className + " is not found.");
        }
        catch (InstantiationException e) {
            throw new IllegalActionException((Nameable)this, "ODESolver: " + className + " instantiation failed.");
        }
        catch (IllegalAccessException e) {
            throw new IllegalActionException((Nameable)this, "ODESolver: " + className + " is not accessible.");
        }
        newSolver._makeSolverOf(this);
        return newSolver;
    }

    protected final void _setCurrentODESolver(ODESolver solver) throws IllegalActionException {
        this._currentSolver = solver;
    }

    protected final void _setDiscretePhase(boolean discrete) {
        this._discretePhase = discrete;
    }

    protected final void _setExecutionPhase(CTExecutionPhase phase) {
        this._executionPhase = phase;
    }

    protected final void _setIterationBeginTime(Time time) {
        this._iterationBeginTime = time;
    }

    private void _initializeLocalVariables() throws IllegalActionException {
        TotallyOrderedSet breakpoints;
        this._errorTolerance = ((DoubleToken)this.errorTolerance.getToken()).doubleValue();
        this._initStepSize = ((DoubleToken)this.initStepSize.getToken()).doubleValue();
        this._maxIterations = ((IntToken)this.maxIterations.getToken()).intValue();
        this._maxStepSize = ((DoubleToken)this.maxStepSize.getToken()).doubleValue();
        this._minStepSize = ((DoubleToken)this.minStepSize.getToken()).doubleValue();
        this._valueResolution = ((DoubleToken)this.valueResolution.getToken()).doubleValue();
        this._currentSolver = null;
        this._prefiredActors = new HashSet();
        this._currentStepSize = this._initStepSize;
        this._suggestedNextStepSize = this._initStepSize;
        this._discretePhase = true;
        this._executionPhase = CTExecutionPhase.UNKNOWN_PHASE;
        if (this._debugging) {
            this._debug(this.getFullName(), "create/clear break point table.");
        }
        if ((breakpoints = this.getBreakPoints()) != null) {
            breakpoints.clear();
        } else {
            this._breakpoints = new TotallyOrderedSet(new GeneralComparator());
        }
    }
}

