/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel;

import java.util.Iterator;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.util.Time;
import ptolemy.domains.ct.kernel.CTDynamicActor;
import ptolemy.domains.ct.kernel.CTExecutionPhase;
import ptolemy.domains.ct.kernel.CTGeneralDirector;
import ptolemy.domains.ct.kernel.CTMultiSolverDirector;
import ptolemy.domains.ct.kernel.CTSchedule;
import ptolemy.domains.ct.kernel.CTStatefulActor;
import ptolemy.domains.ct.kernel.CTStepSizeControlActor;
import ptolemy.domains.ct.kernel.CTTransparentDirector;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class CTEmbeddedDirector
extends CTMultiSolverDirector
implements CTTransparentDirector {
    private boolean _outputAcceptable;
    private boolean _stateAcceptable;

    public CTEmbeddedDirector() {
    }

    public CTEmbeddedDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public CTEmbeddedDirector(Workspace workspace) {
        super(workspace);
    }

    @Override
    public boolean canBeInsideDirector() {
        return true;
    }

    @Override
    public boolean canBeTopLevelDirector() {
        return false;
    }

    @Override
    public void emitCurrentStates() {
        try {
            Iterator dynamicActors = this.getScheduler().getSchedule().get(2).actorIterator();
            while (dynamicActors.hasNext() && !this._stopRequested) {
                CTDynamicActor dynamicActor = (CTDynamicActor)dynamicActors.next();
                dynamicActor.emitCurrentStates();
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        CTExecutionPhase executionPhase;
        CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
        if (this._initialStatesNotReady) {
            this.establishInitialStates();
            this._initialStatesNotReady = false;
        }
        if ((executionPhase = this.getExecutionPhase()) == CTExecutionPhase.ITERATING_PURELY_DISCRETE_ACTORS_PHASE) {
            super._iteratePurelyDiscreteActors(schedule);
        } else if (executionPhase == CTExecutionPhase.FIRING_DYNAMIC_ACTORS_PHASE) {
            this.getCurrentODESolver().fireDynamicActors();
        } else if (executionPhase == CTExecutionPhase.FIRING_EVENT_GENERATORS_PHASE) {
            super.fireEventGenerators();
        } else if (executionPhase == CTExecutionPhase.FIRING_STATE_TRANSITION_ACTORS_PHASE) {
            this.getCurrentODESolver().fireStateTransitionActors();
            super.produceOutput();
        } else if (executionPhase == CTExecutionPhase.PRODUCING_OUTPUTS_PHASE) {
            super.produceOutput();
        } else if (executionPhase == CTExecutionPhase.GENERATING_EVENTS_PHASE) {
            super._iterateEventGenerators(schedule);
        } else if (executionPhase == CTExecutionPhase.GENERATING_WAVEFORMS_PHASE) {
            super._iterateWaveformGenerators(schedule);
        }
    }

    @Override
    public double getCurrentStepSize() {
        CTGeneralDirector executiveDirector = this.getExecutiveCTGeneralDirector();
        if (executiveDirector != null) {
            return executiveDirector.getCurrentStepSize();
        }
        throw new InternalErrorException("A CT model with a CTEmbeddedDirector must be used inside another CT model.");
    }

    @Override
    public CTGeneralDirector getExecutiveCTGeneralDirector() {
        CompositeActor container = (CompositeActor)this.getContainer();
        Director executiveDirector = container.getExecutiveDirector();
        if (executiveDirector instanceof CTGeneralDirector) {
            return (CTGeneralDirector)((Object)executiveDirector);
        }
        throw new InternalErrorException("A CT model with a CTEmbeddedDirector must be used inside another CT model.");
    }

    @Override
    public CTExecutionPhase getExecutionPhase() {
        CTGeneralDirector executiveDirector = this.getExecutiveCTGeneralDirector();
        if (executiveDirector != null) {
            return executiveDirector.getExecutionPhase();
        }
        throw new InternalErrorException("A CT model with a CTEmbeddedDirector must be used inside another CT model.");
    }

    @Override
    public Time getIterationBeginTime() {
        CTGeneralDirector executiveDirector = this.getExecutiveCTGeneralDirector();
        if (executiveDirector != null) {
            return executiveDirector.getIterationBeginTime();
        }
        throw new InternalErrorException("A CT model with a CTEmbeddedDirector must be used inside another CT model.");
    }

    @Override
    public void goToMarkedState() {
        try {
            this.setModelTime(this.getIterationBeginTime());
            Iterator statefulActors = this.getScheduler().getSchedule().get(7).actorIterator();
            while (statefulActors.hasNext() && !this._stopRequested) {
                CTStatefulActor statefulActor = (CTStatefulActor)statefulActors.next();
                statefulActor.goToMarkedState();
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._initialStatesNotReady = false;
    }

    @Override
    public boolean isDiscretePhase() {
        CTGeneralDirector executiveDirector = this.getExecutiveCTGeneralDirector();
        if (executiveDirector != null) {
            return executiveDirector.isDiscretePhase();
        }
        throw new InternalErrorException("A CT model with a CTEmbeddedDirector must be used inside another CT model.");
    }

    @Override
    public boolean isOutputAccurate() {
        this._outputAcceptable = this._isOutputAccurate();
        return this._outputAcceptable;
    }

    @Override
    public boolean isStateAccurate() {
        this._stateAcceptable = this._isStateAccurate();
        return this._stateAcceptable;
    }

    @Override
    public void markState() {
        try {
            Iterator statefulActors = this.getScheduler().getSchedule().get(7).actorIterator();
            while (statefulActors.hasNext() && !this._stopRequested) {
                CTStatefulActor statefulActor = (CTStatefulActor)statefulActors.next();
                statefulActor.markState();
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this.getExecutionPhase() == CTExecutionPhase.UPDATING_CONTINUOUS_STATES_PHASE) {
            super.updateContinuousStates();
        } else if (this.getExecutionPhase() == CTExecutionPhase.POSTFIRING_EVENT_GENERATORS_PHASE) {
            super.postfireEventGenerators();
        }
        return super.postfire();
    }

    @Override
    public double predictedStepSize() {
        try {
            double nextStepSize = this._predictNextStepSize();
            if (this._debugging) {
                this._debug(this.getName(), "at " + this.getModelTime(), " predicts next step size as " + nextStepSize);
            }
            return nextStepSize;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(" Fail to predict the next step size." + ex.getMessage());
        }
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this.isDiscretePhase()) {
            this._setCurrentODESolver(this.getBreakpointSolver());
        } else {
            this._setCurrentODESolver(this.getNormalODESolver());
            this.prefireClear();
        }
        return super.prefire();
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        if (!(this.getContainer() instanceof CTStepSizeControlActor)) {
            throw new IllegalActionException((Nameable)this, "can only be contained by a composite actor that implements the CTStepSizeControlActor interface, for example, a continuous time composite actor.");
        }
        super.preinitialize();
    }

    @Override
    public double refinedStepSize() {
        try {
            double refinedStepSize = Double.MAX_VALUE;
            if (!this._stateAcceptable) {
                refinedStepSize = this._refinedStepWRTState();
            }
            if (!this._outputAcceptable) {
                refinedStepSize = Math.min(refinedStepSize, this._refinedStepWRTOutput());
            }
            return refinedStepSize;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("Fail to refine step size. " + ex.getMessage());
        }
    }
}

