/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IORelation;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.AddSubtract;
import ptolemy.actor.lib.Scale;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.domains.ct.lib.Integrator;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class ContinuousTransferFunction
extends TypedCompositeActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    public Parameter numerator = new Parameter(this, "numerator");
    public Parameter denominator;
    private boolean _opaque = true;

    public ContinuousTransferFunction(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.numerator.setExpression("{1.0}");
        this.numerator.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.denominator = new Parameter(this, "denominator");
        this.denominator.setExpression("{1.0}");
        this.denominator.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.setClassName("ptolemy.domains.ct.lib.ContinuousTransferFunction");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:white\"/>\n<text x=\"-25\" y=\"0\" style=\"font-size:14\">\nb(s)/a(s) \n</text>\nstyle=\"fill:blue\"/>\n</svg>\n");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.numerator) {
            this._opaque = true;
            Director dir = this.getDirector();
            if (dir != null) {
                dir.requestInitialization(this);
            }
        } else if (attribute == this.denominator) {
            ArrayToken aToken = (ArrayToken)this.denominator.getToken();
            if (((DoubleToken)aToken.getElement(0)).doubleValue() == 0.0) {
                throw new IllegalActionException((Nameable)this, "The denominator coefficient cannot start with 0.");
            }
            this._opaque = true;
            Director dir = this.getDirector();
            if (dir != null) {
                dir.requestInitialization(this);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Director getDirector() {
        if (this._opaque) {
            return null;
        }
        return this.getExecutiveDirector();
    }

    @Override
    public boolean isOpaque() {
        return this._opaque;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        ArrayToken bToken = (ArrayToken)this.numerator.getToken();
        int m = bToken.length();
        double[] bRow = new double[m];
        for (int i = 0; i < m; ++i) {
            bRow[i] = ((DoubleToken)bToken.getElement(i)).doubleValue();
        }
        ArrayToken aToken = (ArrayToken)this.denominator.getToken();
        int n = aToken.length();
        double[] a = new double[n];
        for (int i = 0; i < n; ++i) {
            a[i] = ((DoubleToken)aToken.getElement(i)).doubleValue();
        }
        if (m > n) {
            throw new IllegalActionException((Nameable)this, "The order of the denominator must be greater than or equal to the order of the numerator.");
        }
        double[] b = new double[n];
        for (int i = 1; i <= m; ++i) {
            b[n - i] = bRow[m - i];
        }
        try {
            this._workspace.getWriteAccess();
            this.removeAllEntities();
            this.removeAllRelations();
            if (n == 1) {
                if (a[0] == b[0]) {
                    this.connect(this.input, this.output);
                } else {
                    Scale scaleD = new Scale(this, "ScaleD");
                    scaleD.factor.setToken(new DoubleToken(b[0] / a[0]));
                    this.connect(this.input, scaleD.input);
                    this.connect(this.output, scaleD.output);
                }
            } else {
                double d = b[0] / a[0];
                int order = n - 1;
                AddSubtract inputAdder = new AddSubtract(this, "InputAdder");
                AddSubtract outputAdder = new AddSubtract(this, "OutputAdder");
                Integrator[] integrators = new Integrator[order];
                IORelation[] nodes = new IORelation[order];
                Scale[] feedback = new Scale[order];
                Scale[] feedforward = new Scale[order];
                for (int i = 0; i < order; ++i) {
                    integrators[i] = new Integrator(this, "Integrator" + i);
                    feedback[i] = new Scale(this, "Feedback" + i);
                    feedback[i].factor.setToken(new DoubleToken(-a[i + 1] / a[0]));
                    feedforward[i] = new Scale(this, "Feedforward" + i);
                    feedforward[i].factor.setToken(new DoubleToken((b[i + 1] - d * a[i + 1]) / a[0]));
                    nodes[i] = (IORelation)this.connect(integrators[i].output, feedforward[i].input, "node" + i);
                    feedback[i].input.link(nodes[i]);
                    this.connect(feedback[i].output, inputAdder.plus);
                    this.connect(feedforward[i].output, outputAdder.plus);
                    if (i < 1) continue;
                    integrators[i].input.link(nodes[i - 1]);
                }
                this.connect(inputAdder.output, integrators[0].input);
                IORelation inputRelation = (IORelation)this.connect(this.input, inputAdder.plus, "inputRelation");
                this.connect(this.output, outputAdder.output, "outputRelation");
                if (d != 0.0) {
                    Scale scaleD = new Scale(this, "ScaleD");
                    scaleD.factor.setToken(new DoubleToken(d));
                    scaleD.input.link(inputRelation);
                    this.connect(scaleD.output, outputAdder.plus);
                }
            }
            this._opaque = false;
            this._workspace.incrVersion();
        }
        catch (NameDuplicationException ex) {
            throw new InternalErrorException("Duplicated name when constructing the subsystem" + ex.getMessage());
        }
        finally {
            this._workspace.doneWriting();
        }
        for (Actor actor : this.deepEntityList()) {
            actor.preinitialize();
        }
    }

    @Override
    public void wrapup() throws IllegalActionException {
        this._opaque = true;
        super.wrapup();
    }
}

