/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IORelation;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.actor.lib.AddSubtract;
import ptolemy.actor.lib.Scale;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.ct.lib.Integrator;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class LinearStateSpace
extends TypedCompositeActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public TypedIOPort output;
    public TypedIOPort stateOutput;
    public Parameter A;
    public Parameter B;
    public Parameter C;
    public Parameter D;
    public Parameter initialStates;
    private boolean _opaque;
    private boolean _requestInitialization;

    public LinearStateSpace(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setMultiport(true);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setMultiport(true);
        this.stateOutput = new TypedIOPort(this, "stateOutput", false, true);
        this.stateOutput.setMultiport(true);
        this._opaque = true;
        this._requestInitialization = true;
        double[][] one = new double[][]{{1.0}};
        double[][] zero = new double[][]{{0.0}};
        this.A = new Parameter((NamedObj)this, "A", new DoubleMatrixToken(one));
        this.A.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.B = new Parameter((NamedObj)this, "B", new DoubleMatrixToken(one));
        this.B.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.C = new Parameter((NamedObj)this, "C", new DoubleMatrixToken(one));
        this.C.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.D = new Parameter((NamedObj)this, "D", new DoubleMatrixToken(zero));
        this.D.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.initialStates = new Parameter((NamedObj)this, "initialStates", new DoubleMatrixToken(zero));
        this.initialStates.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.setClassName("ptolemy.domains.ct.lib.LinearStateSpace");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-50\" y=\"-30\" width=\"100\" height=\"60\" style=\"fill:white\"/>\n<text x=\"-45\" y=\"-10\" style=\"font-size:14\">\ndx/dt=Ax+Bu </text>\n<text x=\"-45\" y=\"10\" style=\"font-size:14\">\n    y=Cx+Du</text>\n</svg>\n");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.A) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.A.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0 || token.getRowCount() != token.getColumnCount()) {
                throw new IllegalActionException((Nameable)this, "The A matrix must be a nonempty square matrix.");
            }
            this._requestInitialization = true;
        } else if (attribute == this.B) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.B.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0) {
                throw new IllegalActionException((Nameable)this, "The B matrix must be a nonempty matrix.");
            }
            this._requestInitialization = true;
        } else if (attribute == this.C) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.C.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0) {
                throw new IllegalActionException((Nameable)this, "The C matrix must be a nonempty matrix.");
            }
            this._requestInitialization = true;
        } else if (attribute == this.D) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.D.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0) {
                throw new IllegalActionException((Nameable)this, "The D matrix must be a nonempty matrix.");
            }
            this._requestInitialization = true;
        } else if (attribute == this.initialStates) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.initialStates.getToken();
            if (token.getRowCount() != 1 || token.getColumnCount() < 1) {
                throw new IllegalActionException((Nameable)this, "The initialStates must be a row vector.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Director getDirector() {
        if (this._opaque) {
            return null;
        }
        return this.getExecutiveDirector();
    }

    @Override
    public boolean isOpaque() {
        return this._opaque;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._requestInitialization) {
            this._requestInitialization();
        }
        return super.postfire();
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        this._checkParameters();
        DoubleMatrixToken a = (DoubleMatrixToken)this.A.getToken();
        int n = a.getRowCount();
        DoubleMatrixToken b = (DoubleMatrixToken)this.B.getToken();
        int m = b.getColumnCount();
        DoubleMatrixToken c = (DoubleMatrixToken)this.C.getToken();
        int r = c.getRowCount();
        this.D.getToken();
        this.initialStates.getToken();
        try {
            this._workspace.getWriteAccess();
            this.removeAllEntities();
            this.removeAllRelations();
            Integrator[] integrators = new Integrator[n];
            IORelation[] states = new IORelation[n];
            AddSubtract[] stateAdders = new AddSubtract[n];
            for (int i = 0; i < n; ++i) {
                integrators[i] = new Integrator(this, "state_" + i);
                integrators[i].initialState.setExpression("initialStates(0," + i + ")");
                states[i] = new TypedIORelation(this, "relation_state_" + i);
                integrators[i].output.link(states[i]);
                stateAdders[i] = new AddSubtract(this, "stateAdder_" + i);
                this.connect(stateAdders[i].output, integrators[i].input);
                this.stateOutput.link(states[i]);
            }
            Scale[][] feedback = new Scale[n][n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    feedback[i][j] = new Scale(this, "feedback_" + i + "_" + j);
                    feedback[i][j].factor.setExpression("A(" + i + ", " + j + ")");
                    feedback[i][j].input.link(states[j]);
                    this.connect(feedback[i][j].output, stateAdders[i].plus);
                }
            }
            Scale[][] inputScales = new Scale[n][m];
            IORelation[] inputs = new IORelation[m];
            for (int j = 0; j < m; ++j) {
                inputs[j] = new TypedIORelation(this, "relation_input_" + j);
                this.input.link(inputs[j]);
                for (int i = 0; i < n; ++i) {
                    inputScales[i][j] = new Scale(this, "b_" + i + "_" + j);
                    inputScales[i][j].factor.setExpression("B(" + i + ", " + j + ")");
                    inputScales[i][j].input.link(inputs[j]);
                    this.connect(inputScales[i][j].output, stateAdders[i].plus);
                }
            }
            AddSubtract[] outputAdders = new AddSubtract[r];
            Scale[][] outputScales = new Scale[r][n];
            for (int l = 0; l < r; ++l) {
                outputAdders[l] = new AddSubtract(this, "outputAdder" + l);
                this.connect(outputAdders[l].output, this.output);
                for (int i = 0; i < n; ++i) {
                    outputScales[l][i] = new Scale(this, "outputScale_" + l + "_" + i);
                    outputScales[l][i].factor.setExpression("C(" + l + ", " + i + ")");
                    outputScales[l][i].input.link(states[i]);
                    this.connect(outputScales[l][i].output, outputAdders[l].plus);
                }
            }
            Scale[][] feedThrough = new Scale[r][m];
            for (int l = 0; l < r; ++l) {
                for (int j = 0; j < m; ++j) {
                    feedThrough[l][j] = new Scale(this, "feedThrough_" + l + "_" + j);
                    feedThrough[l][j].factor.setExpression("D(" + l + ", " + j + ")");
                    feedThrough[l][j].input.link(inputs[j]);
                    this.connect(feedThrough[l][j].output, outputAdders[l].plus);
                }
            }
            this._opaque = false;
            this._workspace.incrVersion();
        }
        catch (NameDuplicationException ex) {
            throw new InternalErrorException("Duplicated name when constructing the subsystem" + ex.getMessage());
        }
        finally {
            this._workspace.doneWriting();
        }
        for (Actor actor : this.deepEntityList()) {
            actor.preinitialize();
        }
    }

    @Override
    public void stopFire() {
    }

    @Override
    public void wrapup() throws IllegalActionException {
        this._opaque = true;
        super.wrapup();
    }

    private void _checkParameters() throws IllegalActionException {
        DoubleMatrixToken a = (DoubleMatrixToken)this.A.getToken();
        int n = a.getRowCount();
        DoubleMatrixToken b = (DoubleMatrixToken)this.B.getToken();
        if (b.getRowCount() != n) {
            throw new IllegalActionException((Nameable)this, "The number of rows of the B matrix (" + b.getRowCount() + ") should be equal to " + "the number of rows of the A matrix (" + n + ").");
        }
        int m = b.getColumnCount();
        if (this.input.getWidth() != m) {
            throw new IllegalActionException((Nameable)this, "The number of columns of the B matrix (" + b.getColumnCount() + ") should be equal to " + "the width of the input port (" + this.input.getWidth() + ").");
        }
        DoubleMatrixToken c = (DoubleMatrixToken)this.C.getToken();
        if (c.getColumnCount() != n) {
            throw new IllegalActionException((Nameable)this, "The number of columns of the C matrix (" + c.getColumnCount() + ") should be equal to " + "the number of rows of the A matrix (" + n + ").");
        }
        DoubleMatrixToken d = (DoubleMatrixToken)this.D.getToken();
        if (c.getRowCount() != d.getRowCount()) {
            throw new IllegalActionException((Nameable)this, "The number of rows of the D matrix (" + d.getRowCount() + ") should be equal to " + "the number of rows of the C matrix (" + c.getRowCount() + ").");
        }
        if (d.getColumnCount() != this.input.getWidth()) {
            throw new IllegalActionException((Nameable)this, "The number of columns of the D matrix (" + d.getColumnCount() + ") should be equal to " + "the width of the input port (" + this.input.getWidth() + ").");
        }
        DoubleMatrixToken x0 = (DoubleMatrixToken)this.initialStates.getToken();
        if (x0.getColumnCount() != n) {
            throw new IllegalActionException((Nameable)this, "The number of initial states (" + x0.getColumnCount() + ") should equal to " + "the number of columns of the A matrix (" + n + ").");
        }
    }

    private void _requestInitialization() {
        Director dir = this.getDirector();
        if (dir != null) {
            dir.requestInitialization(this);
        }
        this._opaque = true;
    }
}

