/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ddf.lib;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.IORelation;
import ptolemy.actor.QueueReceiver;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.util.DFUtilities;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.ddf.kernel.DDFDirector;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class ActorRecursion
extends TypedCompositeActor {
    public StringParameter recursionActor;
    private CompositeActor _recursionActor = null;
    private boolean _isCompatibilityChecked = false;
    private HashMap _inputTokensHolder = new HashMap();

    public ActorRecursion(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        new DDFDirector(this, this.uniqueName("DDFDirector"));
        this.recursionActor = new StringParameter(this, "recursionActor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire() throws IllegalActionException {
        try {
            ((DDFDirector)this.getExecutiveDirector()).disableTypeResolution(true);
            ((DDFDirector)this.getDirector()).disableTypeResolution(true);
            try {
                this._cloneRecursionActor();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalActionException((Nameable)this, ex, "The actor " + this.recursionActor.stringValue() + " cannot be cloned.");
            }
            this.getDirector().preinitialize();
            this._transferInputs();
            this._setOutputPortRate();
            this.getDirector().initialize();
            this._transferOutputs();
            ((DDFDirector)this.getExecutiveDirector()).merge((DDFDirector)this.getDirector());
            try {
                this.getDirector().setContainer(null);
            }
            catch (NameDuplicationException ex) {
                throw new InternalErrorException(this, (Throwable)ex, null);
            }
        }
        finally {
            ((DDFDirector)this.getExecutiveDirector()).disableTypeResolution(false);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        this._searchRecursionActor();
        if (!this._isCompatibilityChecked) {
            this._checkCompatibility();
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        return false;
    }

    @Override
    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        for (Attribute attribute : this.attributeList()) {
            attribute.exportMoML(output, depth);
        }
        for (Port port : this.portList()) {
            port.exportMoML(output, depth);
        }
    }

    @Override
    protected void _finishedAddEntity(ComponentEntity entity) {
    }

    private void _checkCompatibility() throws IllegalActionException {
        if (!(this.getExecutiveDirector() instanceof DDFDirector)) {
            throw new IllegalActionException((Nameable)this, "The executive Director must be a DDFDirector.");
        }
        if (this._recursionActor.inputPortList().size() != this.inputPortList().size() || this._recursionActor.outputPortList().size() != this.outputPortList().size()) {
            throw new IllegalActionException((Nameable)this, "The recursionActor " + this.recursionActor.stringValue() + " must have the same number of input ports and " + "same number of output ports as this actor.");
        }
        for (TypedIOPort port : this.portList()) {
            Port matching = this._recursionActor.getPort(port.getName());
            if (matching == null) {
                throw new IllegalActionException((Nameable)this, "Each port of this actor must have the same name as the matching port of the recursionActor " + this.recursionActor.stringValue() + ". However, the port " + port.getFullName() + " does not have a matching " + "port with the same name.");
            }
            TypedIOPort matchingPort = (TypedIOPort)matching;
            if (port.getWidth() != matchingPort.getWidth()) {
                throw new IllegalActionException((Nameable)this, "The matching ports: " + port.getFullName() + " and " + matchingPort.getFullName() + " must have the same width. Port " + port.getFullName() + "'s width " + port.getWidth() + " is not equal to " + matchingPort.getFullName() + "'s width " + matchingPort.getWidth() + ".");
            }
            if (port.isInput() && !matchingPort.isInput() || port.isOutput() && !matchingPort.isOutput()) {
                throw new IllegalActionException((Nameable)this, "The matching ports: " + port.getFullName() + " and " + matchingPort.getFullName() + " must be both input ports or output ports.");
            }
            Type portType = port.getType();
            Type matchingPortType = matchingPort.getType();
            if (port.isInput() && !matchingPortType.isCompatible(portType)) {
                throw new IllegalActionException((Nameable)this, "The type of the port " + port.getName() + " of the actor " + this.getName() + " must be equal to or less than " + "that of the matching port.");
            }
            if (!port.isOutput() || portType.isCompatible(matchingPortType)) continue;
            throw new IllegalActionException((Nameable)this, "The type of the port " + port.getName() + " of the actor " + this.getName() + " must be euqal to or greater than " + "that of the matching port.");
        }
        this._isCompatibilityChecked = true;
    }

    private void _cloneRecursionActor() throws IllegalActionException, CloneNotSupportedException {
        try {
            CompositeActor clone = (CompositeActor)this._recursionActor.clone(this.workspace());
            clone.setContainer(this);
            int i = 0;
            Iterator ports = this.portList().iterator();
            this._inputTokensHolder.clear();
            while (ports.hasNext()) {
                IOPort port = (IOPort)ports.next();
                if (port.isInput()) {
                    int width = port.getWidth();
                    Receiver[][] receivers = port.getReceivers();
                    Token[][] tokens = new Token[width][0];
                    for (int channel = 0; channel < width; ++channel) {
                        int size = ((QueueReceiver)receivers[channel][0]).size();
                        tokens[channel] = new Token[size];
                        for (int count = 0; count < size; ++count) {
                            tokens[channel][count] = port.get(channel);
                        }
                    }
                    this._inputTokensHolder.put(port, tokens);
                }
                IOPort matchingPort = (IOPort)clone.getPort(port.getName());
                IORelation relation = (IORelation)this.newRelation("r_" + i++);
                port.link(relation);
                matchingPort.link(relation);
                if (!port.isMultiport()) continue;
                relation.setWidth(port.getWidth());
            }
        }
        catch (NameDuplicationException ex) {
            throw new IllegalActionException((Nameable)this, "name duplication.");
        }
    }

    private int _getTokenConsumptionRate(Receiver receiver) throws IllegalActionException {
        int tokenConsumptionRate;
        IOPort port = receiver.getContainer();
        Variable rateVariable = null;
        Token token = null;
        Receiver[][] portReceivers = null;
        if (port.isOutput()) {
            rateVariable = DFUtilities.getRateVariable(port, "tokenProductionRate");
            portReceivers = port.getInsideReceivers();
            if (rateVariable == null) {
                return -1;
            }
            token = rateVariable.getToken();
            if (token == null) {
                return -1;
            }
        }
        if (port.isInput()) {
            rateVariable = DFUtilities.getRateVariable(port, "tokenConsumptionRate");
            portReceivers = port.getReceivers();
            if (rateVariable == null) {
                return 1;
            }
            token = rateVariable.getToken();
            if (token == null) {
                return 1;
            }
        }
        if (token instanceof ArrayToken) {
            Token[] tokens = ((ArrayToken)token).arrayValue();
            int channelIndex = 0;
            block0: for (int m = 0; m < portReceivers.length; ++m) {
                for (int n = 0; n < portReceivers[m].length; ++n) {
                    if (receiver != portReceivers[m][n]) continue;
                    channelIndex = m;
                    break block0;
                }
            }
            tokenConsumptionRate = ((IntToken)tokens[channelIndex]).intValue();
        } else {
            tokenConsumptionRate = ((IntToken)token).intValue();
        }
        return tokenConsumptionRate;
    }

    private void _searchRecursionActor() throws IllegalActionException {
        String recursionActorValue = this.recursionActor.stringValue();
        for (CompositeActor container = (CompositeActor)this.getContainer(); container != null; container = (CompositeActor)container.getContainer()) {
            if (!recursionActorValue.equals(container.getName())) continue;
            this._recursionActor = container;
            return;
        }
        throw new IllegalActionException((Nameable)this, "Can not find a container with name " + recursionActorValue);
    }

    private void _setOutputPortRate() throws IllegalActionException {
        for (IOPort outputPort : this.outputPortList()) {
            int[] productionRate = new int[outputPort.getWidthInside()];
            Arrays.fill(productionRate, -1);
            Receiver[][] farReceivers = outputPort.getRemoteReceivers();
            for (int i = 0; i < farReceivers.length; ++i) {
                if (i >= outputPort.getWidthInside()) continue;
                for (int j = 0; j < farReceivers[i].length; ++j) {
                    QueueReceiver farReceiver = (QueueReceiver)farReceivers[i][j];
                    int rate = this._getTokenConsumptionRate(farReceiver);
                    if (productionRate[i] < 0) {
                        productionRate[i] = rate;
                        continue;
                    }
                    if (rate < 0 || rate >= productionRate[i]) continue;
                    productionRate[i] = rate;
                }
            }
            Token[] productionRateToken = new IntToken[outputPort.getWidthInside()];
            for (int i = 0; i < outputPort.getWidthInside(); ++i) {
                productionRateToken[i] = new IntToken(productionRate[i]);
            }
            Variable rateVariable = DFUtilities.getRateVariable(outputPort, "tokenProductionRate");
            if (rateVariable == null) {
                try {
                    rateVariable = new Parameter(outputPort, "tokenProductionRate");
                }
                catch (NameDuplicationException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, null);
                }
            }
            rateVariable.setToken(new ArrayToken(BaseType.INT, productionRateToken));
        }
    }

    private void _transferInputs() throws IllegalActionException {
        for (IOPort inputPort : this.inputPortList()) {
            Token[][] tokens = (Token[][])this._inputTokensHolder.get(inputPort);
            for (int channel = 0; channel < inputPort.getWidth(); ++channel) {
                for (int j = 0; j < tokens[channel].length; ++j) {
                    inputPort.sendInside(channel, tokens[channel][j]);
                }
            }
        }
    }

    private void _transferOutputs() throws IllegalActionException {
        for (IOPort outputPort : this.outputPortList()) {
            for (int i = 0; i < outputPort.getWidthInside(); ++i) {
                while (outputPort.hasTokenInside(i)) {
                    outputPort.send(i, outputPort.getInside(i));
                }
            }
        }
    }
}

