/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.actor.util.FIFOQueue;
import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.de.lib.DETransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class Server
extends DETransformer {
    public Parameter capacity;
    public TypedIOPort size;
    public PortParameter serviceTime;
    private Time _nextTimeFree;
    protected FIFOQueue _queue;

    public Server(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeSameAs(this.input);
        this.serviceTime = new PortParameter(this, "serviceTime");
        this.serviceTime.setExpression("1.0");
        this.serviceTime.setTypeEquals(BaseType.DOUBLE);
        StringAttribute cardinality = new StringAttribute(this.serviceTime.getPort(), "_cardinal");
        cardinality.setExpression("SOUTH");
        this._queue = new FIFOQueue();
        this.size = new TypedIOPort(this, "size", false, true);
        this.size.setTypeEquals(BaseType.INT);
        cardinality = new StringAttribute(this.size, "_cardinal");
        cardinality.setExpression("SOUTH");
        this.capacity = new Parameter(this, "capacity");
        this.capacity.setTypeEquals(BaseType.INT);
        this.capacity.setExpression("0");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.serviceTime) {
            double value = ((DoubleToken)this.serviceTime.getToken()).doubleValue();
            if (value < 0.0) {
                throw new IllegalActionException((Nameable)this, "Cannot have negative serviceTime: " + value);
            }
        } else if (attribute == this.capacity) {
            int newCapacity = ((IntToken)this.capacity.getToken()).intValue();
            if (newCapacity <= 0) {
                if (this._queue.getCapacity() != -1) {
                    this._queue.setCapacity(-1);
                }
            } else {
                if (newCapacity < this._queue.size()) {
                    throw new IllegalActionException((Nameable)this, "Queue size (" + this._queue.size() + ") exceed requested capacity " + newCapacity + ").");
                }
                this._queue.setCapacity(newCapacity);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Server newObject = (Server)super.clone(workspace);
        newObject.output.setTypeSameAs(newObject.input);
        newObject._queue = new FIFOQueue();
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        Time currentTime = this.getDirector().getModelTime();
        if (this.input.hasToken(0)) {
            this._queue.put(this.input.get(0));
            this.size.send(0, new IntToken(this._queue.size()));
        }
        if (this._queue.size() > 0 && currentTime.compareTo(this._nextTimeFree) == 0) {
            Token outputToken = (Token)this._queue.take();
            this.output.send(0, outputToken);
            this.size.send(0, new IntToken(this._queue.size()));
            this._nextTimeFree = Time.NEGATIVE_INFINITY;
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._nextTimeFree = Time.NEGATIVE_INFINITY;
        this._queue.clear();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this.serviceTime.update();
        double serviceTimeValue = ((DoubleToken)this.serviceTime.getToken()).doubleValue();
        Time currentTime = this.getDirector().getModelTime();
        if (this._nextTimeFree.equals(Time.NEGATIVE_INFINITY) && this._queue.size() > 0) {
            this._nextTimeFree = currentTime.add(serviceTimeValue);
            this.getDirector().fireAt((Actor)this, this._nextTimeFree);
        }
        return super.postfire();
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.input, this.output);
        this.removeDependency(this.serviceTime.getPort(), this.output);
    }
}

