/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ptolemy.data.expr.ASTPtAssignmentNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParseTreeFreeVariableCollector;
import ptolemy.data.expr.ParseTreeTypeInference;
import ptolemy.data.expr.ParseTreeWriter;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.HasTypeConstraints;
import ptolemy.data.type.MonotonicFunction;
import ptolemy.data.type.Type;
import ptolemy.data.type.Typeable;
import ptolemy.domains.fsm.kernel.Action;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.graph.Inequality;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public abstract class AbstractActionsAttribute
extends Action
implements HasTypeConstraints {
    protected List _numbers;
    protected List _destinations;
    protected List _destinationNames;
    protected long _destinationsListVersion = -1L;
    protected List _parseTrees;
    protected ParseTreeEvaluator _parseTreeEvaluator;
    protected ParserScope _scope;

    public AbstractActionsAttribute(Workspace workspace) {
        super(workspace);
    }

    public AbstractActionsAttribute(Transition transition, String name) throws IllegalActionException, NameDuplicationException {
        super(transition, name);
    }

    @Override
    public void execute() throws IllegalActionException {
        if (this._destinationsListVersion != this.workspace().getVersion()) {
            this._updateDestinations();
        }
        if (this._parseTreeEvaluator == null) {
            this._parseTreeEvaluator = new ParseTreeEvaluator();
        }
    }

    public List getChannelNumberList() {
        if (this._numbers == null) {
            return new LinkedList();
        }
        return Collections.unmodifiableList(this._numbers);
    }

    public NamedObj getDestination(String name) throws IllegalActionException {
        return this._getDestination(name);
    }

    public List getDestinationNameList() {
        if (this._destinationNames == null) {
            return new LinkedList();
        }
        return Collections.unmodifiableList(this._destinationNames);
    }

    public String getExpression(String name) {
        ParseTreeWriter writer = new ParseTreeWriter();
        return writer.printParseTree((ASTPtRootNode)this._parseTrees.get(this._destinationNames.indexOf(name)));
    }

    public ASTPtRootNode getParseTree(String name) {
        return (ASTPtRootNode)this._parseTrees.get(this._destinationNames.indexOf(name));
    }

    public List getParseTreeList() {
        if (this._parseTrees == null) {
            return new LinkedList();
        }
        return Collections.unmodifiableList(this._parseTrees);
    }

    public boolean isChannelSpecified(String name) {
        Integer integer = (Integer)this._numbers.get(this._destinationNames.indexOf(name));
        return integer != null;
    }

    @Override
    public void setExpression(String expression) throws IllegalActionException {
        super.setExpression(expression);
        this._destinationNames = new LinkedList();
        this._numbers = new LinkedList();
        this._parseTrees = new LinkedList();
        this._destinationsListVersion = -1L;
        if (expression == null || expression.trim().equals("")) {
            return;
        }
        PtParser parser = new PtParser();
        Map map = parser.generateAssignmentMap(expression);
        for (String name : map.keySet()) {
            ASTPtAssignmentNode node = (ASTPtAssignmentNode)map.get(name);
            String completeDestinationSpec = node.getIdentifier();
            int openParen = completeDestinationSpec.indexOf("(");
            if (openParen > 0) {
                int closeParen = completeDestinationSpec.indexOf(")");
                if (closeParen < openParen) {
                    throw new IllegalActionException((Nameable)this, "Malformed action: expected destination = expression. Got: " + completeDestinationSpec);
                }
                this._destinationNames.add(completeDestinationSpec.substring(0, openParen).trim());
                String channelSpec = completeDestinationSpec.substring(openParen + 1, closeParen);
                try {
                    this._numbers.add(Integer.valueOf(channelSpec));
                }
                catch (NumberFormatException ex) {
                    throw new IllegalActionException((Nameable)this, "Malformed action: expected destination = expression. Got: " + completeDestinationSpec);
                }
            } else {
                this._destinationNames.add(completeDestinationSpec);
                this._numbers.add(null);
            }
            this._parseTrees.add(node.getExpressionTree());
        }
    }

    @Override
    public List typeConstraintList() {
        LinkedList<Inequality> list = new LinkedList<Inequality>();
        for (String name : this.getDestinationNameList()) {
            try {
                NamedObj object = this.getDestination(name);
                if (!(object instanceof Typeable)) continue;
                InequalityTerm term = ((Typeable)((Object)object)).getTypeTerm();
                list.add(new Inequality(new TypeFunction(name), term));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return list;
    }

    protected abstract NamedObj _getDestination(String var1) throws IllegalActionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateDestinations() throws IllegalActionException {
        try {
            this.workspace().getReadAccess();
            if (this._destinationNames != null) {
                this._destinations = new LinkedList();
                for (String destinationName : this._destinationNames) {
                    NamedObj destination = this._getDestination(destinationName);
                    this._destinations.add(destination);
                }
            }
            this._destinationsListVersion = this.workspace().getVersion();
        }
        finally {
            this.workspace().doneReading();
        }
    }

    private class TypeFunction
    extends MonotonicFunction {
        private String _name;
        private ParseTreeTypeInference _typeInference = new ParseTreeTypeInference();
        private ParseTreeFreeVariableCollector _variableCollector = new ParseTreeFreeVariableCollector();

        public TypeFunction(String name) {
            this._name = name;
        }

        @Override
        public Object getValue() throws IllegalActionException {
            try {
                InequalityTerm[] terms = this.getVariables();
                for (int i = 0; i < terms.length; ++i) {
                    InequalityTerm term = terms[i];
                    if (term == this || term.getValue() != BaseType.UNKNOWN) continue;
                    return BaseType.UNKNOWN;
                }
                ASTPtRootNode parseTree = (ASTPtRootNode)AbstractActionsAttribute.this._parseTrees.get(AbstractActionsAttribute.this._destinationNames.indexOf(this._name));
                if (AbstractActionsAttribute.this._scope == null) {
                    FSMActor fsmActor = (FSMActor)AbstractActionsAttribute.this.getContainer().getContainer();
                    AbstractActionsAttribute.this._scope = fsmActor.getPortScope();
                }
                Type type = this._typeInference.inferTypes(parseTree, AbstractActionsAttribute.this._scope);
                return type;
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)AbstractActionsAttribute.this, ex, "An error occurred during expression type inference");
            }
        }

        @Override
        public InequalityTerm[] getVariables() {
            try {
                ASTPtRootNode parseTree = (ASTPtRootNode)AbstractActionsAttribute.this._parseTrees.get(AbstractActionsAttribute.this._destinationNames.indexOf(this._name));
                if (AbstractActionsAttribute.this._scope == null) {
                    FSMActor fsmActor = (FSMActor)AbstractActionsAttribute.this.getContainer().getContainer();
                    AbstractActionsAttribute.this._scope = fsmActor.getPortScope();
                }
                Set set = this._variableCollector.collectFreeVariables(parseTree, AbstractActionsAttribute.this._scope);
                LinkedList<InequalityTerm> termList = new LinkedList<InequalityTerm>();
                for (String name : set) {
                    InequalityTerm term = AbstractActionsAttribute.this._scope.getTypeTerm(name);
                    if (term == null || !term.isSettable()) continue;
                    termList.add(term);
                }
                return termList.toArray(new InequalityTerm[termList.size()]);
            }
            catch (IllegalActionException ex) {
                return new InequalityTerm[0];
            }
        }

        @Override
        public String getVerboseString() {
            return AbstractActionsAttribute.this.getExpression(this._name);
        }
    }
}

