/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedActor;
import ptolemy.actor.util.DFUtilities;
import ptolemy.data.expr.ASTPtAssignmentNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeFreeVariableCollector;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.PtParser;
import ptolemy.domains.fsm.kernel.Action;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.FSMDirector;
import ptolemy.domains.fsm.kernel.MultipleEnabledTransitionsException;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class NonStrictFSMDirector
extends FSMDirector {
    private Set _nonpreemptiveTransitionsInputs = new HashSet();
    private Set _outputActionReferredInputPorts = new HashSet();
    private Set _preemptiveTransitionsInputs = new HashSet();
    private Set _referredInputPorts = new HashSet();
    private Set _refinementReferredInputPorts = new HashSet();
    private Set _setActionReferredInputPorts = new HashSet();

    public NonStrictFSMDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public void fire() throws IllegalActionException {
        IOPort port;
        FSMActor controller = this.getController();
        controller.readInputs();
        CompositeActor container = (CompositeActor)this.getContainer();
        List inputPortList = container.inputPortList();
        State currentState = controller.currentState();
        List enabledTransitions = controller.enabledTransitions(currentState.preemptiveTransitionList());
        if (enabledTransitions.size() > 1) {
            for (Transition enabledTransition : enabledTransitions) {
                if (enabledTransition.isNondeterministic()) continue;
                throw new MultipleEnabledTransitionsException((Nameable)controller.currentState(), "Multiple enabled transitions found but " + enabledTransition.getName() + " is deterministic.");
            }
        }
        Transition enabledTransition = null;
        int length = enabledTransitions.size();
        if (length != 0) {
            int randomChoice = (int)Math.floor(Math.random() * (double)length);
            if (randomChoice == length) {
                --randomChoice;
            }
            enabledTransition = (Transition)enabledTransitions.get(randomChoice);
        }
        this._enabledTransition = enabledTransition;
        if (enabledTransition == null) {
            int i;
            TypedActor[] actors = currentState.getRefinement();
            this.getRefinementReferredInputPorts(currentState);
            for (i = 0; i < inputPortList.size(); ++i) {
                port = (IOPort)inputPortList.get(i);
                if (!this._refinementReferredInputPorts.contains(port) || this._referredInputPorts.contains(port)) continue;
                super.transferInputs(port);
                controller.readInputs();
                this._referredInputPorts.add(port);
            }
            if (actors != null) {
                for (i = 0; i < actors.length && !this._stopRequested; ++i) {
                    if (!actors[i].prefire()) continue;
                    actors[i].fire();
                    actors[i].postfire();
                }
            }
            controller.readOutputsFromRefinement();
            this.getNonpreemptiveTransitionsReferredInputPorts(currentState);
            for (i = 0; i < inputPortList.size(); ++i) {
                port = (IOPort)inputPortList.get(i);
                if (!this._nonpreemptiveTransitionsInputs.contains(port) || this._referredInputPorts.contains(port)) continue;
                super.transferInputs(port);
                controller.readInputs();
                this._referredInputPorts.add(port);
            }
            enabledTransitions = controller.enabledTransitions(currentState.nonpreemptiveTransitionList());
            if (enabledTransitions.size() > 1) {
                for (Transition transition : enabledTransitions) {
                    if (transition.isNondeterministic()) continue;
                    throw new MultipleEnabledTransitionsException((Nameable)controller.currentState(), "Multiple enabled transitions found but " + transition.getName() + " is deterministic.");
                }
            }
            if ((length = enabledTransitions.size()) != 0) {
                int randomChoice = (int)Math.floor(Math.random() * (double)length);
                if (randomChoice == length) {
                    --randomChoice;
                }
                enabledTransition = (Transition)enabledTransitions.get(randomChoice);
            }
            this._enabledTransition = enabledTransition;
        }
        if (enabledTransition != null) {
            this.getOutputActionsReferredInputPorts(enabledTransition);
            this.getSetActionsReferredInputPorts(enabledTransition);
            for (int i = 0; i < inputPortList.size(); ++i) {
                IOPort port2 = (IOPort)inputPortList.get(i);
                if (!this._outputActionReferredInputPorts.contains(port2) || this._referredInputPorts.contains(port2)) continue;
                super.transferInputs(port2);
                controller.readInputs();
                this._referredInputPorts.add(port2);
            }
            controller.readInputs();
            for (Action action : enabledTransition.choiceActionList()) {
                action.execute();
            }
            for (int i = 0; i < inputPortList.size(); ++i) {
                port = (IOPort)inputPortList.get(i);
                if (!this._setActionReferredInputPorts.contains(port) || this._referredInputPorts.contains(port)) continue;
                super.transferInputs(port);
                controller.readInputs();
                this._referredInputPorts.add(port);
            }
            controller.readInputs();
        }
        controller._lastChosenTransition = enabledTransition;
    }

    public void getNonpreemptiveTransitionsReferredInputPorts(State state) throws IllegalActionException {
        List nonpreemptiveTransitionList = state.nonpreemptiveTransitionList();
        this._nonpreemptiveTransitionsInputs = this.getTransitionReferredInputPorts(nonpreemptiveTransitionList);
    }

    public void getOutputActionsReferredInputPorts(Transition transition) throws IllegalActionException {
        this._outputActionReferredInputPorts.clear();
        String string = transition.outputActions.getExpression();
        PtParser parser = new PtParser();
        ParseTreeFreeVariableCollector variableCollector = new ParseTreeFreeVariableCollector();
        FSMActor controller = this.getController();
        ParserScope scope = controller.getPortScope();
        if (!string.equals("")) {
            Map map = parser.generateAssignmentMap(string);
            for (String name : map.keySet()) {
                ASTPtAssignmentNode node = (ASTPtAssignmentNode)map.get(name);
                ASTPtRootNode parseTree = node.getExpressionTree();
                Set set = variableCollector.collectFreeVariables(parseTree, scope);
                this.getReferredInputPorts(set, this._outputActionReferredInputPorts);
            }
        }
    }

    public void getPreemptiveTransitionsReferredInputPorts(State state) throws IllegalActionException {
        List preemptiveTransitionList = state.preemptiveTransitionList();
        this._preemptiveTransitionsInputs = this.getTransitionReferredInputPorts(preemptiveTransitionList);
    }

    public void getReferredInputPorts(Set portSet, Set referredInputPorts) {
        CompositeActor container = (CompositeActor)this.getContainer();
        List inputPortList = container.inputPortList();
        for (int i = 0; i < inputPortList.size(); ++i) {
            IOPort inputPort = (IOPort)inputPortList.get(i);
            if (!portSet.contains(inputPort.getName())) continue;
            referredInputPorts.add(inputPort);
        }
    }

    public void getRefinementReferredInputPorts(State state) throws IllegalActionException {
        this._refinementReferredInputPorts.clear();
        TypedActor[] refinements = state.getRefinement();
        CompositeActor container = (CompositeActor)this.getContainer();
        if (refinements != null) {
            for (int i = 0; i < refinements.length; ++i) {
                for (IOPort inputPort : refinements[i].inputPortList()) {
                    if (inputPort.getWidth() == 0 || DFUtilities.getRate(inputPort) <= 0) continue;
                    for (IOPort inputPortOutside : inputPort.deepConnectedInPortList()) {
                        if (inputPortOutside.getContainer() != container || this._refinementReferredInputPorts.contains(inputPortOutside)) continue;
                        this._refinementReferredInputPorts.add(inputPortOutside);
                    }
                }
            }
        }
    }

    public void getSetActionsReferredInputPorts(Transition transition) throws IllegalActionException {
        this._setActionReferredInputPorts.clear();
        String string = transition.setActions.getExpression();
        PtParser parser = new PtParser();
        ParseTreeFreeVariableCollector variableCollector = new ParseTreeFreeVariableCollector();
        FSMActor controller = this.getController();
        ParserScope scope = controller.getPortScope();
        if (!string.equals("")) {
            Map map = parser.generateAssignmentMap(string);
            for (String name : map.keySet()) {
                ASTPtAssignmentNode node = (ASTPtAssignmentNode)map.get(name);
                ASTPtRootNode parseTree = node.getExpressionTree();
                Set set = variableCollector.collectFreeVariables(parseTree, scope);
                this.getReferredInputPorts(set, this._setActionReferredInputPorts);
            }
        }
    }

    public Set getTransitionReferredInputPorts(List transitionList) throws IllegalActionException {
        HashSet transitionsReferredInputPorts = new HashSet();
        for (Transition transition : transitionList) {
            String string = transition.getGuardExpression();
            if (string.equals("")) {
                throw new IllegalActionException((Nameable)this, "guard expression on " + transition.getName() + "is null!");
            }
            PtParser parser = new PtParser();
            ASTPtRootNode parseTree = parser.generateParseTree(string);
            ParseTreeFreeVariableCollector variableCollector = new ParseTreeFreeVariableCollector();
            FSMActor controller = this.getController();
            ParserScope scope = controller.getPortScope();
            Set set = variableCollector.collectFreeVariables(parseTree, scope);
            this.getReferredInputPorts(set, transitionsReferredInputPorts);
        }
        return transitionsReferredInputPorts;
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        FSMActor controller = this.getController();
        this.getPreemptiveTransitionsReferredInputPorts(controller.getInitialState());
        this._referredInputPorts.clear();
        this._referredInputPorts.addAll(this._preemptiveTransitionsInputs);
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        boolean postfireValue = super.postfire();
        FSMActor controller = this.getController();
        this.getPreemptiveTransitionsReferredInputPorts(controller.currentState());
        this._referredInputPorts.clear();
        this._referredInputPorts.addAll(this._preemptiveTransitionsInputs);
        return postfireValue;
    }

    @Override
    public boolean transferInputs(IOPort port) throws IllegalActionException {
        if (this._preemptiveTransitionsInputs.contains(port)) {
            return super.transferInputs(port);
        }
        return true;
    }
}

