/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.kernel;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.sched.NotSchedulableException;
import ptolemy.actor.sched.Scheduler;
import ptolemy.actor.util.ConstVariableModelAnalysis;
import ptolemy.actor.util.DFUtilities;
import ptolemy.actor.util.DependencyDeclaration;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public abstract class BaseSDFScheduler
extends Scheduler {
    protected static final boolean VERBOSE = false;

    public BaseSDFScheduler() {
    }

    public BaseSDFScheduler(Workspace workspace) {
        super(workspace);
    }

    public BaseSDFScheduler(Director container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public abstract void declareRateDependency() throws IllegalActionException;

    protected void _declareDependency(ConstVariableModelAnalysis analysis, Port port, String name, List dependents) throws IllegalActionException {
        Variable variable;
        DependencyDeclaration declaration;
        if (this._debugging) {
            // empty if block
        }
        if ((declaration = (DependencyDeclaration)(variable = DFUtilities.getRateVariable(port, name)).getAttribute("_SDFRateDependencyDeclaration", DependencyDeclaration.class)) == null) {
            try {
                declaration = new DependencyDeclaration(variable, "_SDFRateDependencyDeclaration");
            }
            catch (NameDuplicationException ex) {
                throw new InternalErrorException("Failed to construct _SDFRateDependencyDeclaration");
            }
        }
        declaration.setDependents(dependents);
        analysis.addDependencyDeclaration(declaration);
    }

    protected void _saveBufferSizes(final Map minimumBufferSizes) {
        Director director = (Director)this.getContainer();
        final CompositeActor container = (CompositeActor)director.getContainer();
        ChangeRequest request = new ChangeRequest(this, "Record buffer sizes"){

            @Override
            protected void _execute() throws KernelException {
                for (Relation relation : container.relationList()) {
                    Object bufferSizeObject = minimumBufferSizes.get(relation);
                    if (bufferSizeObject instanceof Integer) {
                        int bufferSize = (Integer)bufferSizeObject;
                        DFUtilities.setOrCreate((NamedObj)relation, "bufferSize", bufferSize);
                        if (!BaseSDFScheduler.this._debugging) continue;
                        BaseSDFScheduler.this._debug("Adding bufferSize parameter to " + relation.getName() + " with value " + bufferSize);
                        continue;
                    }
                    if (bufferSizeObject instanceof String) {
                        String bufferSizeExpression = (String)bufferSizeObject;
                        DFUtilities.setOrCreate((NamedObj)relation, "bufferSize", "\"" + bufferSizeExpression + "\"");
                        if (!BaseSDFScheduler.this._debugging) continue;
                        BaseSDFScheduler.this._debug("Adding bufferSize parameter to " + relation.getName() + " with expression " + bufferSizeExpression);
                        continue;
                    }
                    if (bufferSizeObject == null) continue;
                    throw new InternalErrorException("Invalid value found in buffer size map.\nValue is of type " + bufferSizeObject.getClass().getName() + ".\nIt should be of type Integer or String.\n");
                }
            }
        };
        request.setPersistent(false);
        container.requestChange(request);
    }

    protected void _saveContainerRates(Map externalRates) throws NotSchedulableException, IllegalActionException {
        Director director = (Director)this.getContainer();
        CompositeActor container = (CompositeActor)director.getContainer();
        for (IOPort port : container.portList()) {
            if (this._debugging) {
                // empty if block
            }
            Integer rate = (Integer)externalRates.get(port);
            if (port.isInput() && port.isOutput()) {
                throw new NotSchedulableException(port, "External port is both an input and an output, which is not allowed in SDF.");
            }
            if (port.isInput()) {
                DFUtilities.setIfNotDefined(port, "tokenConsumptionRate", rate);
                if (!this._debugging) continue;
                continue;
            }
            if (port.isOutput()) {
                DFUtilities.setIfNotDefined(port, "tokenProductionRate", rate);
                if (this._debugging) {
                    // empty if block
                }
                Iterator connectedPorts = port.insideSourcePortList().iterator();
                IOPort foundOutputPort = null;
                int inferredRate = 0;
                while (connectedPorts.hasNext()) {
                    IOPort connectedPort = (IOPort)connectedPorts.next();
                    int newRate = connectedPort.isOutput() ? DFUtilities.getTokenInitProduction(connectedPort) : 0;
                    if (foundOutputPort != null && newRate != inferredRate) {
                        throw new NotSchedulableException("External output port " + port + " is connected on the inside to ports " + "with different initial production: " + foundOutputPort + " and " + connectedPort);
                    }
                    foundOutputPort = connectedPort;
                    inferredRate = newRate;
                }
                DFUtilities.setIfNotDefined(port, "tokenInitProduction", inferredRate);
                if (!this._debugging) continue;
            }
            throw new NotSchedulableException(port, "External port is neither an input and an output, which is not allowed in SDF.");
        }
    }

    protected void _saveFiringCounts(final Map entityToFiringsPerIteration) {
        Director director = (Director)this.getContainer();
        CompositeActor container = (CompositeActor)director.getContainer();
        ChangeRequest request = new ChangeRequest(this, "Record firings per iteration"){

            @Override
            protected void _execute() throws KernelException {
                for (Entity entity : entityToFiringsPerIteration.keySet()) {
                    int firingCount = (Integer)entityToFiringsPerIteration.get(entity);
                    DFUtilities.setOrCreate((NamedObj)entity, "firingsPerIteration", firingCount);
                    if (!BaseSDFScheduler.this._debugging) continue;
                    BaseSDFScheduler.this._debug("Adding firingsPerIteration parameter to " + entity.getName() + " with value " + firingCount);
                }
            }
        };
        request.setPersistent(false);
        container.requestChange(request);
    }
}

