/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.sdf.lib.FIR;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.math.DoubleUnaryOperation;
import ptolemy.math.SignalProcessing;

public class RaisedCosine
extends FIR {
    public Parameter excessBW;
    public Parameter length = new Parameter((NamedObj)this, "length", new IntToken(64));
    public Parameter root;
    public Parameter symbolInterval;

    public RaisedCosine(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.interpolation.setToken(new IntToken(16));
        this.excessBW = new Parameter((NamedObj)this, "excessBW", new DoubleToken(1.0));
        this.root = new Parameter((NamedObj)this, "root", new BooleanToken(false));
        this.symbolInterval = new Parameter((NamedObj)this, "symbolInterval", new IntToken(16));
        this.taps.setVisibility(Settable.NONE);
        this._initialize();
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.excessBW || attribute == this.length || attribute == this.root || attribute == this.symbolInterval) {
            this._initialize();
        } else {
            super.attributeChanged(attribute);
        }
    }

    private void _initialize() throws IllegalActionException {
        double excessBWValue = ((DoubleToken)this.excessBW.getToken()).doubleValue();
        int symbolIntervalValue = ((IntToken)this.symbolInterval.getToken()).intValue();
        int lengthValue = ((IntToken)this.length.getToken()).intValue();
        boolean sqrt = ((BooleanToken)this.root.getToken()).booleanValue();
        if (excessBWValue < 0.0) {
            throw new IllegalActionException((Nameable)this, "Excess bandwidth was " + excessBWValue + " which is not greater than or equal to zero.");
        }
        if (lengthValue <= 0) {
            throw new IllegalActionException((Nameable)this, "Length was " + lengthValue + " which is not greater than zero.");
        }
        double center = (double)lengthValue * 0.5;
        DoubleUnaryOperation raisedCosineSampleGenerator = sqrt ? new SignalProcessing.SqrtRaisedCosineSampleGenerator(symbolIntervalValue, excessBWValue) : new SignalProcessing.RaisedCosineSampleGenerator(symbolIntervalValue, excessBWValue);
        double[] tapsArray = SignalProcessing.sampleWave(lengthValue, -center, 1.0, raisedCosineSampleGenerator);
        Token[] tapsArrayToken = new DoubleToken[tapsArray.length];
        for (int i = 0; i < tapsArray.length; ++i) {
            tapsArrayToken[i] = new DoubleToken(tapsArray[i]);
        }
        this.taps.setToken(new ArrayToken(BaseType.DOUBLE, tapsArrayToken));
    }
}

