/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib.vq;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.math.IntegerMatrixMath;
import ptolemy.util.FileUtilities;

public class HTVQEncode
extends Transformer {
    public Parameter codeBook;
    public Parameter blockCount;
    public Parameter blockWidth;
    public Parameter blockHeight;
    public Parameter input_tokenConsumptionRate;
    public Parameter output_tokenProductionRate;
    private int[][] ipbuf_encodep1 = new int[8][8];
    private int[][] ipbuf_encodep2 = new int[8][8];
    private int[][][] _codeBook = new int[6][256][];
    private int[][] _lookupTable = new int[6][65536];
    private IntToken[] _codewords;
    private Token[] _blocks;
    private int _blockCount;
    private int _blockWidth;
    private int _blockHeight;

    public HTVQEncode(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.INT_MATRIX);
        this.output.setTypeEquals(BaseType.INT);
        this.codeBook = new Parameter((NamedObj)this, "codeBook", new StringToken("/ptolemy/domains/sdf/lib/vq/data/usc_hvq_s5.dat"));
        this.codeBook.setTypeEquals(BaseType.STRING);
        this.blockCount = new Parameter((NamedObj)this, "blockCount", new IntToken("1"));
        this.blockCount.setTypeEquals(BaseType.INT);
        this.blockWidth = new Parameter((NamedObj)this, "blockWidth", new IntToken("4"));
        this.blockWidth.setTypeEquals(BaseType.INT);
        this.blockHeight = new Parameter((NamedObj)this, "blockHeight", new IntToken("2"));
        this.blockHeight.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate = new Parameter(this.input, "tokenConsumptionRate");
        this.input_tokenConsumptionRate.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate.setExpression("blockCount");
        this.output_tokenProductionRate = new Parameter(this.output, "tokenProductionRate");
        this.output_tokenProductionRate.setTypeEquals(BaseType.INT);
        this.output_tokenProductionRate.setExpression("blockCount");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._blocks = this.input.get(0, this._blockCount);
        for (int j = 0; j < this._blockCount; ++j) {
            this._codewords[j] = new IntToken(this._encode(IntegerMatrixMath.fromMatrixToArray(((IntMatrixToken)this._blocks[j]).intMatrix()), this._blockWidth * this._blockHeight));
        }
        this.output.send(0, this._codewords, this._blockCount);
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        InputStream source = null;
        this._blockCount = ((IntToken)this.blockCount.getToken()).intValue();
        this._blockWidth = ((IntToken)this.blockWidth.getToken()).intValue();
        this._blockHeight = ((IntToken)this.blockHeight.getToken()).intValue();
        this._codewords = new IntToken[this._blockCount];
        this._blocks = new Token[this._blockCount];
        String filename = ((StringToken)this.codeBook.getToken()).stringValue();
        try {
            if (filename != null) {
                try {
                    URL dataurl = FileUtilities.nameToURL(filename, null, null);
                    this._debug("HTVQEncode: codebook = " + dataurl);
                    source = dataurl.openStream();
                }
                catch (MalformedURLException e) {
                    System.err.println(e.toString());
                }
                catch (FileNotFoundException e) {
                    System.err.println("HTVQEncode: file not found: " + e);
                }
                catch (IOException e) {
                    throw new IllegalActionException("HTVQEncode: error reading input file: " + e.getMessage());
                }
            }
            int size = 1;
            for (int i = 0; i < 5; ++i) {
                int x;
                byte[] temp = new byte[size *= 2];
                for (int j = 0; j < 256; ++j) {
                    this._codeBook[i][j] = new int[size];
                    if (this._fullRead(source, temp) != size) {
                        throw new IllegalActionException("Error reading codebook file!");
                    }
                    for (x = 0; x < size; ++x) {
                        this._codeBook[i][j][x] = temp[x] & 0xFF;
                    }
                }
                temp = new byte[65536];
                if (this._fullRead(source, temp) != 65536) {
                    throw new IllegalActionException("Error reading codebook file!");
                }
                for (x = 0; x < 65536; ++x) {
                    this._lookupTable[i][x] = temp[x] & 0xFF;
                }
            }
        }
        catch (Throwable throwable) {
            throw new IllegalActionException((Nameable)this, throwable, "Problem reading codebook");
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private int _encode(int[] p, int length) {
        int stage = 0;
        int numberOfStages = this._stages(length);
        if (numberOfStages > 4) {
            throw new RuntimeException("Number of stages = " + numberOfStages + ", which is " + "greater than 4");
        }
        int[][] p5 = this.ipbuf_encodep1;
        int[][] p4 = this.ipbuf_encodep2;
        int[][] p3 = this.ipbuf_encodep1;
        int[][] p2 = this.ipbuf_encodep2;
        int[][] p1 = this.ipbuf_encodep1;
        int[][] p0 = this.ipbuf_encodep2;
        switch (numberOfStages) {
            case 4: {
                System.arraycopy(p, 0, p5[0], 0, 8);
                System.arraycopy(p, 8, p5[1], 0, 8);
                System.arraycopy(p, 16, p5[2], 0, 8);
                System.arraycopy(p, 24, p5[3], 0, 8);
                break;
            }
            case 3: {
                System.arraycopy(p, 0, p4[0], 0, 4);
                System.arraycopy(p, 4, p4[1], 0, 4);
                System.arraycopy(p, 8, p4[2], 0, 4);
                System.arraycopy(p, 12, p4[3], 0, 4);
                break;
            }
            case 2: {
                p3[0][0] = p[0];
                p3[0][1] = p[1];
                p3[0][2] = p[2];
                p3[0][3] = p[3];
                p3[1][0] = p[4];
                p3[1][1] = p[5];
                p3[1][2] = p[6];
                p3[1][3] = p[7];
                break;
            }
            case 1: {
                p2[0][0] = p[0];
                p2[0][1] = p[1];
                p2[1][0] = p[2];
                p2[1][1] = p[3];
                break;
            }
            case 0: {
                p1[0][0] = p[0];
                p1[0][1] = p[1];
            }
        }
        switch (numberOfStages) {
            case 4: {
                int ip = ((p5[0][0] & 0xFF) << 8) + (p5[0][1] & 0xFF);
                p4[0][0] = this._lookupTable[stage][ip];
                ip = ((p5[0][2] & 0xFF) << 8) + (p5[0][3] & 0xFF);
                p4[1][0] = this._lookupTable[stage][ip];
                ip = ((p5[0][4] & 0xFF) << 8) + (p5[0][5] & 0xFF);
                p4[2][0] = this._lookupTable[stage][ip];
                ip = ((p5[0][6] & 0xFF) << 8) + (p5[0][7] & 0xFF);
                p4[3][0] = this._lookupTable[stage][ip];
                ip = ((p5[1][0] & 0xFF) << 8) + (p5[1][1] & 0xFF);
                p4[0][1] = this._lookupTable[stage][ip];
                ip = ((p5[1][2] & 0xFF) << 8) + (p5[1][3] & 0xFF);
                p4[1][1] = this._lookupTable[stage][ip];
                ip = ((p5[1][4] & 0xFF) << 8) + (p5[1][5] & 0xFF);
                p4[2][1] = this._lookupTable[stage][ip];
                ip = ((p5[1][6] & 0xFF) << 8) + (p5[1][7] & 0xFF);
                p4[3][1] = this._lookupTable[stage][ip];
                ip = ((p5[2][0] & 0xFF) << 8) + (p5[2][1] & 0xFF);
                p4[0][2] = this._lookupTable[stage][ip];
                ip = ((p5[2][2] & 0xFF) << 8) + (p5[2][3] & 0xFF);
                p4[1][2] = this._lookupTable[stage][ip];
                ip = ((p5[2][4] & 0xFF) << 8) + (p5[2][5] & 0xFF);
                p4[2][2] = this._lookupTable[stage][ip];
                ip = ((p5[2][6] & 0xFF) << 8) + (p5[2][7] & 0xFF);
                p4[3][2] = this._lookupTable[stage][ip];
                ip = ((p5[3][0] & 0xFF) << 8) + (p5[3][1] & 0xFF);
                p4[0][3] = this._lookupTable[stage][ip];
                ip = ((p5[3][2] & 0xFF) << 8) + (p5[3][2] & 0xFF);
                p4[1][3] = this._lookupTable[stage][ip];
                ip = ((p5[3][4] & 0xFF) << 8) + (p5[3][4] & 0xFF);
                p4[2][3] = this._lookupTable[stage][ip];
                ip = ((p5[3][6] & 0xFF) << 8) + (p5[3][6] & 0xFF);
                p4[3][3] = this._lookupTable[stage][ip];
                ++stage;
            }
            case 3: {
                int ip = ((p4[0][1] & 0xFF) << 8) + (p4[0][0] & 0xFF);
                p3[0][0] = this._lookupTable[stage][ip];
                ip = ((p4[0][3] & 0xFF) << 8) + (p4[0][2] & 0xFF);
                p3[1][0] = this._lookupTable[stage][ip];
                ip = ((p4[1][1] & 0xFF) << 8) + (p4[1][0] & 0xFF);
                p3[0][1] = this._lookupTable[stage][ip];
                ip = ((p4[1][3] & 0xFF) << 8) + (p4[1][2] & 0xFF);
                p3[1][1] = this._lookupTable[stage][ip];
                ip = ((p4[2][1] & 0xFF) << 8) + (p4[2][0] & 0xFF);
                p3[0][2] = this._lookupTable[stage][ip];
                ip = ((p4[2][3] & 0xFF) << 8) + (p4[2][2] & 0xFF);
                p3[1][2] = this._lookupTable[stage][ip];
                ip = ((p4[3][1] & 0xFF) << 8) + (p4[3][0] & 0xFF);
                p3[0][3] = this._lookupTable[stage][ip];
                ip = ((p4[3][3] & 0xFF) << 8) + (p4[3][2] & 0xFF);
                p3[1][3] = this._lookupTable[stage][ip];
                ++stage;
            }
            case 2: {
                int ip = ((p3[0][1] & 0xFF) << 8) + (p3[0][0] & 0xFF);
                p2[0][0] = this._lookupTable[stage][ip];
                ip = ((p3[0][3] & 0xFF) << 8) + (p3[0][2] & 0xFF);
                p2[1][0] = this._lookupTable[stage][ip];
                ip = ((p3[1][1] & 0xFF) << 8) + (p3[1][0] & 0xFF);
                p2[0][1] = this._lookupTable[stage][ip];
                ip = ((p3[1][3] & 0xFF) << 8) + (p3[1][2] & 0xFF);
                p2[1][1] = this._lookupTable[stage][ip];
                ++stage;
            }
            case 1: {
                int ip = ((p2[0][1] & 0xFF) << 8) + (p2[0][0] & 0xFF);
                p1[0][0] = this._lookupTable[stage][ip];
                ip = ((p2[1][1] & 0xFF) << 8) + (p2[1][0] & 0xFF);
                p1[0][1] = this._lookupTable[stage][ip];
                ++stage;
            }
            case 0: {
                int ip = ((p1[0][1] & 0xFF) << 8) + (p1[0][0] & 0xFF);
                p0[0][0] = this._lookupTable[stage][ip];
                ++stage;
            }
        }
        return p0[0][0];
    }

    private int _fullRead(InputStream s, byte[] b) throws IOException {
        int length = 0;
        int remaining = b.length;
        int bytesRead = 0;
        while (remaining > 0) {
            bytesRead = s.read(b, length, remaining);
            if (bytesRead == -1) {
                throw new IOException("Unexpected EOF");
            }
            remaining -= bytesRead;
            length += bytesRead;
        }
        return length;
    }

    private int _stages(int length) {
        int x = 0;
        if (length < 2) {
            throw new RuntimeException("Vector length of " + length + "must be greater than 1");
        }
        while (length > 2) {
            length >>= 1;
            ++x;
        }
        return x;
    }
}

