/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.graph.DirectedAcyclicGraph;
import ptolemy.graph.Edge;
import ptolemy.graph.Graph;
import ptolemy.graph.GraphActionException;
import ptolemy.graph.GraphException;
import ptolemy.graph.GraphStateException;
import ptolemy.graph.GraphTopologyException;
import ptolemy.graph.GraphWeightException;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.CycleExistenceAnalysis;
import ptolemy.graph.analysis.SinkNodeAnalysis;
import ptolemy.graph.analysis.SourceNodeAnalysis;
import ptolemy.graph.analysis.TransitiveClosureAnalysis;

public class DirectedGraph
extends Graph {
    private HashMap _inputEdgeMap;
    private HashMap _outputEdgeMap;
    private CycleExistenceAnalysis _acyclicAnalysis;
    private TransitiveClosureAnalysis _transitiveClosureAnalysis;
    private SinkNodeAnalysis _sinkNodeAnalysis;
    private SourceNodeAnalysis _sourceNodeAnalysis;

    public DirectedGraph() {
        this._inputEdgeMap = new HashMap();
        this._outputEdgeMap = new HashMap();
    }

    public DirectedGraph(int nodeCount) {
        super(nodeCount);
        this._inputEdgeMap = new HashMap(nodeCount);
        this._outputEdgeMap = new HashMap(nodeCount);
    }

    public DirectedGraph(int nodeCount, int edgeCount) {
        super(nodeCount, edgeCount);
        this._inputEdgeMap = new HashMap(nodeCount);
        this._outputEdgeMap = new HashMap(nodeCount);
    }

    public Collection backwardReachableNodes(Node node) {
        boolean[][] transitiveClosure = this.transitiveClosure();
        int nodeLabel = this.nodeLabel(node);
        ArrayList<Node> nodes = new ArrayList<Node>(transitiveClosure.length);
        for (Node next : this.nodes()) {
            if (!transitiveClosure[this.nodeLabel(next)][nodeLabel]) continue;
            nodes.add(next);
        }
        return nodes;
    }

    public Object[] backwardReachableNodes(Object weight) {
        Collection sameWeightNodes = this.nodes(weight);
        if (sameWeightNodes.size() == 0) {
            throw new GraphWeightException(weight, null, this, "The specified weight is not a node weight in this graph.");
        }
        return DirectedGraph.weightArray(this.backwardReachableNodes(sameWeightNodes));
    }

    public Collection backwardReachableNodes(Collection nodeCollection) {
        boolean[][] transitiveClosure = this.transitiveClosure();
        ArrayList<Node> reachableNodes = new ArrayList<Node>(transitiveClosure.length);
        for (Node nextGraphNode : this.nodes()) {
            int nextLabel = this.nodeLabel(nextGraphNode);
            boolean reachable = false;
            for (Node nextNode : nodeCollection) {
                if (!transitiveClosure[nextLabel][this.nodeLabel(nextNode)]) continue;
                reachable = true;
                break;
            }
            if (!reachable) continue;
            reachableNodes.add(nextGraphNode);
        }
        return reachableNodes;
    }

    public Object[] backwardReachableNodes(Object[] weights) {
        return DirectedGraph.weightArray(this.backwardReachableNodes(this.nodes(Arrays.asList(weights))));
    }

    public Collection cycleNodeCollection() {
        boolean[][] transitiveClosure = this.transitiveClosure();
        ArrayList<Node> result = new ArrayList<Node>(transitiveClosure.length);
        for (Node next : this.nodes()) {
            int label = this.nodeLabel(next);
            if (!transitiveClosure[label][label]) continue;
            result.add(next);
        }
        return result;
    }

    public Object[] cycleNodes() {
        return DirectedGraph.weightArray(this.cycleNodeCollection());
    }

    public boolean edgeExists(Node node1, Node node2) {
        Iterator outputEdges = this.outputEdges(node1).iterator();
        while (outputEdges.hasNext()) {
            if (((Edge)outputEdges.next()).sink() != node2) continue;
            return true;
        }
        return false;
    }

    public boolean edgeExists(Object weight1, Object weight2) {
        for (Node candidateSource : this.nodes(weight1)) {
            for (Node candidateSink : this.nodes(weight2)) {
                if (!this.edgeExists(candidateSource, candidateSink)) continue;
                return true;
            }
        }
        return false;
    }

    public int inputEdgeCount(Node node) {
        return this._inputEdgeList(node).size();
    }

    public Collection inputEdges(Node node) {
        return Collections.unmodifiableList(this._inputEdgeList(node));
    }

    public boolean isAcyclic() {
        return !this._acyclicAnalysis.hasCycle();
    }

    public int outputEdgeCount(Node node) {
        return this._outputEdgeList(node).size();
    }

    public Collection outputEdges(Node node) {
        return Collections.unmodifiableList(this._outputEdgeList(node));
    }

    public Collection predecessorEdges(Node n1, Node n2) {
        Collection edgeCollection = this.outputEdges(n2);
        Iterator edges = edgeCollection.iterator();
        ArrayList<Edge> commonEdges = new ArrayList<Edge>();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            if (edge.sink() != n1) continue;
            commonEdges.add(edge);
        }
        return commonEdges;
    }

    public Collection predecessors(Node node) {
        Collection inputEdgeCollection = this.inputEdges(node);
        Iterator inputEdges = inputEdgeCollection.iterator();
        ArrayList<Node> result = new ArrayList<Node>(inputEdgeCollection.size());
        while (inputEdges.hasNext()) {
            Node source = ((Edge)inputEdges.next()).source();
            if (result.contains(source)) continue;
            result.add(source);
        }
        return result;
    }

    public Collection reachableNodes(Node node) {
        boolean[][] transitiveClosure = this.transitiveClosure();
        int label = this.nodeLabel(node);
        ArrayList<Node> result = new ArrayList<Node>(transitiveClosure.length);
        for (Node next : this.nodes()) {
            if (!transitiveClosure[label][this.nodeLabel(next)]) continue;
            result.add(next);
        }
        return result;
    }

    public Object[] reachableNodes(Object weight) {
        Collection sameWeightNodes = this.nodes(weight);
        if (sameWeightNodes.size() == 0) {
            throw new GraphWeightException(weight, null, this, "The specified weight is not a node weight in this graph.");
        }
        return DirectedGraph.weightArray(this.reachableNodes(sameWeightNodes));
    }

    public Object[] reachableNodes(Object[] weights) {
        return DirectedGraph.weightArray(this.reachableNodes(this.nodes(Arrays.asList(weights))));
    }

    public Collection reachableNodes(Collection nodeCollection) {
        boolean[][] transitiveClosure = this.transitiveClosure();
        int N = nodeCollection.size();
        int[] labels = new int[N];
        Iterator nodes = nodeCollection.iterator();
        for (int i = 0; i < N; ++i) {
            labels[i] = this.nodeLabel((Node)nodes.next());
        }
        ArrayList<Node> reachableNodes = new ArrayList<Node>(transitiveClosure.length);
        for (Node nextGraphNode : this.nodes()) {
            int nextGraphLabel = this.nodeLabel(nextGraphNode);
            boolean reachable = false;
            for (int i = 0; i < N; ++i) {
                if (!transitiveClosure[labels[i]][nextGraphLabel]) continue;
                reachable = true;
                break;
            }
            if (!reachable) continue;
            reachableNodes.add(nextGraphNode);
        }
        return reachableNodes;
    }

    public DirectedGraph[] sccDecomposition() {
        List sortedSCCRepresentatives;
        int N;
        boolean[][] transitiveClosure = this.transitiveClosure();
        if (transitiveClosure.length != (N = this.nodeCount())) {
            throw new GraphStateException("Graph inconsistency. A dump of the graph follows.\n" + this);
        }
        boolean[] addedToAnSCC = new boolean[N];
        for (int i = 0; i < N; ++i) {
            addedToAnSCC[i] = false;
        }
        ArrayList sccNodeLists = new ArrayList();
        ArrayList<Node> sccRepresentatives = new ArrayList<Node>();
        for (int i = 0; i < N; ++i) {
            if (addedToAnSCC[i]) continue;
            ArrayList<Node> nodeList = new ArrayList<Node>();
            sccNodeLists.add(nodeList);
            Node node = this.node(i);
            nodeList.add(node);
            sccRepresentatives.add(node);
            addedToAnSCC[i] = true;
            for (int j = i + 1; j < N; ++j) {
                if (addedToAnSCC[j] || !transitiveClosure[i][j] || !transitiveClosure[j][i]) continue;
                nodeList.add(this.node(j));
                addedToAnSCC[j] = true;
            }
        }
        int numberOfSCCs = sccNodeLists.size();
        try {
            sortedSCCRepresentatives = this.topologicalSort(sccRepresentatives);
        }
        catch (GraphActionException ex) {
            throw new GraphStateException("nodes in different SCCs were found to be strongly connected.");
        }
        ArrayList<ArrayList> sortedSCCNodeLists = new ArrayList<ArrayList>();
        Iterator representatives = sortedSCCRepresentatives.iterator();
        for (int i = 0; i < numberOfSCCs; ++i) {
            Node sccRepresentative = (Node)representatives.next();
            for (int j = 0; j < numberOfSCCs; ++j) {
                ArrayList nodeList = (ArrayList)sccNodeLists.get(j);
                if (nodeList.get(0) != sccRepresentative) continue;
                sortedSCCNodeLists.add(nodeList);
            }
        }
        DirectedGraph[] sccs = new DirectedGraph[numberOfSCCs];
        for (int i = 0; i < numberOfSCCs; ++i) {
            ArrayList nodeList = (ArrayList)sortedSCCNodeLists.get(i);
            sccs[i] = (DirectedGraph)this.subgraph(nodeList);
        }
        return sccs;
    }

    @Override
    public int selfLoopEdgeCount(Node node) {
        return this.inputEdgeCount(node) + this.outputEdgeCount(node) - this.incidentEdgeCount(node);
    }

    public int sinkNodeCount() {
        return this.sinkNodes().size();
    }

    public Collection sinkNodes() {
        return this._sinkNodeAnalysis.nodes();
    }

    public int sourceNodeCount() {
        return this.sourceNodes().size();
    }

    public Collection sourceNodes() {
        return this._sourceNodeAnalysis.nodes();
    }

    public LinkedList subgraphs() {
        LinkedList<DirectedGraph> subgraphList = new LinkedList<DirectedGraph>();
        LinkedList remainingNodes = new LinkedList(this.nodes());
        while (!remainingNodes.isEmpty()) {
            DirectedGraph subgraph = new DirectedGraph();
            Node node = (Node)remainingNodes.remove(0);
            this._connectedSubGraph(node, subgraph, remainingNodes);
            subgraphList.add(subgraph);
        }
        return subgraphList;
    }

    public Collection successorEdges(Node n1, Node n2) {
        return this.predecessorEdges(n2, n1);
    }

    public Collection successors(Node node) {
        Collection outputEdgeCollection = this.outputEdges(node);
        Iterator outputEdges = outputEdgeCollection.iterator();
        ArrayList<Node> result = new ArrayList<Node>(outputEdgeCollection.size());
        while (outputEdges.hasNext()) {
            Node sink = ((Edge)outputEdges.next()).sink();
            if (result.contains(sink)) continue;
            result.add(sink);
        }
        return result;
    }

    public DirectedAcyclicGraph toDirectedAcyclicGraph() {
        if (!this.isAcyclic()) {
            throw new GraphTopologyException("This graph is not acyclic." + GraphException.graphDump(this));
        }
        DirectedAcyclicGraph acyclicGraph = (DirectedAcyclicGraph)this.cloneAs(new DirectedAcyclicGraph());
        return acyclicGraph;
    }

    public List topologicalSort(Collection nodeCollection) throws GraphActionException {
        boolean[][] transitiveClosure = this.transitiveClosure();
        int N = nodeCollection.size();
        Node[] nodeArray = new Node[N];
        Iterator nodes = nodeCollection.iterator();
        int i = 0;
        while (nodes.hasNext()) {
            nodeArray[i++] = (Node)nodes.next();
        }
        for (i = 0; i < N - 1; ++i) {
            for (int j = i + 1; j < N; ++j) {
                int label1 = this.nodeLabel(nodeArray[i]);
                int label2 = this.nodeLabel(nodeArray[j]);
                if (!transitiveClosure[label2][label1]) continue;
                if (transitiveClosure[label1][label2]) {
                    throw new GraphActionException("Attempted to topologically sort cyclic nodes.");
                }
                Node node = nodeArray[i];
                nodeArray[i] = nodeArray[j];
                nodeArray[j] = node;
            }
        }
        return new ArrayList<Node>(Arrays.asList(nodeArray));
    }

    public Object[] topologicalSort(Object[] weights) throws GraphActionException {
        return DirectedGraph.weightArray(this.topologicalSort(this.nodes(Arrays.asList(weights))));
    }

    public boolean[][] transitiveClosure() {
        return this._transitiveClosureAnalysis.transitiveClosureMatrix();
    }

    @Override
    protected void _connect(Edge edge, Node node) {
        super._connect(edge, node);
        if (edge.source() == node) {
            this._outputEdgeList(node).add(edge);
        }
        if (edge.sink() == node) {
            this._inputEdgeList(node).add(edge);
        }
    }

    protected void _connectedSubGraph(Node node, DirectedGraph graph, Collection remainingNodes) {
        if (!graph.containsNode(node)) {
            graph.addNode(node);
            remainingNodes.remove(node);
        }
        for (Edge inputEdge : this.inputEdges(node)) {
            if (graph.containsEdge(inputEdge)) continue;
            Node sourceNode = inputEdge.source();
            if (!graph.containsNode(sourceNode)) {
                graph.addNode(sourceNode);
                this._connectedSubGraph(sourceNode, graph, remainingNodes);
                remainingNodes.remove(sourceNode);
            }
            if (graph.containsEdge(inputEdge)) continue;
            graph.addEdge(sourceNode, node);
        }
        for (Edge outputEdge : this.outputEdges(node)) {
            if (graph.containsEdge(outputEdge)) continue;
            Node sinkNode = outputEdge.sink();
            if (!graph.containsNode(sinkNode)) {
                graph.addNode(sinkNode);
                this._connectedSubGraph(sinkNode, graph, remainingNodes);
                remainingNodes.remove(sinkNode);
            }
            if (graph.containsEdge(outputEdge)) continue;
            graph.addEdge(node, sinkNode);
        }
    }

    @Override
    protected void _disconnect(Edge edge, Node node) {
        super._disconnect(edge, node);
        this._removeIfPresent(this._inputEdgeList(node), edge);
        this._removeIfPresent(this._outputEdgeList(node), edge);
    }

    @Override
    protected void _initializeAnalyses() {
        super._initializeAnalyses();
        this._transitiveClosureAnalysis = new TransitiveClosureAnalysis(this);
        this._acyclicAnalysis = new CycleExistenceAnalysis(this);
        this._sinkNodeAnalysis = new SinkNodeAnalysis(this);
        this._sourceNodeAnalysis = new SourceNodeAnalysis(this);
    }

    @Override
    protected void _registerNode(Node node) {
        super._registerNode(node);
        this._inputEdgeMap.put(node, new ArrayList());
        this._outputEdgeMap.put(node, new ArrayList());
    }

    private ArrayList _inputEdgeList(Node node) {
        return (ArrayList)this._inputEdgeMap.get(node);
    }

    private ArrayList _outputEdgeList(Node node) {
        return (ArrayList)this._outputEdgeMap.get(node);
    }

    private void _removeIfPresent(ArrayList list, Object element) {
        int index = list.indexOf(element);
        if (index != -1) {
            list.remove(index);
        }
    }
}

