/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import java.util.Iterator;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Edge;
import ptolemy.graph.Graph;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.analyzer.TransitiveClosureAnalyzer;
import ptolemy.graph.analysis.strategy.FloydWarshallStrategy;

public class FloydWarshallTransitiveClosureStrategy
extends FloydWarshallStrategy
implements TransitiveClosureAnalyzer {
    private boolean[][] _transitiveClosure;

    public FloydWarshallTransitiveClosureStrategy(Graph graph) {
        super(graph);
    }

    @Override
    public boolean pathExistence(Node startNode, Node endNode) {
        return this._transitiveClosure[this.graph().nodeLabel(startNode)][this.graph().nodeLabel(endNode)];
    }

    @Override
    public String toString() {
        return "Transitive closure analyzer based on the Floyd-Warshall algorithm.";
    }

    @Override
    public boolean[][] transitiveClosureMatrix() {
        return (boolean[][])this._result();
    }

    @Override
    public boolean valid() {
        return this.graph() instanceof DirectedGraph;
    }

    @Override
    protected Object _compute() {
        int size = this.graph().nodeCount();
        this._transitiveClosure = new boolean[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this._transitiveClosure[i][j] = false;
            }
            Node node = this.graph().node(i);
            Iterator outputEdges = ((DirectedGraph)this.graph()).outputEdges(node).iterator();
            while (outputEdges.hasNext()) {
                int sinkLabel = ((DirectedGraph)this.graph()).nodeLabel(((Edge)outputEdges.next()).sink());
                this._transitiveClosure[i][sinkLabel] = true;
            }
        }
        super._compute();
        return this._transitiveClosure;
    }

    @Override
    protected void _floydWarshallComputation(int k, int i, int j) {
        boolean[] blArray = this._transitiveClosure[i];
        int n = j;
        blArray[n] = blArray[n] | this._transitiveClosure[i][k] & this._transitiveClosure[k][j];
    }
}

