/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class KernelException
extends Exception {
    private String _message;
    private Nameable _object1;
    private Nameable _object2;
    private Throwable _cause;

    public KernelException() {
        this(null, null, null, null);
    }

    public KernelException(Nameable object1, Nameable object2, String detail) {
        this(object1, object2, null, detail);
    }

    public KernelException(Nameable object1, Nameable object2, Throwable cause, String detail) {
        this._object1 = object1;
        this._object2 = object2;
        this._setMessage(KernelException.generateMessage(object1, object2, cause, detail));
        this._setCause(cause);
    }

    public static String generateMessage(Nameable object1, Nameable object2, Throwable cause, String detail) {
        String object1String = KernelException.getFullName(object1);
        String object2String = KernelException.getFullName(object2);
        String whereString = null;
        if (!object1String.equals("")) {
            whereString = !object2String.equals("") ? "  in " + object1String + " and " + object2String : "  in " + object1String;
        } else if (!object2String.equals("")) {
            whereString = "  in " + object2String;
        }
        return KernelException.generateMessage(whereString, cause, detail);
    }

    public static String generateMessage(Collection objects, Throwable cause, String detail) {
        StringBuffer prefixBuffer = new StringBuffer("  in ");
        Iterator objectIterator = objects.iterator();
        while (objectIterator.hasNext()) {
            Object object = objectIterator.next();
            if (object instanceof Nameable) {
                prefixBuffer.append(KernelException.getFullName((Nameable)object));
            } else {
                prefixBuffer.append("<Object of class " + object.getClass().getName() + ">");
            }
            if (!objectIterator.hasNext()) continue;
            prefixBuffer.append(", ");
        }
        return KernelException.generateMessage(prefixBuffer.toString(), cause, detail);
    }

    public static String generateMessage(String whereString, Throwable cause, String detail) {
        boolean whereNullOrEmpty = whereString == null || whereString.equals("");
        boolean detailNullOrEmpty = detail == null || detail.equals("");
        return (detailNullOrEmpty ? "" : detail) + (!whereNullOrEmpty && !detailNullOrEmpty ? "\n" : "") + (whereNullOrEmpty ? "" : whereString) + ((!whereNullOrEmpty || !detailNullOrEmpty) && cause != null ? "\n" : "") + (cause == null ? "" : "Because:\n" + (cause.getMessage() != null ? cause.getMessage() : cause.toString()));
    }

    @Override
    public Throwable getCause() {
        return this._cause;
    }

    public static String getFullName(Nameable object) {
        NamedObj container;
        if (object == null) {
            return "";
        }
        String name = KernelException.getName(object);
        try {
            object.getFullName();
        }
        catch (InvalidStateException ex) {
            return name;
        }
        if (container == null) {
            return "." + name;
        }
        for (container = object.getContainer(); container != null; container = container.getContainer()) {
            name = KernelException.getName(container) + "." + name;
        }
        name = "." + name;
        return name;
    }

    @Override
    public String getMessage() {
        return this._message;
    }

    public static String getName(Nameable object) {
        if (object == null) {
            return "";
        }
        String name = object.getName();
        if (name == null || name.equals("")) {
            return "<Unnamed Object>";
        }
        return name;
    }

    public Nameable getNameable1() {
        return this._object1;
    }

    public Nameable getNameable2() {
        return this._object2;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err));
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this._cause != null) {
            printWriter.print("Caused by: ");
            this._cause.printStackTrace(printWriter);
        }
        printWriter.flush();
    }

    public static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    protected void _setCause(Throwable cause) {
        this._cause = cause;
    }

    protected void _setMessage(String message) {
        this._message = message == null ? "" : message;
    }
}

