/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.FloatArrayMath;
import ptolemy.math.FloatBinaryOperation;
import ptolemy.math.FloatUnaryOperation;

public class FloatMatrixMath {
    private FloatMatrixMath() {
    }

    public static final float[][] add(float[][] matrix, float z) {
        float[][] returnValue = new float[FloatMatrixMath._rows(matrix)][FloatMatrixMath._columns(matrix)];
        for (int i = 0; i < FloatMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < FloatMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j] + z;
            }
        }
        return returnValue;
    }

    public static final float[][] add(float[][] matrix1, float[][] matrix2) {
        FloatMatrixMath._checkSameDimension("add", matrix1, matrix2);
        float[][] returnValue = new float[FloatMatrixMath._rows(matrix1)][FloatMatrixMath._columns(matrix1)];
        for (int i = 0; i < FloatMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < FloatMatrixMath._columns(matrix1); ++j) {
                returnValue[i][j] = matrix1[i][j] + matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final float[][] allocCopy(float[][] matrix) {
        return FloatMatrixMath.crop(matrix, 0, 0, FloatMatrixMath._rows(matrix), FloatMatrixMath._columns(matrix));
    }

    public static final float[][] applyBinaryOperation(FloatBinaryOperation op, float z, float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(z, matrix[i][j]);
            }
        }
        return returnValue;
    }

    public static final float[][] applyBinaryOperation(FloatBinaryOperation op, float[][] matrix, float z) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix[i][j], z);
            }
        }
        return returnValue;
    }

    public static final float[][] applyBinaryOperation(FloatBinaryOperation op, float[][] matrix1, float[][] matrix2) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        FloatMatrixMath._checkSameDimension("applyBinaryOperation", matrix1, matrix2);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix1[i][j], matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final float[][] applyUnaryOperation(FloatUnaryOperation op, float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix[i][j]);
            }
        }
        return returnValue;
    }

    public static final float[][] crop(float[][] matrix, int rowStart, int colStart, int rowSpan, int colSpan) {
        float[][] returnValue = new float[rowSpan][colSpan];
        for (int i = 0; i < rowSpan; ++i) {
            System.arraycopy(matrix[rowStart + i], colStart, returnValue[i], 0, colSpan);
        }
        return returnValue;
    }

    public static final float determinant(float[][] matrix) {
        FloatMatrixMath._checkSquare("determinant", matrix);
        float det = 1.0f;
        int n = FloatMatrixMath._rows(matrix);
        float[][] a = FloatMatrixMath.allocCopy(matrix);
        for (int pivot = 0; pivot < n - 1; ++pivot) {
            float big = Math.abs(a[pivot][pivot]);
            int swapRow = 0;
            for (int row = pivot + 1; row < n; ++row) {
                float absElement = Math.abs(a[row][pivot]);
                if (!(absElement > big)) continue;
                swapRow = row;
                big = absElement;
            }
            if (swapRow != 0) {
                float[] aPtr = a[pivot];
                a[pivot] = a[swapRow];
                a[swapRow] = aPtr;
                det *= -a[pivot][pivot];
            } else {
                det *= a[pivot][pivot];
            }
            if (Math.abs(det) <= 1.0E-12f) {
                return det;
            }
            float pivotInverse = 1.0f / a[pivot][pivot];
            int col = pivot + 1;
            while (col < n) {
                float[] fArray = a[pivot];
                int n2 = col++;
                fArray[n2] = fArray[n2] * pivotInverse;
            }
            for (int row = pivot + 1; row < n; ++row) {
                float temp = a[row][pivot];
                for (int col2 = pivot + 1; col2 < n; ++col2) {
                    float[] fArray = a[row];
                    int n3 = col2;
                    fArray[n3] = fArray[n3] - a[pivot][col2] * temp;
                }
            }
        }
        return det *= a[n - 1][n - 1];
    }

    public static final float[][] diag(float[] array) {
        int n = array.length;
        float[][] returnValue = new float[n][n];
        for (int i = 0; i < n; ++i) {
            returnValue[i][i] = array[i];
        }
        return returnValue;
    }

    public static final float[][] divide(float[][] matrix, float z) {
        float[][] returnValue = new float[FloatMatrixMath._rows(matrix)][FloatMatrixMath._columns(matrix)];
        for (int i = 0; i < FloatMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < FloatMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j] / z;
            }
        }
        return returnValue;
    }

    public static final float[][] divideElements(float[][] matrix1, float[][] matrix2) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        FloatMatrixMath._checkSameDimension("divideElements", matrix1, matrix2);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] / matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final float[] fromMatrixToArray(float[][] matrix) {
        return FloatMatrixMath.fromMatrixToArray(matrix, FloatMatrixMath._rows(matrix), FloatMatrixMath._columns(matrix));
    }

    public static final float[] fromMatrixToArray(float[][] matrix, int maxRow, int maxCol) {
        float[] returnValue = new float[maxRow * maxCol];
        for (int i = 0; i < maxRow; ++i) {
            System.arraycopy(matrix[i], 0, returnValue, i * maxCol, maxCol);
        }
        return returnValue;
    }

    public static final float[][] hilbert(int dim) {
        float[][] returnValue = new float[dim][dim];
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                returnValue[i][j] = 1.0f / (float)(i + j + 1);
            }
        }
        return returnValue;
    }

    public static final float[][] identity(int dim) {
        float[][] returnValue = new float[dim][dim];
        for (int i = 0; i < dim; ++i) {
            returnValue[i][i] = 1.0f;
        }
        return returnValue;
    }

    public static final float[][] inverse(float[][] A) {
        FloatMatrixMath._checkSquare("inverse", A);
        int n = FloatMatrixMath._rows(A);
        float[][] Ai = FloatMatrixMath.allocCopy(A);
        int[] pivotFlag = new int[n];
        int[] swapCol = new int[n];
        int[] swapRow = new int[n];
        int irow = 0;
        int icol = 0;
        for (int i = 0; i < n; ++i) {
            int col;
            float big = 0.0f;
            for (int row = 0; row < n; ++row) {
                if (pivotFlag[row] != 0) continue;
                for (col = 0; col < n; ++col) {
                    float absElement;
                    if (pivotFlag[col] != 0 || !((absElement = Math.abs(Ai[row][col])) >= big)) continue;
                    big = absElement;
                    irow = row;
                    icol = col;
                }
            }
            int n2 = icol;
            pivotFlag[n2] = pivotFlag[n2] + 1;
            if (irow != icol) {
                for (int col2 = 0; col2 < n; ++col2) {
                    float temp = Ai[irow][col2];
                    Ai[irow][col2] = Ai[icol][col2];
                    Ai[icol][col2] = temp;
                }
            }
            swapRow[i] = irow;
            swapCol[i] = icol;
            if (Ai[icol][icol] == 0.0f) {
                return null;
            }
            float pivotInverse = 1.0f / Ai[icol][icol];
            Ai[icol][icol] = 1.0f;
            col = 0;
            while (col < n) {
                float[] fArray = Ai[icol];
                int n3 = col++;
                fArray[n3] = fArray[n3] * pivotInverse;
            }
            for (int row = 0; row < n; ++row) {
                if (row == icol) continue;
                float temp = Ai[row][icol];
                Ai[row][icol] = 0.0f;
                for (int col3 = 0; col3 < n; ++col3) {
                    float[] fArray = Ai[row];
                    int n4 = col3;
                    fArray[n4] = fArray[n4] - Ai[icol][col3] * temp;
                }
            }
        }
        for (int swap = n - 1; swap >= 0; --swap) {
            if (swapRow[swap] == swapCol[swap]) continue;
            for (int row = 0; row < n; ++row) {
                float temp = Ai[row][swapRow[swap]];
                Ai[row][swapRow[swap]] = Ai[row][swapCol[swap]];
                Ai[row][swapCol[swap]] = temp;
            }
        }
        return Ai;
    }

    public static final void matrixCopy(float[][] srcMatrix, float[][] destMatrix) {
        FloatMatrixMath.matrixCopy(srcMatrix, 0, 0, destMatrix, 0, 0, FloatMatrixMath._rows(srcMatrix), FloatMatrixMath._columns(srcMatrix));
    }

    public static final void matrixCopy(float[][] srcMatrix, int srcRowStart, int srcColStart, float[][] destMatrix, int destRowStart, int destColStart, int rowSpan, int colSpan) {
        for (int i = 0; i < rowSpan; ++i) {
            System.arraycopy(srcMatrix[srcRowStart + i], srcColStart, destMatrix[destRowStart + i], destColStart, colSpan);
        }
    }

    public static final float[][] multiply(float[][] matrix, float scaleFactor) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j] * scaleFactor;
            }
        }
        return returnValue;
    }

    public static final float[] multiply(float[][] matrix, float[] array) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        if (rows != array.length) {
            throw new IllegalArgumentException("preMultiply : array does not have the same number of elements (" + array.length + ") as the number of rows " + "of the matrix (" + rows + ")");
        }
        float[] returnValue = new float[columns];
        for (int i = 0; i < columns; ++i) {
            float sum = 0.0f;
            for (int j = 0; j < rows; ++j) {
                sum += matrix[j][i] * array[j];
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final float[] multiply(float[] array, float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        if (columns != array.length) {
            throw new IllegalArgumentException("postMultiply() : array does not have the same number of elements (" + array.length + ") as the number of " + "columns of the matrix (" + columns + ")");
        }
        float[] returnValue = new float[rows];
        for (int i = 0; i < rows; ++i) {
            float sum = 0.0f;
            for (int j = 0; j < columns; ++j) {
                sum += matrix[i][j] * array[j];
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final float[][] multiply(float[][] matrix1, float[][] matrix2) {
        float[][] returnValue = new float[FloatMatrixMath._rows(matrix1)][matrix2[0].length];
        for (int i = 0; i < FloatMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < matrix2[0].length; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < matrix2.length; ++k) {
                    sum += matrix1[i][k] * matrix2[k][j];
                }
                returnValue[i][j] = sum;
            }
        }
        return returnValue;
    }

    public static final float[][] multiplyElements(float[][] matrix1, float[][] matrix2) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        FloatMatrixMath._checkSameDimension("multiplyElements", matrix1, matrix2);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] * matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final float[][] negative(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = -matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final float[][] orthogonalizeColumns(float[][] matrix) {
        Object[] orthoInfo = FloatMatrixMath._orthogonalizeRows(FloatMatrixMath.transpose(matrix));
        return FloatMatrixMath.transpose((float[][])orthoInfo[0]);
    }

    public static final float[][] orthogonalizeRows(float[][] matrix) {
        Object[] orthoInfo = FloatMatrixMath._orthogonalizeRows(matrix);
        return (float[][])orthoInfo[0];
    }

    public static final float[][] orthonormalizeColumns(float[][] matrix) {
        return FloatMatrixMath.transpose(FloatMatrixMath.orthogonalizeRows(FloatMatrixMath.transpose(matrix)));
    }

    public static final float[][] orthonormalizeRows(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        Object[] orthoInfo = FloatMatrixMath._orthogonalizeRows(matrix);
        float[][] orthogonalMatrix = (float[][])orthoInfo[0];
        float[] oneOverNormSquaredArray = (float[])orthoInfo[2];
        for (int i = 0; i < rows; ++i) {
            orthogonalMatrix[i] = FloatArrayMath.scale(orthogonalMatrix[i], (float)Math.sqrt(oneOverNormSquaredArray[i]));
        }
        return orthogonalMatrix;
    }

    public static final float[][][] qr(float[][] matrix) {
        int columns = FloatMatrixMath._columns(matrix);
        Object[] orthoRowInfo = FloatMatrixMath._orthogonalizeRows(FloatMatrixMath.transpose(matrix));
        float[][] qT = (float[][])orthoRowInfo[0];
        float[][] dotProducts = (float[][])orthoRowInfo[1];
        float[] oneOverNormSquaredArray = (float[])orthoRowInfo[2];
        Integer nullity = (Integer)orthoRowInfo[3];
        if (nullity > 0) {
            throw new IllegalArgumentException("qr() : not all column vectors are linearly independent.");
        }
        for (int i = 0; i < columns; ++i) {
            float oneOverNorm = (float)Math.sqrt(oneOverNormSquaredArray[i]);
            qT[i] = FloatArrayMath.scale(qT[i], oneOverNorm);
            int j = i;
            while (j < columns) {
                float[] fArray = dotProducts[i];
                int n = j++;
                fArray[n] = fArray[n] * oneOverNorm;
            }
        }
        return new float[][][]{FloatMatrixMath.transpose(qT), dotProducts};
    }

    public static final float[][] subtract(float[][] matrix1, float[][] matrix2) {
        FloatMatrixMath._checkSameDimension("subtract", matrix1, matrix2);
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] - matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final float sum(float[][] matrix) {
        float sum = 0.0f;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                sum += matrix[i][j];
            }
        }
        return sum;
    }

    public static final Complex[][] toComplexMatrix(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = new Complex(matrix[i][j], 0.0);
            }
        }
        return returnValue;
    }

    public static final double[][] toDoubleMatrix(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] toIntegerMatrix(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = (int)matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final long[][] toLongMatrix(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = (long)matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final float[][] toMatrixFromArray(float[] array, int rows, int cols) {
        float[][] returnValue = new float[rows][cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(array, i * cols, returnValue[i], 0, cols);
        }
        return returnValue;
    }

    public static final String toString(float[][] matrix) {
        return FloatMatrixMath.toString(matrix, ", ", "{", "}", "{", ", ", "}");
    }

    public static final String toString(float[][] matrix, String elementDelimiter, String matrixBegin, String matrixEnd, String vectorBegin, String vectorDelimiter, String vectorEnd) {
        StringBuffer sb = new StringBuffer();
        sb.append(matrixBegin);
        for (int i = 0; i < FloatMatrixMath._rows(matrix); ++i) {
            sb.append(vectorBegin);
            for (int j = 0; j < FloatMatrixMath._columns(matrix); ++j) {
                sb.append(Float.toString(matrix[i][j]));
                if (j >= FloatMatrixMath._columns(matrix) - 1) continue;
                sb.append(elementDelimiter);
            }
            sb.append(vectorEnd);
            if (i >= FloatMatrixMath._rows(matrix) - 1) continue;
            sb.append(vectorDelimiter);
        }
        sb.append(matrixEnd);
        return new String(sb);
    }

    public static final float trace(float[][] matrix) {
        int dim = FloatMatrixMath._checkSquare("trace", matrix);
        float sum = 0.0f;
        for (int i = 0; i < dim; ++i) {
            sum += matrix[i][i];
        }
        return sum;
    }

    public static final float[][] transpose(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[columns][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[j][i] = matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final boolean within(float[][] matrix1, float[][] matrix2, float distance) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        FloatMatrixMath._checkSameDimension("within", matrix1, matrix2);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (!(matrix1[i][j] > matrix2[i][j] + distance) && !(matrix1[i][j] < matrix2[i][j] - distance)) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean within(float[][] matrix1, float[][] matrix2, float[][] errorMatrix) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        FloatMatrixMath._checkSameDimension("within", matrix1, matrix2);
        FloatMatrixMath._checkSameDimension("within", matrix1, errorMatrix);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (!(matrix1[i][j] > matrix2[i][j] + errorMatrix[i][j]) && !(matrix1[i][j] < matrix2[i][j] - errorMatrix[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    protected static final void _checkSameDimension(String caller, float[][] matrix1, float[][] matrix2) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        if (rows != FloatMatrixMath._rows(matrix2) || columns != FloatMatrixMath._columns(matrix2)) {
            throw new IllegalArgumentException("ptolemy.math.FloatMatrixMath." + caller + "() : one matrix " + FloatMatrixMath._dimensionString(matrix1) + " is not the same size as another matrix " + FloatMatrixMath._dimensionString(matrix2) + ".");
        }
    }

    protected static final int _checkSquare(String caller, float[][] matrix) {
        if (FloatMatrixMath._rows(matrix) != FloatMatrixMath._columns(matrix)) {
            throw new IllegalArgumentException("ptolemy.math.FloatMatrixMath." + caller + "() : matrix argument " + FloatMatrixMath._dimensionString(matrix) + " is not a square matrix.");
        }
        return FloatMatrixMath._rows(matrix);
    }

    protected static final int _columns(float[][] matrix) {
        return matrix[0].length;
    }

    protected static final String _dimensionString(float[][] matrix) {
        return "[" + FloatMatrixMath._rows(matrix) + " x " + FloatMatrixMath._columns(matrix) + "]";
    }

    protected static final Object[] _orthogonalizeRows(float[][] rowArrays) {
        int rows = rowArrays.length;
        int columns = rowArrays[0].length;
        int nullity = 0;
        float[][] orthogonalMatrix = new float[rows][];
        float[] oneOverNormSquaredArray = new float[rows];
        float[][] dotProductMatrix = new float[rows][rows];
        for (int i = 0; i < rows; ++i) {
            float[] refArray;
            float[] rowArray = refArray = rowArrays[i];
            for (int j = 0; j < i; ++j) {
                float dotProduct;
                dotProductMatrix[j][i] = dotProduct = FloatArrayMath.dotProduct(refArray, orthogonalMatrix[j]);
                rowArray = FloatArrayMath.subtract(rowArray, FloatArrayMath.scale(orthogonalMatrix[j], dotProduct * oneOverNormSquaredArray[j]));
            }
            dotProductMatrix[i][i] = FloatArrayMath.dotProduct(refArray, rowArray);
            float normSquared = FloatArrayMath.sumOfSquares(rowArray);
            if (normSquared == 0.0f) {
                orthogonalMatrix[i] = i == 0 ? new float[columns] : rowArray;
                oneOverNormSquaredArray[i] = 0.0f;
                ++nullity;
                continue;
            }
            orthogonalMatrix[i] = rowArray;
            oneOverNormSquaredArray[i] = 1.0f / normSquared;
        }
        return new Object[]{orthogonalMatrix, dotProductMatrix, oneOverNormSquaredArray, nullity};
    }

    protected static final int _rows(float[][] matrix) {
        return matrix.length;
    }
}

