/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.media.javasound;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import ptolemy.media.javasound.LiveSoundEvent;
import ptolemy.media.javasound.LiveSoundListener;

public class LiveSound {
    private static double[][] _audioInDoubleArray;
    private static int _bitsPerSample;
    private static int _bufferSize;
    private static int _bytesPerSample;
    private static boolean _captureIsActive;
    private static int _channels;
    private static byte[] _captureData;
    private static byte[] _playbackData;
    private static List _liveSoundListeners;
    private static double _maxSampleReciprocal;
    private static double _maxSample;
    private static boolean _playbackIsActive;
    private static float _sampleRate;
    private static List _soundConsumers;
    private static SourceDataLine _sourceLine;
    private static TargetDataLine _targetLine;
    private static int _transferSize;

    public static void addLiveSoundListener(LiveSoundListener listener) {
        if (!_liveSoundListeners.contains(listener)) {
            _liveSoundListeners.add(listener);
        }
    }

    public static void flushCaptureBuffer(Object consumer) throws IOException, IllegalStateException {
        if (!LiveSound.isCaptureActive()) {
            throw new IllegalStateException("Object: " + consumer.toString() + " attempted to call LiveSound.flushCaptureBuffer(), but " + "capture is inactive.  Try to startCapture().");
        }
        if (!_soundConsumers.contains(consumer)) {
            throw new IOException("Object: " + consumer.toString() + " attempted to call LiveSound.flushCaptureBuffer(), but " + "this object does not have permission to access the " + "audio capture resource.");
        }
        LiveSound._flushCaptureBuffer();
    }

    public static void flushPlaybackBuffer(Object producer) throws IOException, IllegalStateException {
        LiveSound._flushPlaybackBuffer();
    }

    public static int getBitsPerSample() {
        return _bitsPerSample;
    }

    public static int getBufferSize() {
        return _bufferSize;
    }

    public static int getBufferSizeCapture() throws IllegalStateException {
        if (_targetLine != null) {
            return _targetLine.getBufferSize() / (_bytesPerSample * _channels);
        }
        throw new IllegalStateException("LiveSound: getBufferSizeCapture(), capture is probably inactive.Try to startCapture().");
    }

    public static int getBufferSizePlayback() {
        if (_sourceLine != null) {
            return _sourceLine.getBufferSize() / (_bytesPerSample * _channels);
        }
        return _bufferSize;
    }

    public static int getChannels() {
        return _channels;
    }

    public static int getSampleRate() {
        return (int)_sampleRate;
    }

    public static double[][] getSamples(Object consumer) throws IOException, IllegalStateException {
        if (!LiveSound.isCaptureActive()) {
            throw new IllegalStateException("Object: " + consumer.toString() + " attempted to call LiveSound.getSamples(), but " + "capture is inactive.  Try to startCapture().");
        }
        if (!_soundConsumers.contains(consumer)) {
            throw new IOException("Object: " + consumer.toString() + " attempted to call LiveSound.getSamples(), but " + "this object does not have permission to access the " + "audio capture resource.");
        }
        int numBytesRead = _targetLine.read(_captureData, 0, _captureData.length);
        if (_channels != _audioInDoubleArray.length || _transferSize != _audioInDoubleArray[0].length) {
            _audioInDoubleArray = new double[_channels][_transferSize];
        }
        if (numBytesRead == _captureData.length) {
            LiveSound._byteArrayToDoubleArray(_audioInDoubleArray, _captureData);
            return _audioInDoubleArray;
        }
        throw new IOException("Failed to capture correct number of bytes");
    }

    public static int getTransferSize() {
        return _transferSize;
    }

    public static boolean isCaptureActive() {
        return _captureIsActive;
    }

    public static boolean isPlaybackActive() {
        return _playbackIsActive;
    }

    public static void putSamples(Object producer, double[][] samplesArray) throws IOException, IllegalStateException {
        if (!LiveSound.isPlaybackActive()) {
            throw new IllegalStateException("Object: " + producer.toString() + " attempted to call LiveSound.putSamples(), but " + "playback is inactive.  Try to startPlayback().");
        }
        byte[] playbackData = LiveSound._doubleArrayToByteArray(samplesArray);
        int written = _sourceLine.write(playbackData, 0, playbackData.length);
        if (written != playbackData.length) {
            System.out.println("dropped samples!");
        }
    }

    public static void removeLiveSoundListener(LiveSoundListener listener) {
        if (_liveSoundListeners.contains(listener)) {
            _liveSoundListeners.remove(listener);
        }
    }

    public static void resetCapture() {
        if (_targetLine != null && _targetLine.isOpen()) {
            _targetLine.stop();
            _targetLine.close();
            _targetLine = null;
        }
        _captureIsActive = false;
    }

    public static void resetPlayback() {
        LiveSound._stopPlayback();
        _playbackIsActive = false;
    }

    public static void setBitsPerSample(int bitsPerSample) throws IOException {
        _bitsPerSample = bitsPerSample;
        _bytesPerSample = _bitsPerSample / 8;
        switch (_bytesPerSample) {
            case 1: {
                _maxSampleReciprocal = 0.0078125;
                _maxSample = 127.0;
                break;
            }
            case 2: {
                _maxSampleReciprocal = 3.0517578125E-5;
                _maxSample = 32767.0;
                break;
            }
            case 3: {
                _maxSampleReciprocal = 1.1920928955078125E-7;
                _maxSample = 8388607.0;
                break;
            }
            case 4: {
                _maxSampleReciprocal = 6.780412700396453E-18;
                _maxSample = 1.47483647E17;
                break;
            }
            default: {
                _maxSampleReciprocal = 0.0;
            }
        }
        if (_captureIsActive && _playbackIsActive) {
            LiveSound._stopCapture();
            LiveSound._stopPlayback();
            LiveSound._startCapture();
            LiveSound._startPlayback();
        } else if (_captureIsActive) {
            LiveSound._stopCapture();
            LiveSound._startCapture();
        } else if (_playbackIsActive) {
            LiveSound._stopPlayback();
            LiveSound._startPlayback();
        }
        LiveSound._notifyLiveSoundListeners(3);
    }

    public static void setBufferSize(int bufferSize) throws IOException {
        _bufferSize = bufferSize;
        if (_captureIsActive && _playbackIsActive) {
            LiveSound._stopCapture();
            LiveSound._stopPlayback();
            LiveSound._startCapture();
            LiveSound._startPlayback();
        } else if (_captureIsActive) {
            LiveSound._stopCapture();
            LiveSound._startCapture();
        } else if (_playbackIsActive) {
            LiveSound._stopPlayback();
            LiveSound._startPlayback();
        }
        LiveSound._notifyLiveSoundListeners(2);
    }

    public static void setChannels(int channels) throws IOException {
        _channels = channels;
        if (_captureIsActive && _playbackIsActive) {
            LiveSound._stopCapture();
            LiveSound._stopPlayback();
            LiveSound._startCapture();
            LiveSound._startPlayback();
        } else if (_captureIsActive) {
            LiveSound._stopCapture();
            LiveSound._startCapture();
        } else if (_playbackIsActive) {
            LiveSound._stopPlayback();
            LiveSound._startPlayback();
        }
        LiveSound._notifyLiveSoundListeners(1);
    }

    public static void setSampleRate(int sampleRate) throws IOException {
        _sampleRate = sampleRate;
        if (_captureIsActive && _playbackIsActive) {
            LiveSound._stopCapture();
            LiveSound._stopPlayback();
            LiveSound._startCapture();
            LiveSound._startPlayback();
        } else if (_captureIsActive) {
            LiveSound._stopCapture();
            LiveSound._startCapture();
        } else if (_playbackIsActive) {
            LiveSound._stopPlayback();
            LiveSound._startPlayback();
        }
        LiveSound._notifyLiveSoundListeners(0);
    }

    public static void setTransferSize(int transferSize) throws IllegalStateException {
        if (_captureIsActive) {
            throw new IllegalStateException("LiveSound: setTransferSize() was called while audio capture or playback was active.");
        }
        _transferSize = transferSize;
    }

    public static void startCapture(Object consumer) throws IOException, IllegalStateException {
        if (_soundConsumers.size() > 0) {
            throw new IOException("Object: " + consumer.toString() + " is not allowed to start audio capture because " + "another object currently has access to the audio " + "capture resources.");
        }
        if (_soundConsumers.contains(consumer)) {
            throw new IllegalStateException("Object: " + consumer.toString() + " attempted to call LiveSound.startCapture() while " + "audio capture was active.");
        }
        _soundConsumers.add(consumer);
        if (LiveSound.isPlaybackActive()) {
            LiveSound._stopPlayback();
            LiveSound._startCapture();
            LiveSound._startPlayback();
        } else {
            LiveSound._startCapture();
        }
        _captureIsActive = true;
    }

    public static void startPlayback(Object producer) throws IOException, IllegalStateException {
        if (!_playbackIsActive) {
            LiveSound._startPlayback();
            _playbackIsActive = true;
        }
    }

    public static void stopCapture(Object consumer) throws IOException, IllegalStateException {
        if (!_soundConsumers.contains(consumer)) {
            throw new IOException("Object: " + consumer.toString() + " attempted to call LiveSound.stopCapture(), but " + "never called LiveSound.startCapture().");
        }
        _soundConsumers.remove(consumer);
        LiveSound._stopCapture();
        _captureIsActive = false;
    }

    public static void stopPlayback(Object producer) throws IOException, IllegalStateException {
        if (_playbackIsActive) {
            LiveSound._stopPlayback();
        }
        _playbackIsActive = false;
    }

    private static void _byteArrayToDoubleArray(double[][] doubleArray, byte[] byteArray) {
        int lengthInSamples = byteArray.length / (_bytesPerSample * _channels);
        for (int currSamp = 0; currSamp < lengthInSamples; ++currSamp) {
            for (int currChannel = 0; currChannel < _channels; ++currChannel) {
                int j = currSamp * _bytesPerSample * _channels + _bytesPerSample * currChannel;
                int result = byteArray[j++];
                switch (_bytesPerSample) {
                    case 4: {
                        result <<= 8;
                        result += byteArray[j++] | 0xFF;
                    }
                    case 3: {
                        result <<= 8;
                        result += byteArray[j++] | 0xFF;
                    }
                    case 2: {
                        result <<= 8;
                        result += byteArray[j++] | 0xFF;
                    }
                }
                doubleArray[currChannel][currSamp] = (double)result * _maxSampleReciprocal;
            }
        }
    }

    private static byte[] _doubleArrayToByteArray(double[][] doubleArray) throws IllegalArgumentException {
        int numberOfSamples = doubleArray[0].length;
        int bufferSize = numberOfSamples * _bytesPerSample * _channels;
        if (_playbackData == null || _playbackData.length != bufferSize) {
            _playbackData = new byte[bufferSize];
        }
        for (int currSamp = 0; currSamp < doubleArray[0].length; ++currSamp) {
            for (int currChannel = 0; currChannel < _channels; ++currChannel) {
                double sample = doubleArray[currChannel][currSamp];
                if (sample > 1.0) {
                    sample = 1.0;
                } else if (sample < -1.0) {
                    sample = -1.0;
                }
                int intValue = (int)Math.floor(sample * _maxSample);
                int base = currSamp * _bytesPerSample * _channels + _bytesPerSample * currChannel;
                switch (_bytesPerSample) {
                    case 4: {
                        LiveSound._playbackData[base + 3] = (byte)intValue;
                        intValue >>>= 8;
                    }
                    case 3: {
                        LiveSound._playbackData[base + 2] = (byte)intValue;
                        intValue >>>= 8;
                    }
                    case 2: {
                        LiveSound._playbackData[base + 1] = (byte)intValue;
                        intValue >>>= 8;
                    }
                    case 1: {
                        LiveSound._playbackData[base] = (byte)intValue;
                    }
                }
            }
        }
        return _playbackData;
    }

    private static String _encodings(AudioFormat format) {
        AudioFormat.Encoding[] encodings = AudioSystem.getTargetEncodings(format);
        StringBuffer encodingDescriptions = new StringBuffer();
        for (int i = 0; i < encodings.length; ++i) {
            encodingDescriptions.append(encodings[i] + "\n");
            AudioFormat[] formats = AudioSystem.getTargetFormats(encodings[i], format);
            for (int j = 0; j < formats.length; ++j) {
                encodingDescriptions.append("  " + formats[j] + "\n");
            }
        }
        return encodingDescriptions.toString();
    }

    private static void _flushCaptureBuffer() {
        _targetLine.flush();
    }

    private static void _flushPlaybackBuffer() {
        _sourceLine.flush();
    }

    private static void _notifyLiveSoundListeners(int parameter) {
        if (_liveSoundListeners.size() > 0) {
            LiveSoundEvent event = new LiveSoundEvent(parameter);
            Iterator listeners = _liveSoundListeners.iterator();
            while (listeners.hasNext()) {
                ((LiveSoundListener)listeners.next()).liveSoundChanged(event);
            }
        }
    }

    private static void _startCapture() throws IOException {
        boolean signed = true;
        boolean bigEndian = true;
        AudioFormat format = new AudioFormat(_sampleRate, _bitsPerSample, _channels, signed, bigEndian);
        DataLine.Info targetInfo = new DataLine.Info(TargetDataLine.class, format, -1);
        try {
            _targetLine = (TargetDataLine)AudioSystem.getLine(targetInfo);
            _targetLine.open(format, _bufferSize * _bytesPerSample * _channels);
        }
        catch (IllegalArgumentException ex) {
            IOException exception = new IOException("Incorrect argument, possible encodings for\n" + format + "\n are:\n" + LiveSound._encodings(format));
            exception.initCause(ex);
            throw exception;
        }
        catch (LineUnavailableException ex2) {
            throw new IOException("Unable to open the line for real-time audio capture: " + ex2);
        }
        _captureData = new byte[_transferSize * _bytesPerSample * _channels];
        _audioInDoubleArray = new double[_channels][_transferSize];
        _targetLine.start();
    }

    private static void _startPlayback() throws IOException {
        boolean signed = true;
        boolean bigEndian = true;
        AudioFormat format = new AudioFormat(_sampleRate, _bitsPerSample, _channels, signed, bigEndian);
        try {
            _sourceLine = AudioSystem.getSourceDataLine(format);
            _sourceLine.open(format, _bufferSize * _bytesPerSample * _channels);
        }
        catch (IllegalArgumentException ex) {
            IOException exception = new IOException("Incorrect argument, possible encodings for\n" + format + "\n are:\n" + LiveSound._encodings(format));
            exception.initCause(ex);
            throw exception;
        }
        catch (LineUnavailableException ex) {
            throw new IOException("Unable to open the line for real-time audio playback: " + ex);
        }
        _sourceLine.start();
    }

    private static void _stopPlayback() {
        if (_sourceLine != null) {
            _sourceLine.drain();
            _sourceLine.stop();
            _sourceLine.close();
        }
        _sourceLine = null;
    }

    private static void _stopCapture() {
        if (_targetLine != null && _targetLine.isOpen()) {
            _targetLine.stop();
            _targetLine.close();
            _targetLine = null;
        }
    }

    static {
        _bitsPerSample = 16;
        _bufferSize = 1024;
        _bytesPerSample = 2;
        _captureIsActive = false;
        _channels = 1;
        _liveSoundListeners = new LinkedList();
        _maxSampleReciprocal = 3.0517578125E-5;
        _maxSample = 32767.0;
        _playbackIsActive = false;
        _soundConsumers = new LinkedList();
        _transferSize = 128;
    }
}

