/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.Actor;
import ptolemy.actor.ActorFiringListener;
import ptolemy.actor.Director;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.FiringsRecordable;
import ptolemy.actor.IOPort;
import ptolemy.actor.Initializable;
import ptolemy.actor.Manager;
import ptolemy.actor.Receiver;
import ptolemy.actor.util.FunctionDependency;
import ptolemy.actor.util.FunctionDependencyOfAtomicActor;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class AtomicActor
extends ComponentEntity
implements Actor,
FiringsRecordable {
    protected LinkedList _actorFiringListeners = null;
    protected transient List<Initializable> _initializables;
    protected boolean _notifyingActorFiring = false;
    protected boolean _stopRequested = false;
    private transient long _inputPortsVersion = -1L;
    private transient List _cachedInputPorts;
    private transient long _outputPortsVersion = -1L;
    private transient List _cachedOutputPorts;
    private FunctionDependency _functionDependency;
    private long _receiversVersion = -1L;

    public AtomicActor() {
    }

    public AtomicActor(Workspace workspace) {
        super(workspace);
    }

    public AtomicActor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public void addInitializable(Initializable initializable) {
        if (this._initializables == null) {
            this._initializables = new LinkedList<Initializable>();
        }
        this._initializables.add(initializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActorFiringListener(ActorFiringListener listener) {
        Cloneable cloneable = this;
        synchronized (cloneable) {
            if (this._actorFiringListeners == null) {
                this._actorFiringListeners = new LinkedList();
            }
        }
        cloneable = this._actorFiringListeners;
        synchronized (cloneable) {
            if (this._actorFiringListeners.contains(listener)) {
                return;
            }
            this._actorFiringListeners.add(listener);
            this._notifyingActorFiring = true;
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        AtomicActor newObject = (AtomicActor)super.clone(workspace);
        newObject._inputPortsVersion = -1L;
        newObject._outputPortsVersion = -1L;
        newObject._functionDependency = null;
        return newObject;
    }

    @Override
    public void connectionsChanged(Port port) {
        IOPort castPort;
        if (this._debugging) {
            this._debug("Connections changed on port: " + port.getName());
        }
        if (port instanceof IOPort && (castPort = (IOPort)port).isInput() && this.getDirector() != null) {
            try {
                this.workspace().getWriteAccess();
                castPort.createReceivers();
            }
            catch (IllegalActionException ex) {
                throw new InternalErrorException("cannot create receivers.");
            }
            finally {
                this.workspace().doneWriting();
            }
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called fire()");
        }
    }

    @Override
    public Director getDirector() {
        NamedObj container = this.getContainer();
        if (container instanceof Actor) {
            return ((Actor)((Object)container)).getDirector();
        }
        return null;
    }

    @Override
    public Director getExecutiveDirector() {
        return this.getDirector();
    }

    @Override
    public FunctionDependency getFunctionDependency() {
        if (this._functionDependency == null) {
            try {
                this._functionDependency = new FunctionDependencyOfAtomicActor(this);
            }
            catch (NameDuplicationException e) {
                throw new InternalErrorException("Failed to construct a function dependency object for " + this.getFullName());
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException("Failed to construct a function dependency object for " + this.getFullName());
            }
        }
        return this._functionDependency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manager getManager() {
        try {
            this._workspace.getReadAccess();
            NamedObj container = this.getContainer();
            if (container instanceof Actor) {
                Manager manager = ((Actor)((Object)container)).getManager();
                return manager;
            }
            Manager manager = null;
            return manager;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called initialize()");
        }
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.initialize();
            }
        }
        this._receiversVersion = this.workspace().getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List inputPortList() {
        if (this._inputPortsVersion != this._workspace.getVersion()) {
            try {
                this._workspace.getReadAccess();
                LinkedList<IOPort> inputPorts = new LinkedList<IOPort>();
                for (IOPort p : this.portList()) {
                    if (!p.isInput()) continue;
                    inputPorts.add(p);
                }
                this._cachedInputPorts = new ArrayList(inputPorts);
                this._inputPortsVersion = this._workspace.getVersion();
            }
            finally {
                this._workspace.doneReading();
            }
        }
        return this._cachedInputPorts;
    }

    @Override
    public boolean isFireFunctional() {
        return true;
    }

    @Override
    public boolean isStrict() {
        return true;
    }

    @Override
    public int iterate(int count) throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called iterate(" + count + ")");
        }
        int n = 0;
        while (n++ < count && !this._stopRequested) {
            if (this._notifyingActorFiring) {
                this._actorFiring(FiringEvent.BEFORE_PREFIRE, n);
            }
            if (this.prefire()) {
                if (this._notifyingActorFiring) {
                    this._actorFiring(FiringEvent.AFTER_PREFIRE, n);
                    this._actorFiring(FiringEvent.BEFORE_FIRE, n);
                }
                this.fire();
                if (this._notifyingActorFiring) {
                    this._actorFiring(FiringEvent.AFTER_FIRE, n);
                    this._actorFiring(FiringEvent.BEFORE_POSTFIRE, n);
                }
                boolean pfire = this.postfire();
                if (this._notifyingActorFiring) {
                    this._actorFiring(FiringEvent.AFTER_POSTFIRE, n);
                }
                if (pfire) continue;
                return 2;
            }
            if (this._notifyingActorFiring) {
                this._actorFiring(FiringEvent.AFTER_PREFIRE, n);
            }
            return 1;
        }
        if (this._stopRequested) {
            return 2;
        }
        return 0;
    }

    @Override
    public Port newPort(String name) throws NameDuplicationException {
        try {
            IOPort port;
            this._workspace.getWriteAccess();
            IOPort iOPort = port = new IOPort(this, name);
            return iOPort;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(this, (Throwable)ex, null);
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    @Override
    public Receiver newReceiver() throws IllegalActionException {
        Director director = this.getDirector();
        if (director == null) {
            throw new IllegalActionException((Nameable)this, "Cannot create a receiver without a director.");
        }
        return director.newReceiver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List outputPortList() {
        if (this._outputPortsVersion != this._workspace.getVersion()) {
            try {
                this._workspace.getReadAccess();
                LinkedList<IOPort> outputPorts = new LinkedList<IOPort>();
                for (IOPort p : this.portList()) {
                    if (!p.isOutput()) continue;
                    outputPorts.add(p);
                }
                this._cachedOutputPorts = new ArrayList(outputPorts);
                this._outputPortsVersion = this._workspace.getVersion();
            }
            finally {
                this._workspace.doneReading();
            }
        }
        return this._cachedOutputPorts;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called postfire()");
        }
        return !this._stopRequested;
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called prefire()");
        }
        return true;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called preinitialize()");
        }
        this._stopRequested = false;
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.preinitialize();
            }
        }
        if (this.workspace().getVersion() != this._receiversVersion) {
            this._createReceivers();
        }
    }

    public void pruneDependencies() {
    }

    @Override
    public void recordFiring(FiringEvent.FiringEventType type) {
        this._actorFiring(new FiringEvent(null, this, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActorFiringListener(ActorFiringListener listener) {
        if (this._actorFiringListeners == null) {
            return;
        }
        LinkedList linkedList = this._actorFiringListeners;
        synchronized (linkedList) {
            this._actorFiringListeners.remove(listener);
            if (this._actorFiringListeners.size() == 0) {
                this._notifyingActorFiring = false;
            }
            return;
        }
    }

    public void removeDependency(IOPort input, IOPort output) {
        FunctionDependencyOfAtomicActor functionDependency = (FunctionDependencyOfAtomicActor)this.getFunctionDependency();
        functionDependency.removeDependency(input, output);
    }

    @Override
    public void removeInitializable(Initializable initializable) {
        if (this._initializables != null) {
            this._initializables.remove(initializable);
            if (this._initializables.size() == 0) {
                this._initializables = null;
            }
        }
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        Director oldDirector = this.getDirector();
        if (oldDirector != null) {
            oldDirector.invalidateSchedule();
            oldDirector.invalidateResolvedTypes();
        }
        super.setContainer(container);
        Director director = this.getDirector();
        if (director != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
        }
    }

    @Override
    public void stop() {
        this._stopRequested = true;
        if (this._debugging) {
            this._debug("Called stop()");
        }
    }

    @Override
    public void stopFire() {
        if (this._debugging) {
            this._debug("Called stopFire()");
        }
    }

    @Override
    public void terminate() {
        if (this._debugging) {
            this._debug("Called terminate()");
        }
        this.stop();
    }

    @Override
    public void wrapup() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called wrapup()");
        }
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.wrapup();
            }
        }
    }

    protected final void _actorFiring(FiringEvent event) {
        if (this._notifyingActorFiring) {
            Iterator listeners = this._actorFiringListeners.iterator();
            while (listeners.hasNext()) {
                ((ActorFiringListener)listeners.next()).firingEvent(event);
            }
        }
    }

    protected final void _actorFiring(FiringEvent.FiringEventType type, int multiplicity) {
        this._actorFiring(new FiringEvent(null, this, type, multiplicity));
    }

    @Override
    protected void _addPort(Port port) throws IllegalActionException, NameDuplicationException {
        if (!(port instanceof IOPort)) {
            throw new IllegalActionException((Nameable)this, port, "Incompatible port class for this entity.");
        }
        super._addPort(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _createReceivers() throws IllegalActionException {
        Iterator inputPorts = this.inputPortList().iterator();
        try {
            this.workspace().getWriteAccess();
            while (inputPorts.hasNext()) {
                IOPort inputPort = (IOPort)inputPorts.next();
                inputPort.createReceivers();
            }
        }
        finally {
            this.workspace().doneWriting();
        }
    }
}

