/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.AtomicActor;
import ptolemy.actor.Director;
import ptolemy.actor.TypedActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.type.Typeable;
import ptolemy.graph.Inequality;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class TypedAtomicActor
extends AtomicActor
implements TypedActor {
    public TypedAtomicActor() {
    }

    public TypedAtomicActor(Workspace workspace) {
        super(workspace);
    }

    public TypedAtomicActor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public void attributeTypeChanged(Attribute attribute) throws IllegalActionException {
        Director director = this.getDirector();
        if (director != null) {
            director.invalidateResolvedTypes();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in actors, call clone(Workspace workspace) instead. Sometimes actors are mistakenly written to have a clone() method instead of a clone(Workspace workspace) method.");
    }

    @Override
    public Port newPort(String name) throws NameDuplicationException {
        try {
            TypedIOPort port;
            this._workspace.getWriteAccess();
            TypedIOPort typedIOPort = port = new TypedIOPort(this, name);
            return typedIOPort;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(this, (Throwable)ex, null);
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List typeConstraintList() {
        try {
            this._workspace.getReadAccess();
            LinkedList<Inequality> result = new LinkedList<Inequality>();
            for (TypedIOPort inPort : this.inputPortList()) {
                boolean isUndeclared = inPort.getTypeTerm().isSettable();
                if (!isUndeclared) continue;
                for (TypedIOPort outPort : this.outputPortList()) {
                    isUndeclared = outPort.getTypeTerm().isSettable();
                    if (!isUndeclared || inPort == outPort) continue;
                    List inPortConstraints = inPort.typeConstraintList();
                    List outPortConstraints = outPort.typeConstraintList();
                    if (!inPortConstraints.isEmpty() || !outPortConstraints.isEmpty()) continue;
                    Inequality inequality = new Inequality(inPort.getTypeTerm(), outPort.getTypeTerm());
                    result.add(inequality);
                }
            }
            for (Typeable port : this.portList()) {
                result.addAll(port.typeConstraintList());
            }
            for (Typeable typeable : this.attributeList(Typeable.class)) {
                result.addAll(typeable.typeConstraintList());
            }
            LinkedList<Inequality> linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    @Override
    protected void _addPort(Port port) throws IllegalActionException, NameDuplicationException {
        if (!(port instanceof TypedIOPort)) {
            throw new IllegalActionException((Nameable)this, port, "Incompatible port class for this actor.");
        }
        super._addPort(port);
    }
}

