/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypeConflictException;
import ptolemy.actor.TypedActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.data.expr.ScopeExtender;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.type.Typeable;
import ptolemy.graph.CPO;
import ptolemy.graph.Inequality;
import ptolemy.graph.InequalitySolver;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class TypedCompositeActor
extends CompositeActor
implements TypedActor {
    public TypedCompositeActor() {
        this.setClassName("ptolemy.actor.TypedCompositeActor");
    }

    public TypedCompositeActor(Workspace workspace) {
        super(workspace);
        this.setClassName("ptolemy.actor.TypedCompositeActor");
    }

    public TypedCompositeActor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setClassName("ptolemy.actor.TypedCompositeActor");
    }

    @Override
    public Port newPort(String name) throws NameDuplicationException {
        try {
            TypedIOPort port;
            this.workspace().getWriteAccess();
            TypedIOPort typedIOPort = port = new TypedIOPort(this, name);
            return typedIOPort;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(this, (Throwable)ex, null);
        }
        finally {
            this.workspace().doneWriting();
        }
    }

    @Override
    public ComponentRelation newRelation(String name) throws NameDuplicationException {
        try {
            TypedIORelation relation;
            this.workspace().getWriteAccess();
            TypedIORelation typedIORelation = relation = new TypedIORelation(this, name);
            return typedIORelation;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(this, (Throwable)ex, null);
        }
        finally {
            this.workspace().doneWriting();
        }
    }

    public static void resolveTypes(TypedCompositeActor topLevel) throws TypeConflictException {
        if (topLevel.getContainer() != null) {
            throw new IllegalArgumentException("TypedCompositeActor.resolveTypes: The specified actor is not the top level container.");
        }
        try {
            LinkedList<Inequality> conflicts = new LinkedList<Inequality>();
            LinkedList<Inequality> unacceptable = new LinkedList<Inequality>();
            List typeConflicts = topLevel._checkDeclaredTypes();
            conflicts.addAll(typeConflicts);
            List constraintList = topLevel.typeConstraintList();
            if (constraintList.size() > 0) {
                CPO cpo = TypeLattice.lattice();
                InequalitySolver solver = new InequalitySolver(cpo);
                Iterator constraints = constraintList.iterator();
                solver.addInequalities(constraints);
                try {
                    solver.solveLeast();
                }
                catch (InvalidStateException ex) {
                    throw new InvalidStateException((Nameable)topLevel, (Throwable)ex, "The basic type lattic was: " + TypeLattice.basicLattice());
                }
                block4: for (Inequality inequality : constraintList) {
                    InequalityTerm variable;
                    int i;
                    if (!inequality.isSatisfied(TypeLattice.lattice())) {
                        conflicts.add(inequality);
                        continue;
                    }
                    InequalityTerm[] lesserVariables = inequality.getLesserTerm().getVariables();
                    InequalityTerm[] greaterVariables = inequality.getGreaterTerm().getVariables();
                    boolean added = false;
                    for (i = 0; i < lesserVariables.length; ++i) {
                        variable = lesserVariables[i];
                        if (variable.isValueAcceptable()) continue;
                        unacceptable.add(inequality);
                        added = true;
                        break;
                    }
                    if (added) continue;
                    for (i = 0; i < greaterVariables.length; ++i) {
                        variable = greaterVariables[i];
                        if (variable.isValueAcceptable()) continue;
                        unacceptable.add(inequality);
                        continue block4;
                    }
                }
            }
            if (conflicts.size() > 0) {
                throw new TypeConflictException(conflicts, "Type conflicts occurred in " + topLevel.getFullName() + " on the following inequalities:");
            }
            if (unacceptable.size() > 0) {
                throw new TypeConflictException(unacceptable, "Types resolved to unacceptable types in " + topLevel.getFullName() + " due to the following inequalities:");
            }
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(topLevel, (Throwable)ex, "Type resolution failed because of an error during type inference");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List typeConstraintList() throws IllegalActionException {
        try {
            this.workspace().getReadAccess();
            LinkedList result = new LinkedList();
            if (this.isOpaque()) {
                for (TypedActor actor : this.deepEntityList()) {
                    for (TypedIOPort sourcePort : actor.outputPortList()) {
                        List destinationPorts = sourcePort.sinkPortList();
                        result.addAll(this._typeConstraintsFromTo(sourcePort, destinationPorts));
                    }
                }
                for (TypedIOPort sourcePort : this.inputPortList()) {
                    List destinationPorts = sourcePort.insideSinkPortList();
                    result.addAll(this._typeConstraintsFromTo(sourcePort, destinationPorts));
                }
            }
            for (TypedActor actor : this.entityList()) {
                result.addAll(actor.typeConstraintList());
            }
            for (Typeable port : this.portList()) {
                result.addAll(port.typeConstraintList());
            }
            for (Typeable typeable : this.attributeList(Typeable.class)) {
                result.addAll(typeable.typeConstraintList());
            }
            for (ScopeExtender extender : this.attributeList(ScopeExtender.class)) {
                for (Attribute extenderAttribute : extender.attributeList()) {
                    if (!(extenderAttribute instanceof Variable)) continue;
                    result.addAll(((Variable)extenderAttribute).typeConstraintList());
                }
            }
            LinkedList linkedList = result;
            return linkedList;
        }
        finally {
            this.workspace().doneReading();
        }
    }

    @Override
    protected void _addEntity(ComponentEntity entity) throws IllegalActionException, NameDuplicationException {
        if (!(entity instanceof TypedActor)) {
            throw new IllegalActionException((Nameable)this, entity, "TypedCompositeActor can only contain entities that implement the TypedActor interface.");
        }
        super._addEntity(entity);
    }

    @Override
    protected void _addPort(Port port) throws IllegalActionException, NameDuplicationException {
        if (!(port instanceof TypedIOPort)) {
            throw new IllegalActionException((Nameable)this, port, "TypedCompositeActor can only contain instances of TypedIOPort.");
        }
        super._addPort(port);
    }

    @Override
    protected void _addRelation(ComponentRelation relation) throws IllegalActionException, NameDuplicationException {
        if (!(relation instanceof TypedIORelation)) {
            throw new IllegalActionException((Nameable)this, relation, "TypedCompositeActor can only contain instances of TypedIORelation.");
        }
        super._addRelation(relation);
    }

    protected List _checkTypesFromTo(TypedIOPort sourcePort, List destinationPortList) {
        LinkedList<Inequality> result = new LinkedList<Inequality>();
        boolean isUndeclared = sourcePort.getTypeTerm().isSettable();
        if (!isUndeclared) {
            Type srcDeclared = sourcePort.getType();
            for (TypedIOPort destinationPort : destinationPortList) {
                Type destDeclared;
                int compare;
                isUndeclared = destinationPort.getTypeTerm().isSettable();
                if (isUndeclared || (compare = TypeLattice.compare(srcDeclared, destDeclared = destinationPort.getType())) != 1 && compare != 2) continue;
                Inequality inequality = new Inequality(sourcePort.getTypeTerm(), destinationPort.getTypeTerm());
                result.add(inequality);
            }
        }
        return result;
    }

    protected List _typeConstraintsFromTo(TypedIOPort sourcePort, List destinationPortList) {
        LinkedList<Inequality> result = new LinkedList<Inequality>();
        boolean srcUndeclared = sourcePort.getTypeTerm().isSettable();
        for (TypedIOPort destinationPort : destinationPortList) {
            boolean destUndeclared = destinationPort.getTypeTerm().isSettable();
            if (!srcUndeclared && !destUndeclared) continue;
            Inequality ineq = new Inequality(sourcePort.getTypeTerm(), destinationPort.getTypeTerm());
            result.add(ineq);
        }
        return result;
    }

    private List _checkDeclaredTypes() throws IllegalActionException {
        if (!this.isOpaque()) {
            throw new IllegalActionException((Nameable)this, "Cannot check types on a non-opaque actor.");
        }
        LinkedList result = new LinkedList();
        for (TypedActor actor : this.deepEntityList()) {
            if (actor instanceof TypedCompositeActor) {
                result.addAll(((TypedCompositeActor)actor)._checkDeclaredTypes());
            }
            for (TypedIOPort sourcePort : ((Entity)((Object)actor)).portList()) {
                Receiver[][] receivers = sourcePort.getRemoteReceivers();
                List destinationPorts = this._receiverToPort(receivers);
                result.addAll(this._checkTypesFromTo(sourcePort, destinationPorts));
            }
        }
        for (TypedIOPort sourcePort : this.portList()) {
            Receiver[][] receivers = sourcePort.deepGetReceivers();
            List destinationPorts = this._receiverToPort(receivers);
            result.addAll(this._checkTypesFromTo(sourcePort, destinationPorts));
        }
        return result;
    }

    private List _receiverToPort(Receiver[][] receivers) {
        LinkedList<IOPort> result = new LinkedList<IOPort>();
        if (receivers != null) {
            for (int i = 0; i < receivers.length; ++i) {
                if (receivers[i] == null) continue;
                for (int j = 0; j < receivers[i].length; ++j) {
                    result.add(receivers[i][j].getContainer());
                }
            }
        }
        return result;
    }
}

