/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gt.AtomicActorMatcher;
import ptolemy.actor.gt.Constraint;
import ptolemy.actor.gt.GTIngredient;
import ptolemy.actor.gt.GTIngredientList;
import ptolemy.actor.gt.GraphAnalyzer;
import ptolemy.actor.gt.HierarchyFlatteningAttribute;
import ptolemy.actor.gt.MalformedStringException;
import ptolemy.actor.gt.MatchCallback;
import ptolemy.actor.gt.Pattern;
import ptolemy.actor.gt.PortMatcher;
import ptolemy.actor.gt.RelationCollapsingAttribute;
import ptolemy.actor.gt.TransformationAttribute;
import ptolemy.actor.gt.TransformationRule;
import ptolemy.actor.gt.data.FastLinkedList;
import ptolemy.actor.gt.data.MatchResult;
import ptolemy.actor.gt.data.Pair;
import ptolemy.actor.gt.ingredients.criteria.AttributeCriterion;
import ptolemy.actor.gt.ingredients.criteria.Criterion;
import ptolemy.actor.gt.ingredients.criteria.PortCriterion;
import ptolemy.actor.gt.ingredients.criteria.SubclassCriterion;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLParser;

public class GraphMatcher
extends GraphAnalyzer {
    public static final MatchCallback DEFAULT_CALLBACK = new MatchCallback(){

        @Override
        public boolean foundMatch(GraphMatcher matcher) {
            return true;
        }
    };
    private MatchCallback _callback = DEFAULT_CALLBACK;
    private static final NameComparator _comparator = new NameComparator();
    private LookbackList _lookbackList;
    private MatchResult _match;
    private boolean _success = false;
    private MatchResult _temporaryMatch;

    public MatchResult getMatchResult() {
        return this._match;
    }

    public boolean isSuccessful() {
        return this._success;
    }

    public static void main(String[] args) throws Exception {
        if (!(args.length == 2 || args.length == 3 && args[0].equalsIgnoreCase("-A"))) {
            System.err.println("USAGE: java [-A] " + GraphMatcher.class.getName() + " <rule.xml> <host.xml>");
            System.exit(1);
        }
        final boolean all = args.length == 3 && args[0].equalsIgnoreCase("-A");
        String ruleXMLFile = all ? args[1] : args[0];
        String hostXMLFile = all ? args[2] : args[1];
        MatchCallback matchCallback = new MatchCallback(){
            private int count = 0;

            @Override
            public boolean foundMatch(GraphMatcher matcher) {
                MatchResult match = matcher.getMatchResult();
                System.out.println("--- Match " + ++this.count + " ---");
                GraphMatcher._printMatch(match);
                return !all;
            }
        };
        GraphMatcher.match(ruleXMLFile, hostXMLFile, matchCallback);
    }

    public boolean match(Pattern pattern, CompositeEntity hostGraph) {
        this._match = new MatchResult();
        this._lookbackList = new LookbackList();
        this._temporaryMatch = new MatchResult();
        this._success = this._matchChildrenCompositeEntity(pattern, hostGraph);
        assert (this._lookbackList.isEmpty());
        assert (this._temporaryMatch.isEmpty());
        if (!this._success) assert (this._match.isEmpty());
        this._lookbackList = null;
        return this._success;
    }

    public static GraphMatcher match(String ruleXMLFile, String hostXMLFile) throws Exception {
        return GraphMatcher.match(ruleXMLFile, hostXMLFile, null);
    }

    public static GraphMatcher match(String ruleXMLFile, String hostXMLFile, MatchCallback callback) throws Exception {
        MoMLParser parser = new MoMLParser();
        TransformationRule rule = (TransformationRule)parser.parse(null, new File(ruleXMLFile).toURI().toURL());
        parser.reset();
        CompositeEntity host = (CompositeEntity)parser.parse(null, new File(hostXMLFile).toURI().toURL());
        GraphMatcher matcher = new GraphMatcher();
        if (callback != null) {
            matcher.setMatchCallback(callback);
        }
        matcher.match(rule.getPattern(), host);
        return matcher;
    }

    public void setMatchCallback(MatchCallback callback) {
        this._callback = callback == null ? DEFAULT_CALLBACK : callback;
    }

    @Override
    protected Token _getAttribute(NamedObj container, String name, Class<? extends TransformationAttribute> attributeClass) {
        while (container != null) {
            if (this._match.containsValue(container)) {
                container = (NamedObj)this._match.getKey(container);
            } else if (this._temporaryMatch.containsValue(container)) {
                container = (NamedObj)this._temporaryMatch.getKey(container);
            }
            Attribute attribute = container.getAttribute(name);
            if (attribute != null && attributeClass.isInstance(attribute)) {
                Parameter parameter = (Parameter)attribute.attributeList().get(0);
                try {
                    return parameter == null ? null : parameter.getToken();
                }
                catch (IllegalActionException e) {
                    return null;
                }
            }
            container = container.getContainer();
        }
        return null;
    }

    @Override
    protected boolean _isOpaque(CompositeEntity entity) {
        if (entity instanceof CompositeActor && ((CompositeActor)entity).isOpaque()) {
            return true;
        }
        NamedObj container = entity.getContainer();
        Token value = this._getAttribute(container, "HierarchyFlattening", HierarchyFlatteningAttribute.class);
        boolean isOpaque = value == null ? true : !((BooleanToken)value).booleanValue();
        return isOpaque;
    }

    private boolean _checkBackward() {
        FastLinkedList.Entry entry;
        LookbackEntry lists = null;
        for (entry = this._lookbackList.getTail(); entry != null && (lists = (LookbackEntry)entry.getValue()).isFinished(); entry = entry.getPrevious()) {
        }
        if (entry == null) {
            if (this._checkConstraints()) {
                return this._callback.foundMatch(this);
            }
            return false;
        }
        return this._matchList(lists);
    }

    private boolean _checkConstraint(Pattern pattern, Constraint constraint) {
        return constraint.check(pattern, this._match);
    }

    private boolean _checkConstraints() {
        if (this._match.isEmpty()) {
            return false;
        }
        Iterator iterator = this._match.entrySet().iterator();
        Map.Entry anyEntry = null;
        while (iterator.hasNext() && !((anyEntry = iterator.next()).getKey() instanceof NamedObj)) {
            anyEntry = null;
        }
        if (anyEntry == null) {
            return false;
        }
        NamedObj patternObject = (NamedObj)anyEntry.getKey();
        for (NamedObj patternContainer = patternObject.getContainer(); patternContainer != null && this._match.containsKey(patternContainer); patternContainer = patternContainer.getContainer()) {
            patternObject = patternContainer;
        }
        if (!(patternObject instanceof Pattern)) {
            return true;
        }
        Pattern pattern = (Pattern)patternObject;
        List constraints = pattern.attributeList(Constraint.class);
        for (Object constraintObject : constraints) {
            Constraint constraint = (Constraint)constraintObject;
            if (this._checkConstraint(pattern, constraint)) continue;
            return false;
        }
        return true;
    }

    private static String _getNameString(Object object) {
        return object instanceof NamedObj ? ((NamedObj)object).getFullName() : object.toString();
    }

    private static PortCriterion _getPortRule(Port port) {
        if (port instanceof PortMatcher) {
            return ((PortMatcher)port).getPortCriterion();
        }
        return null;
    }

    private boolean _matchAtomicEntity(ComponentEntity patternActor, ComponentEntity hostActor) {
        int matchSize = this._match.size();
        boolean success = true;
        ObjectList patternList = new ObjectList();
        ObjectList hostList = new ObjectList();
        this._match.put(patternActor, hostActor);
        if (patternActor instanceof AtomicActorMatcher) {
            AtomicActorMatcher matcher = (AtomicActorMatcher)patternActor;
            GTIngredientList ruleList = null;
            try {
                ruleList = matcher.criteria.getIngredientList();
            }
            catch (MalformedStringException e) {
                success = false;
            }
            if (success) {
                GTIngredient rule;
                Iterator i$ = ruleList.iterator();
                while (i$.hasNext() && (!((rule = (GTIngredient)i$.next()) instanceof AttributeCriterion) && !(rule instanceof SubclassCriterion) || (success = ((Criterion)rule).match(hostActor) == GTIngredient.NamedObjMatchResult.MATCH))) {
                }
            }
        } else {
            success = patternActor.getClass().isInstance(hostActor);
        }
        if (success) {
            patternList.addAll(patternActor.portList());
            hostList.addAll(hostActor.portList());
        }
        boolean bl = success = success && this._matchObject(patternList, hostList);
        if (!success) {
            this._match.retain(matchSize);
        }
        return success;
    }

    private boolean _matchChildrenCompositeEntity(CompositeEntity patternEntity, CompositeEntity hostEntity) {
        ObjectList patternList = new ObjectList();
        patternList.add(patternEntity);
        ObjectList hostList = new ObjectList();
        hostList.add(hostEntity);
        GraphAnalyzer.IndexedLists markedList = new GraphAnalyzer.IndexedLists();
        boolean added = true;
        int i = 0;
        FastLinkedList.Entry entry = hostList.getHead();
        while (added) {
            added = false;
            int size = hostList.size();
            while (i < size) {
                markedList.clear();
                hostEntity = (CompositeEntity)entry.getValue();
                NamedObj nextChild = this.findFirstChild(hostEntity, markedList, this._match.keySet());
                while (nextChild != null) {
                    if (nextChild instanceof CompositeEntity) {
                        hostList.add(nextChild);
                        added = true;
                    }
                    nextChild = this.findNextChild(hostEntity, markedList, this._match.keySet());
                }
                entry = entry.getNext();
                ++i;
            }
        }
        return this._matchObject(patternList, hostList);
    }

    private boolean _matchCompositeEntity(CompositeEntity patternEntity, CompositeEntity hostEntity) {
        int matchSize = this._match.size();
        boolean success = true;
        ObjectList patternList = new ObjectList();
        ObjectList hostList = new ObjectList();
        this._match.put(patternEntity, hostEntity);
        Director patternDirector = null;
        Director hostDirector = null;
        if (patternEntity instanceof CompositeActor && ((CompositeActor)patternEntity).isOpaque()) {
            patternDirector = ((CompositeActor)patternEntity).getDirector();
        }
        if (hostEntity instanceof CompositeActor && ((CompositeActor)hostEntity).isOpaque()) {
            hostDirector = ((CompositeActor)hostEntity).getDirector();
        }
        if (patternDirector != null && hostDirector != null) {
            success = this._shallowMatchDirector(patternDirector, hostDirector);
        } else if (patternDirector != null) {
            success = false;
        }
        if (success) {
            GraphAnalyzer.IndexedLists patternMarkedList = new GraphAnalyzer.IndexedLists();
            NamedObj patternNextChild = this.findFirstChild(patternEntity, patternMarkedList, this._match.keySet());
            while (patternNextChild != null) {
                patternList.add(patternNextChild);
                patternNextChild = this.findNextChild(patternEntity, patternMarkedList, this._match.keySet());
            }
            GraphAnalyzer.IndexedLists hostMarkedList = new GraphAnalyzer.IndexedLists();
            NamedObj hostNextObject = this.findFirstChild(hostEntity, hostMarkedList, this._match.values());
            while (hostNextObject != null) {
                hostList.add(hostNextObject);
                hostNextObject = this.findNextChild(hostEntity, hostMarkedList, this._match.values());
            }
        }
        if (success) {
            patternList.addAll(patternEntity.portList());
            hostList.addAll(hostEntity.portList());
        }
        boolean bl = success = success && this._matchObject(patternList, hostList);
        if (!success) {
            this._match.retain(matchSize);
        }
        return success;
    }

    private boolean _matchList(LookbackEntry matchedObjectLists) {
        FastLinkedList.Entry patternEntry;
        ObjectList patternList = matchedObjectLists.getPatternList();
        ObjectList hostList = matchedObjectLists.getHostList();
        int matchSize = this._match.size();
        boolean success = true;
        boolean patternChildChecked = false;
        boolean firstEntrance = !this._match.containsKey(patternList);
        FastLinkedList.Entry lookbackTail = null;
        if (firstEntrance) {
            this._match.put(patternList, hostList);
            this._lookbackList.add(matchedObjectLists);
            lookbackTail = this._lookbackList.getTail();
        }
        if ((patternEntry = patternList.getHead()) != null) {
            patternEntry.remove();
            Object patternObject = patternEntry.getValue();
            patternChildChecked = true;
            success = false;
            FastLinkedList.Entry hostEntryPrevious = null;
            for (FastLinkedList.Entry hostEntry = hostList.getHead(); hostEntry != null; hostEntry = hostEntry.getNext()) {
                hostEntry.remove();
                Object hostObject = hostEntry.getValue();
                if (this._matchObject(patternObject, hostObject)) {
                    success = true;
                    break;
                }
                hostList.addEntryAfter(hostEntry, hostEntryPrevious);
                hostEntryPrevious = hostEntry;
            }
            patternList.addEntryToHead(patternEntry);
        }
        if (success) {
            if (!patternChildChecked) {
                matchedObjectLists.setFinished(true);
                success = this._checkBackward();
                matchedObjectLists.setFinished(false);
                if (!success) {
                    this._match.retain(matchSize);
                    if (firstEntrance) {
                        lookbackTail.remove();
                    }
                }
            }
            return success;
        }
        this._match.retain(matchSize);
        if (firstEntrance) {
            lookbackTail.remove();
        }
        return false;
    }

    private boolean _matchObject(Object patternObject, Object hostObject) {
        Object match = this._match.get(patternObject);
        if (match != null && match.equals(hostObject)) {
            return this._checkBackward();
        }
        if (match != null || this._match.containsValue(hostObject)) {
            return false;
        }
        if (patternObject instanceof CompositeEntity && hostObject instanceof CompositeEntity) {
            return this._matchCompositeEntity((CompositeEntity)patternObject, (CompositeEntity)hostObject);
        }
        if (patternObject instanceof ComponentEntity && hostObject instanceof ComponentEntity) {
            return this._matchAtomicEntity((ComponentEntity)patternObject, (ComponentEntity)hostObject);
        }
        if (patternObject instanceof ObjectList && hostObject instanceof ObjectList) {
            LookbackEntry matchedObjectLists = new LookbackEntry((ObjectList)patternObject, (ObjectList)hostObject);
            return this._matchList(matchedObjectLists);
        }
        if (patternObject instanceof GraphAnalyzer.Path && hostObject instanceof GraphAnalyzer.Path) {
            return this._matchPath((GraphAnalyzer.Path)patternObject, (GraphAnalyzer.Path)hostObject);
        }
        if (patternObject instanceof Port && hostObject instanceof Port) {
            return this._matchPort((Port)patternObject, (Port)hostObject);
        }
        if (patternObject instanceof Relation && hostObject instanceof Relation) {
            return this._matchRelation((Relation)patternObject, (Relation)hostObject);
        }
        return false;
    }

    private boolean _matchPath(GraphAnalyzer.Path patternPath, GraphAnalyzer.Path hostPath) {
        if (!GraphMatcher._shallowMatchPath(patternPath, hostPath)) {
            return false;
        }
        int matchSize = this._match.size();
        boolean success = true;
        this._match.put(patternPath, hostPath);
        Port patternPort = patternPath.getEndPort();
        Port hostPort = hostPath.getEndPort();
        success = this._matchObject(patternPort, hostPort);
        if (!success) {
            this._match.retain(matchSize);
        }
        return success;
    }

    private boolean _matchPort(Port patternPort, Port hostPort) {
        int matchSize = this._match.size();
        boolean success = true;
        NamedObj patternContainer = null;
        NamedObj hostContainer = null;
        this._match.put(patternPort, hostPort);
        if (!GraphMatcher._shallowMatchPort(patternPort, hostPort)) {
            success = false;
        }
        if (success) {
            patternContainer = patternPort.getContainer();
            hostContainer = hostPort.getContainer();
            Object patternObject = this._match.get(patternContainer);
            if (patternObject != null && patternObject != hostContainer) {
                success = false;
            } else {
                Object hostMatch = this._match.getKey(hostContainer);
                if (hostMatch != null && hostMatch != patternContainer) {
                    success = false;
                }
            }
        }
        if (success) {
            boolean collapsing;
            ObjectList patternList = new ObjectList();
            patternList.add(patternContainer);
            ObjectList hostList = new ObjectList();
            hostList.add(hostContainer);
            Token collapsingToken = this._getAttribute(patternContainer.getContainer(), "RelationCollapsing", RelationCollapsingAttribute.class);
            boolean bl = collapsing = collapsingToken == null ? false : ((BooleanToken)collapsingToken).booleanValue();
            if (collapsing) {
                this._temporaryMatch.put(patternContainer, hostContainer);
                GraphAnalyzer.Path patternPath = new GraphAnalyzer.Path(patternPort);
                HashSet<Relation> visitedRelations = new HashSet<Relation>();
                HashSet<Port> visitedPorts = new HashSet<Port>();
                boolean foundPath = this.findFirstPath(patternPort, patternPath, visitedRelations, visitedPorts);
                while (foundPath) {
                    patternList.add(patternPath.clone());
                    foundPath = this.findNextPath(patternPath, visitedRelations, visitedPorts);
                }
                GraphAnalyzer.Path hostPath = new GraphAnalyzer.Path(hostPort);
                visitedRelations = new HashSet();
                visitedPorts = new HashSet();
                foundPath = this.findFirstPath(hostPort, hostPath, visitedRelations, visitedPorts);
                while (foundPath) {
                    hostList.add(hostPath.clone());
                    foundPath = this.findNextPath(hostPath, visitedRelations, visitedPorts);
                }
                this._temporaryMatch.remove(patternContainer);
            } else {
                Relation relation;
                for (Object relationObject : patternPort.linkedRelationList()) {
                    relation = (Relation)relationObject;
                    if (this._ignoreRelation(relation)) continue;
                    patternList.add(relation);
                }
                for (Object relationObject : hostPort.linkedRelationList()) {
                    relation = (Relation)relationObject;
                    if (this._ignoreRelation(relation)) continue;
                    hostList.add(relation);
                }
            }
            success = this._matchObject(patternList, hostList);
        }
        if (!success) {
            this._match.retain(matchSize);
        }
        return success;
    }

    private boolean _matchRelation(Relation patternRelation, Relation hostRelation) {
        int matchSize = this._match.size();
        boolean success = true;
        this._match.put(patternRelation, hostRelation);
        if (!this._shallowMatchRelation(patternRelation, hostRelation)) {
            success = false;
        }
        if (success) {
            ObjectList patternList = new ObjectList();
            patternList.addAll(patternRelation.linkedObjectsList());
            ObjectList hostList = new ObjectList();
            hostList.addAll(hostRelation.linkedObjectsList());
            success = this._matchObject(patternList, hostList);
        }
        if (!success) {
            this._match.retain(matchSize);
        }
        return success;
    }

    private static void _printMatch(MatchResult match) {
        LinkedList keyList = new LinkedList(match.keySet());
        Collections.sort(keyList, _comparator);
        for (Object patternObject : keyList) {
            if (!(patternObject instanceof NamedObj)) continue;
            System.out.println(GraphMatcher._getNameString(patternObject) + " : " + GraphMatcher._getNameString(match.get(patternObject)));
        }
    }

    private boolean _shallowMatchDirector(Director patternDirector, Director hostDirector) {
        if (patternDirector == null && hostDirector == null) {
            return true;
        }
        if (patternDirector == null || hostDirector == null) {
            return false;
        }
        int matchSize = this._match.size();
        this._match.put(patternDirector, hostDirector);
        boolean success = patternDirector.getClass().equals(hostDirector.getClass());
        if (!success) {
            this._match.retain(matchSize);
        }
        return success;
    }

    private static boolean _shallowMatchPath(GraphAnalyzer.Path patternPath, GraphAnalyzer.Path hostPath) {
        Port patternStartPort = patternPath.getStartPort();
        Port hostStartPort = hostPath.getStartPort();
        Port patternEndPort = patternPath.getEndPort();
        Port hostEndPort = hostPath.getEndPort();
        return GraphMatcher._shallowMatchPort(patternStartPort, hostStartPort) && GraphMatcher._shallowMatchPort(patternEndPort, hostEndPort);
    }

    private static boolean _shallowMatchPort(Port patternPort, Port hostPort) {
        if (patternPort instanceof IOPort) {
            if (hostPort instanceof IOPort) {
                IOPort patternIOPort = (IOPort)patternPort;
                IOPort hostIOPort = (IOPort)hostPort;
                PortCriterion portRule = GraphMatcher._getPortRule(patternIOPort);
                if (portRule == null) {
                    boolean isInputEqual = patternIOPort.isInput() == hostIOPort.isInput();
                    boolean isOutputEqual = patternIOPort.isOutput() == hostIOPort.isOutput();
                    boolean isMultiportEqual = patternIOPort.isMultiport() == hostIOPort.isMultiport();
                    boolean isNameEqual = patternIOPort.getName().equals(hostIOPort.getName());
                    boolean isTypeCompatible = true;
                    if (patternIOPort instanceof TypedIOPort) {
                        if (hostIOPort instanceof TypedIOPort) {
                            Type patternType = ((TypedIOPort)patternIOPort).getType();
                            Type hostType = ((TypedIOPort)hostIOPort).getType();
                            if (patternIOPort.isInput() && hostIOPort.isInput()) {
                                boolean bl = isTypeCompatible = isTypeCompatible && hostType.isCompatible(patternType);
                            }
                            if (patternIOPort.isOutput() && hostIOPort.isOutput()) {
                                isTypeCompatible = isTypeCompatible && patternType.isCompatible(hostType);
                            }
                        } else {
                            isTypeCompatible = false;
                        }
                    }
                    return isInputEqual && isOutputEqual && isMultiportEqual && isNameEqual && isTypeCompatible;
                }
                return portRule.match(hostIOPort) == GTIngredient.NamedObjMatchResult.MATCH;
            }
            return true;
        }
        return true;
    }

    private boolean _shallowMatchRelation(Relation patternRelation, Relation hostRelation) {
        return true;
    }

    private static class ObjectList
    extends FastLinkedList<Object> {
        private ObjectList() {
        }
    }

    private static class NameComparator
    implements Comparator<Object>,
    Serializable {
        private NameComparator() {
        }

        @Override
        public int compare(Object object1, Object object2) {
            return GraphMatcher._getNameString(object1).compareTo(GraphMatcher._getNameString(object2));
        }
    }

    private static class LookbackList
    extends FastLinkedList<LookbackEntry> {
        private LookbackList() {
        }
    }

    private static class LookbackEntry
    extends Pair<Pair<ObjectList, ObjectList>, Boolean> {
        public ObjectList getHostList() {
            return (ObjectList)((Pair)this.getFirst()).getSecond();
        }

        public ObjectList getPatternList() {
            return (ObjectList)((Pair)this.getFirst()).getFirst();
        }

        public boolean isFinished() {
            return (Boolean)this.getSecond();
        }

        public void setFinished(boolean finished) {
            this.setSecond(finished);
        }

        LookbackEntry(ObjectList patternList, ObjectList hostList) {
            super(new Pair<ObjectList, ObjectList>(patternList, hostList), false);
        }
    }
}

