/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ActorToken;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.moml.MoMLParser;

public class ModelGenerator
extends TypedAtomicActor {
    public TypedIOPort model;
    public TypedIOPort modelName;
    public TypedIOPort moml;
    private Entity _emptyModel;
    private MoMLParser _parser = new MoMLParser();

    public ModelGenerator(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setClassName("ptolemy.actor.gt.ModelGenerator");
        this.moml = new TypedIOPort(this, "moml", true, false);
        this.moml.setTypeEquals(BaseType.STRING);
        this.modelName = new TypedIOPort(this, "modelName", true, false);
        this.modelName.setTypeEquals(BaseType.STRING);
        this.model = new TypedIOPort(this, "model", false, true);
        this.model.setTypeEquals(ActorToken.TYPE);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ModelGenerator actor = (ModelGenerator)super.clone();
        actor._emptyModel = null;
        actor._parser = new MoMLParser();
        return actor;
    }

    @Override
    public void fire() throws IllegalActionException {
        try {
            Entity entity;
            if (this.moml.getWidth() > 0 && this.moml.hasToken(0)) {
                String momlString = ((StringToken)this.moml.get(0)).stringValue();
                this._parser.reset();
                entity = (Entity)this._parser.parse(momlString);
            } else {
                if (this._emptyModel == null) {
                    this._emptyModel = new TypedCompositeActor(this.workspace());
                }
                entity = this._emptyModel;
            }
            if (this.modelName.getWidth() > 0 && this.modelName.hasToken(0)) {
                String name = ((StringToken)this.modelName.get(0)).stringValue();
                entity.setName(name);
            }
            this.model.send(0, new ActorToken(entity));
        }
        catch (Exception e) {
            throw new IllegalActionException((Nameable)this, "Unable to parse moml.");
        }
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        return super.prefire() && (this.moml.getWidth() > 0 && this.moml.hasToken(0) || this.modelName.getWidth() > 0 && this.modelName.hasToken(0));
    }
}

